/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.sitemap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.AbstractConfiguration;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.SAXConfigurationHandler;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.classloader.reloading.Monitor;
import org.apache.cocoon.components.LifecycleHelper;
import org.apache.cocoon.components.pipeline.impl.PipelineComponentInfo;
import org.apache.cocoon.components.source.util.SourceUtil;
import org.apache.cocoon.components.treeprocessor.AbstractProcessingNode;
import org.apache.cocoon.components.treeprocessor.CategoryNode;
import org.apache.cocoon.components.treeprocessor.CategoryNodeBuilder;
import org.apache.cocoon.components.treeprocessor.ConcreteTreeProcessor;
import org.apache.cocoon.components.treeprocessor.LinkedProcessingNodeBuilder;
import org.apache.cocoon.components.treeprocessor.NodeBuilderSelector;
import org.apache.cocoon.components.treeprocessor.ParameterizableProcessingNode;
import org.apache.cocoon.components.treeprocessor.ProcessingNode;
import org.apache.cocoon.components.treeprocessor.ProcessingNodeBuilder;
import org.apache.cocoon.components.treeprocessor.TreeBuilder;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolver;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolverFactory;
import org.apache.cocoon.configuration.Settings;
import org.apache.cocoon.core.container.spring.avalon.AvalonUtils;
import org.apache.cocoon.core.container.spring.avalon.SitemapHelper;
import org.apache.cocoon.generation.Generator;
import org.apache.cocoon.serialization.Serializer;
import org.apache.cocoon.sitemap.EnterSitemapEventListener;
import org.apache.cocoon.sitemap.LeaveSitemapEventListener;
import org.apache.cocoon.sitemap.PatternException;
import org.apache.cocoon.sitemap.SitemapParameters;
import org.apache.cocoon.util.AbstractLogEnabled;
import org.apache.cocoon.util.location.Location;
import org.apache.cocoon.util.location.LocationImpl;
import org.apache.cocoon.util.location.LocationUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.regexp.RE;
import org.springframework.web.context.WebApplicationContext;
import org.xml.sax.ContentHandler;

public class SitemapLanguage
extends AbstractLogEnabled
implements TreeBuilder,
Contextualizable,
Serviceable,
Recyclable {
    private static final String COMMA_SPLIT_REGEXP = "[\\s]*,[\\s]*";
    private static final String EQUALS_SPLIT_REGEXP = "[\\s]*=[\\s]*";
    protected Map attributes = new HashMap();
    private Context context;
    private ServiceManager manager;
    protected ConcreteTreeProcessor processor;
    protected String itsNamespace;
    private ServiceManager itsManager;
    private WebApplicationContext itsContainer;
    private LifecycleHelper itsLifecycle;
    private NodeBuilderSelector itsBuilders;
    protected PipelineComponentInfo itsComponentInfo;
    protected List enterSitemapEventListeners = new ArrayList();
    protected List leaveSitemapEventListeners = new ArrayList();
    private List initializableNodes = new ArrayList();
    private List disposableNodes = new ArrayList();
    private List linkedBuilders = new ArrayList();
    private boolean canGetNode = false;
    private Map registeredNodes = new HashMap();
    private Map labelViews = new HashMap();
    private CategoryNode viewsNode;
    private boolean isBuildingView = false;
    private boolean isBuildingErrorHandler = false;
    public static final String FIRST_POS_LABEL = "!first!";
    public static final String LAST_POS_LABEL = "!last!";

    public void contextualize(Context avalonContext) throws ContextException {
        this.context = avalonContext;
    }

    public void service(ServiceManager serviceManager) throws ServiceException {
        this.manager = serviceManager;
    }

    protected String getBuilderConfigURL() {
        return "resource://org/apache/cocoon/components/treeprocessor/sitemap-language.xml";
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public void setProcessor(ConcreteTreeProcessor processor) {
        this.processor = processor;
    }

    public ConcreteTreeProcessor getProcessor() {
        return this.processor;
    }

    public WebApplicationContext getWebApplicationContext() {
        return this.itsContainer;
    }

    public List getEnterSitemapEventListeners() {
        return (List)((ArrayList)this.enterSitemapEventListeners).clone();
    }

    public List getLeaveSitemapEventListeners() {
        return (List)((ArrayList)this.leaveSitemapEventListeners).clone();
    }

    public boolean registerNode(String name, ProcessingNode node) {
        if (this.registeredNodes.containsKey(name)) {
            return false;
        }
        this.registeredNodes.put(name, node);
        return true;
    }

    public ProcessingNode getRegisteredNode(String name) {
        if (this.canGetNode) {
            return (ProcessingNode)this.registeredNodes.get(name);
        }
        throw new IllegalArgumentException("Categories are only available during buildNode()");
    }

    public ProcessingNodeBuilder createNodeBuilder(Configuration config) throws Exception {
        String nodeName = config.getName();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Creating node builder for " + nodeName));
        }
        ProcessingNodeBuilder builder = (ProcessingNodeBuilder)this.itsBuilders.getBuilder(nodeName);
        builder.setBuilder(this);
        if (builder instanceof LinkedProcessingNodeBuilder) {
            this.linkedBuilders.add(builder);
        }
        return builder;
    }

    protected ProcessingNode createTree(Configuration tree) throws Exception {
        ProcessingNodeBuilder rootBuilder = this.createNodeBuilder(tree);
        return rootBuilder.buildNode(tree);
    }

    protected void linkNodes() throws Exception {
        this.viewsNode = CategoryNodeBuilder.getCategoryNode(this, "views");
        Iterator iter = this.linkedBuilders.iterator();
        while (iter.hasNext()) {
            ((LinkedProcessingNodeBuilder)iter.next()).linkNode();
        }
    }

    public String getNamespace() {
        return this.itsNamespace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessingNode build(Configuration tree, String location) throws Exception {
        Configuration config;
        Monitor fam = null;
        this.itsContainer = SitemapHelper.createContainer(tree, location, fam, (ServletContext)this.context.get((Object)"environment-context"));
        Context itsContext = (Context)this.itsContainer.getBean("org.apache.avalon.framework.context.Context");
        this.itsNamespace = tree.getNamespace();
        if (tree.getChild("components").getAttributeAsBoolean("replace-properties", true)) {
            tree = AvalonUtils.replaceProperties(tree, (Settings)this.itsContainer.getBean(Settings.ROLE));
        }
        this.itsManager = (ServiceManager)this.itsContainer.getBean("org.apache.avalon.framework.service.ServiceManager");
        this.registerListeners();
        this.itsComponentInfo = (PipelineComponentInfo)this.itsManager.lookup(PipelineComponentInfo.ROLE);
        this.itsLifecycle = new LifecycleHelper(null, itsContext, this.itsManager, null);
        NodeBuilderSelector selector = new NodeBuilderSelector();
        SourceResolver resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
        String url = this.getBuilderConfigURL();
        try {
            Source src = resolver.resolveURI(url);
            try {
                SAXConfigurationHandler handler = new SAXConfigurationHandler();
                SourceUtil.toSAX((ServiceManager)this.manager, (Source)src, null, (ContentHandler)handler);
                config = handler.getConfiguration();
            }
            finally {
                resolver.release(src);
            }
        }
        catch (Exception e) {
            throw new ConfigurationException("Could not load TreeBuilder configuration from " + url, (Throwable)e);
        }
        finally {
            this.manager.release((Object)resolver);
        }
        LifecycleHelper.setupComponent((Object)selector, this.getLogger(), itsContext, this.itsManager, config.getChild("nodes", false));
        this.itsBuilders = selector;
        this.canGetNode = false;
        VariableResolverFactory.setDisposableCollector(this.disposableNodes);
        ProcessingNode result = this.createTree(tree);
        this.canGetNode = true;
        this.linkNodes();
        Iterator iter = this.initializableNodes.iterator();
        while (iter.hasNext()) {
            ((Initializable)iter.next()).initialize();
        }
        return result;
    }

    public List getDisposableNodes() {
        return this.disposableNodes;
    }

    public ProcessingNode setupNode(ProcessingNode node, Configuration config) throws Exception {
        LocationImpl location = this.getLocation(config);
        if (node instanceof AbstractProcessingNode) {
            ((AbstractProcessingNode)node).setLocation((Location)location);
            ((AbstractProcessingNode)node).setSitemapExecutor(this.processor.getSitemapExecutor());
        }
        this.itsLifecycle.setupComponent(node, false);
        if (node instanceof ParameterizableProcessingNode) {
            Map params = this.getParameters(config, (Location)location);
            ((ParameterizableProcessingNode)node).setParameters(params);
        }
        if (node instanceof Initializable) {
            this.initializableNodes.add(node);
        }
        if (node instanceof Disposable) {
            this.disposableNodes.add(node);
        }
        return node;
    }

    protected LocationImpl getLocation(Configuration config) {
        String prefix = "";
        if (config instanceof AbstractConfiguration) {
            String namespace = null;
            try {
                namespace = config.getNamespace();
            }
            catch (ConfigurationException e) {
                // empty catch block
            }
            if ("http://apache.org/cocoon/sitemap/1.0".equals(namespace)) {
                prefix = "map";
            }
        }
        StringBuffer desc = new StringBuffer().append('<');
        if (prefix.length() > 0) {
            desc.append(prefix).append(':').append(config.getName());
        } else {
            desc.append(config.getName());
        }
        String type = config.getAttribute("type", null);
        if (type != null) {
            desc.append(" type=\"").append(type).append('\"');
        }
        desc.append('>');
        Location rawLoc = LocationUtils.getLocation((Object)config);
        return new LocationImpl(desc.toString(), rawLoc.getURI(), rawLoc.getLineNumber(), rawLoc.getColumnNumber());
    }

    protected Map getParameters(Configuration config, Location location) throws ConfigurationException {
        Configuration[] children = config.getChildren("parameter");
        if (children.length == 0) {
            return new SitemapParameters.LocatedHashMap(location, 0);
        }
        SitemapParameters.LocatedHashMap params = new SitemapParameters.LocatedHashMap(location, children.length + 1);
        for (int i = 0; i < children.length; ++i) {
            Configuration child = children[i];
            String name = child.getAttribute("name");
            String value = child.getAttribute("value");
            try {
                params.put(this.resolve(name), this.resolve(value));
                continue;
            }
            catch (PatternException pe) {
                String msg = "Invalid pattern '" + value + "' at " + child.getLocation();
                throw new ConfigurationException(msg, (Throwable)pe);
            }
        }
        return params;
    }

    public String getTypeForStatement(Configuration statement, String role) throws ConfigurationException {
        String type = statement.getAttribute("type", null);
        if (type == null) {
            type = this.itsComponentInfo.getDefaultType(role);
        }
        if (type == null) {
            throw new ConfigurationException("No default type exists for 'map:" + statement.getName() + "' at " + statement.getLocation());
        }
        String beanName = role + '/' + type;
        if (!this.itsContainer.containsBean(beanName)) {
            throw new ConfigurationException("Type '" + type + "' does not exist for 'map:" + statement.getName() + "' at " + statement.getLocation());
        }
        return type;
    }

    protected VariableResolver resolve(String expression) throws PatternException {
        return VariableResolverFactory.getResolver(expression, this.itsManager);
    }

    public void recycle() {
        this.attributes.clear();
        this.canGetNode = false;
        this.disposableNodes = new ArrayList();
        this.initializableNodes.clear();
        this.linkedBuilders.clear();
        this.processor = null;
        this.itsNamespace = null;
        LifecycleHelper.dispose((Object)this.itsBuilders);
        this.itsBuilders = null;
        this.itsLifecycle = null;
        this.itsManager = null;
        this.registeredNodes.clear();
        this.initializableNodes.clear();
        this.linkedBuilders.clear();
        this.canGetNode = false;
        this.registeredNodes.clear();
        VariableResolverFactory.setDisposableCollector(null);
        this.enterSitemapEventListeners.clear();
        this.leaveSitemapEventListeners.clear();
        this.labelViews.clear();
        this.viewsNode = null;
        this.isBuildingView = false;
        this.isBuildingErrorHandler = false;
    }

    protected void registerListeners() {
        Iterator i;
        WebApplicationContext listableFactory = this.itsContainer;
        Map beans = listableFactory.getBeansOfType(EnterSitemapEventListener.class);
        if (beans != null) {
            i = beans.values().iterator();
            while (i.hasNext()) {
                this.enterSitemapEventListeners.add(i.next());
            }
        }
        if ((beans = listableFactory.getBeansOfType(LeaveSitemapEventListener.class)) != null) {
            i = beans.values().iterator();
            while (i.hasNext()) {
                this.leaveSitemapEventListeners.add(i.next());
            }
        }
    }

    public void setBuildingView(boolean building) {
        this.isBuildingView = building;
    }

    public boolean isBuildingView() {
        return this.isBuildingView;
    }

    public void setBuildingErrorHandler(boolean building) {
        this.isBuildingErrorHandler = building;
    }

    public boolean isBuildingErrorHandler() {
        return this.isBuildingErrorHandler;
    }

    public void addViewForLabel(String label, String view) {
        HashSet<String> views;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("views:addViewForLabel(" + label + ", " + view + ")"));
        }
        if ((views = (HashSet<String>)this.labelViews.get(label)) == null) {
            views = new HashSet<String>();
            this.labelViews.put(label, views);
        }
        views.add(view);
    }

    public Collection getViewsForStatement(String role, String hint, Configuration statement) throws Exception {
        String[] compLabels;
        String statementLabels = statement.getAttribute("label", null);
        if (this.isBuildingView) {
            if (statementLabels != null) {
                String msg = "Cannot put a 'label' attribute inside view definition at " + statement.getLocation();
                throw new ConfigurationException(msg);
            }
            return null;
        }
        HashSet<String> labels = new HashSet<String>();
        if (role != null && role.length() > 0 && (compLabels = this.itsComponentInfo.getLabels(role, hint)) != null) {
            for (int i = 0; i < compLabels.length; ++i) {
                labels.add(compLabels[i]);
            }
        }
        if (statementLabels != null) {
            labels.addAll(SitemapLanguage.splitLabels(statementLabels));
        }
        if (Generator.ROLE.equals(role)) {
            labels.add(FIRST_POS_LABEL);
        } else if (Serializer.ROLE.equals(role)) {
            labels.add(LAST_POS_LABEL);
        }
        HashSet<String> views = new HashSet<String>();
        Iterator labelIter = labels.iterator();
        while (labelIter.hasNext()) {
            Collection coll = (Collection)this.labelViews.get(labelIter.next());
            if (coll == null) continue;
            Iterator viewIter = coll.iterator();
            while (viewIter.hasNext()) {
                String viewName = (String)viewIter.next();
                views.add(viewName);
            }
        }
        if (views.size() == 0) {
            views = null;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)(statement.getName() + " has no views at " + statement.getLocation()));
            }
        } else if (this.getLogger().isDebugEnabled()) {
            StringBuffer buf = new StringBuffer(statement.getName() + " will match views [");
            Iterator iter = views.iterator();
            while (iter.hasNext()) {
                buf.append(iter.next()).append(" ");
            }
            buf.append("] at ").append(statement.getLocation());
            this.getLogger().debug((Object)buf.toString());
        }
        return views;
    }

    public Map getViewNodes(Collection viewNames) throws Exception {
        if (viewNames == null || viewNames.size() == 0) {
            return null;
        }
        if (this.viewsNode == null) {
            return null;
        }
        HashMap<String, ProcessingNode> result = new HashMap<String, ProcessingNode>();
        Iterator iter = viewNames.iterator();
        while (iter.hasNext()) {
            String viewName = (String)iter.next();
            result.put(viewName, this.viewsNode.getNodeByName(viewName));
        }
        return result;
    }

    public Map getHintsForStatement(String role, String hint, Configuration statement) throws Exception {
        String hintParams;
        String statementHintParams = statement.getAttribute("pipeline-hints", null);
        String componentHintParams = this.itsComponentInfo.getPipelineHint(role, hint);
        if (componentHintParams != null) {
            hintParams = componentHintParams;
            if (statementHintParams != null) {
                hintParams = hintParams + "," + statementHintParams;
            }
        } else {
            hintParams = statementHintParams;
        }
        if (hintParams == null) {
            return null;
        }
        HashMap<VariableResolver, VariableResolver> params = new HashMap<VariableResolver, VariableResolver>();
        RE commaSplit = new RE(COMMA_SPLIT_REGEXP);
        RE equalsSplit = new RE(EQUALS_SPLIT_REGEXP);
        String[] expressions = commaSplit.split(hintParams.trim());
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("pipeline-hints: (aggregate-hint) " + hintParams));
        }
        for (int i = 0; i < expressions.length; ++i) {
            String[] nameValuePair = equalsSplit.split(expressions[i]);
            try {
                if (nameValuePair.length < 2) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug((Object)("pipeline-hints: (name) " + nameValuePair[0] + "\npipeline-hints: (value) [implicit] true"));
                    }
                    params.put(this.resolve(nameValuePair[0]), this.resolve("true"));
                    continue;
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("pipeline-hints: (name) " + nameValuePair[0] + "\npipeline-hints: (value) " + nameValuePair[1]));
                }
                params.put(this.resolve(nameValuePair[0]), this.resolve(nameValuePair[1]));
                continue;
            }
            catch (PatternException pe) {
                String msg = "Invalid pattern '" + hintParams + "' at " + statement.getLocation();
                this.getLogger().error((Object)msg, (Throwable)pe);
                throw new ConfigurationException(msg, (Throwable)pe);
            }
        }
        return params;
    }

    public String getMimeType(String role, String hint) {
        return this.itsComponentInfo.getMimeType(role, hint);
    }

    private static Collection splitLabels(String labels) {
        if (labels == null) {
            return Collections.EMPTY_SET;
        }
        return Arrays.asList(StringUtils.split((String)labels, (String)", \t\n\r"));
    }
}

