/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.sitemap;

import java.io.IOException;
import java.util.Map;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.Processor;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.components.notification.Notifying;
import org.apache.cocoon.components.notification.NotifyingBuilder;
import org.apache.cocoon.components.treeprocessor.InvokeContext;
import org.apache.cocoon.components.treeprocessor.ProcessingNode;
import org.apache.cocoon.components.treeprocessor.sitemap.HandleErrorsNode;
import org.apache.cocoon.core.container.spring.logger.LoggerUtils;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.util.AbstractLogEnabled;
import org.apache.commons.logging.Log;

public class ErrorHandlerHelper
extends AbstractLogEnabled
implements Serviceable {
    private ServiceManager manager;
    protected Log handledErrorsLogger;
    private HandleErrorsNode error;

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
        this.handledErrorsLogger = LoggerUtils.getChildLogger(this.manager, "handled");
    }

    void setErrorHandler(ProcessingNode node) {
        this.error = (HandleErrorsNode)node;
    }

    public boolean isEmpty() {
        return this.error == null;
    }

    public boolean isInternal() {
        return this.error != null && this.error.isInternal();
    }

    public boolean isExternal() {
        return this.error != null && this.error.isExternal();
    }

    public boolean invokeErrorHandler(Exception ex, Environment env, InvokeContext context) throws Exception {
        Processor.InternalPipelineDescription desc = this.prepareErrorHandler(ex, env, context);
        if (desc != null) {
            context.setInternalPipelineDescription(desc);
            return true;
        }
        return false;
    }

    public Processor.InternalPipelineDescription prepareErrorHandler(Exception ex, Environment env, InvokeContext context) throws Exception {
        boolean internal;
        boolean bl = internal = !env.isExternal() && !env.isInternalRedirect();
        if (internal && !this.isInternal()) {
            throw ex;
        }
        if (!internal && !this.isExternal()) {
            throw ex;
        }
        if (this.error != null) {
            return this.prepareErrorHandler(this.error, ex, env, context);
        }
        throw ex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Processor.InternalPipelineDescription prepareErrorHandler(ProcessingNode node, Exception ex, Environment env, InvokeContext context) throws Exception {
        if (ex instanceof ResourceNotFoundException) {
            this.handledErrorsLogger.error((Object)ex.getMessage());
        } else {
            this.handledErrorsLogger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        try {
            this.prepare(context, env, ex);
            InvokeContext errorContext = new InvokeContext(context, this.manager);
            try {
                if (!node.invoke(env, errorContext)) throw ex;
                Processor.InternalPipelineDescription internalPipelineDescription = errorContext.getInternalPipelineDescription(env);
                return internalPipelineDescription;
            }
            finally {
                errorContext.dispose();
            }
        }
        catch (Exception e) {
            this.getLogger().error((Object)("An exception occured while handling errors at " + node.getLocation()), (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepare(InvokeContext context, Environment env, Exception ex) throws IOException, ServiceException {
        Map objectModel = env.getObjectModel();
        if (objectModel.get("throwable") == null) {
            if (!context.isBuildingPipelineOnly()) {
                env.tryResetResponse();
            }
            NotifyingBuilder notifyingBuilder = (NotifyingBuilder)this.manager.lookup(NotifyingBuilder.ROLE);
            Notifying currentNotifying = null;
            try {
                currentNotifying = notifyingBuilder.build((Object)this, (Object)ex);
            }
            finally {
                this.manager.release((Object)notifyingBuilder);
            }
            objectModel.put("notifying-object", currentNotifying);
            objectModel.put("throwable", ex);
        }
    }
}

