/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor;

import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.ServiceSelector;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.treeprocessor.SimpleParentProcessingNode;

public abstract class SimpleSelectorProcessingNode
extends SimpleParentProcessingNode
implements Serviceable,
Disposable {
    private String selectorRole;
    private ServiceManager manager;
    private ServiceSelector selector;
    private Object threadSafeComponent;

    public SimpleSelectorProcessingNode(String selectorRole, String componentType) {
        super(componentType);
        this.selectorRole = selectorRole;
    }

    public void service(ServiceManager avalonManager) throws ServiceException {
        this.manager = avalonManager;
        this.selector = (ServiceSelector)this.manager.lookup(this.selectorRole);
        Object component = this.selector.select((Object)this.getType());
        if (component instanceof ThreadSafe) {
            this.threadSafeComponent = component;
        } else {
            this.selector.release(component);
        }
    }

    protected Object getComponent() throws ServiceException {
        if (this.threadSafeComponent != null) {
            return this.threadSafeComponent;
        }
        return this.selector.select((Object)this.componentName);
    }

    protected void releaseComponent(Object obj) {
        if (obj != this.threadSafeComponent) {
            this.selector.release(obj);
        }
    }

    public void dispose() {
        this.selector.release(this.threadSafeComponent);
        this.manager.release((Object)this.selector);
        this.selector = null;
        this.manager = null;
    }
}

