/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.util.AbstractLogEnabled;

public class NodeBuilderSelector
extends AbstractLogEnabled
implements Serviceable,
Configurable,
Initializable,
Contextualizable {
    protected ServiceManager serviceManager;
    protected Context context;
    protected final Map componentInfos = Collections.synchronizedMap(new HashMap());
    protected final Map singletons = Collections.synchronizedMap(new HashMap());
    static /* synthetic */ Class class$org$apache$avalon$framework$thread$ThreadSafe;

    public void contextualize(Context avalonContext) {
        this.context = avalonContext;
    }

    public void service(ServiceManager componentManager) throws ServiceException {
        this.serviceManager = componentManager;
    }

    public void configure(Configuration config) throws ConfigurationException {
        Configuration[] instances = config.getChildren();
        for (int i = 0; i < instances.length; ++i) {
            String message;
            Configuration instance = instances[i];
            String name = instance.getAttribute("name").trim();
            String className = instance.getAttribute("builder").trim();
            try {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("Adding builder (" + name + " = " + className + ")"));
                }
                Class<?> clazz = ((Object)((Object)this)).getClass().getClassLoader().loadClass(className);
                BuilderInfo info = new BuilderInfo();
                info.builderClass = clazz;
                info.configuration = instance;
                this.componentInfos.put(name, info);
                continue;
            }
            catch (ClassNotFoundException cnfe) {
                message = "Could not get class (" + className + ") for builder " + name + " at " + instance.getLocation();
                throw new ConfigurationException(message, (Throwable)cnfe);
            }
            catch (Exception e) {
                message = "Unexpected exception when setting up builder " + name + " at " + instance.getLocation();
                throw new ConfigurationException(message, (Throwable)e);
            }
        }
    }

    public void initialize() throws Exception {
        Iterator i = this.componentInfos.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            BuilderInfo info = (BuilderInfo)entry.getValue();
            if (!(class$org$apache$avalon$framework$thread$ThreadSafe == null ? NodeBuilderSelector.class$("org.apache.avalon.framework.thread.ThreadSafe") : class$org$apache$avalon$framework$thread$ThreadSafe).isAssignableFrom(info.builderClass)) continue;
            this.singletons.put(entry.getKey(), this.createComponent(info));
        }
    }

    public Object getBuilder(String name) throws Exception {
        Object component = this.singletons.get(name);
        if (component == null) {
            BuilderInfo info = (BuilderInfo)this.componentInfos.get(name);
            if (info == null) {
                throw new Exception("Node builder selector could not find builder for key [" + name + "]");
            }
            try {
                component = this.createComponent(info);
            }
            catch (Exception e) {
                throw new Exception("Unable to create new builder: " + name, e);
            }
        }
        return component;
    }

    protected Object createComponent(BuilderInfo info) throws Exception {
        Object component = info.builderClass.newInstance();
        ContainerUtil.contextualize(component, (Context)this.context);
        ContainerUtil.service(component, (ServiceManager)this.serviceManager);
        ContainerUtil.configure(component, (Configuration)info.configuration);
        if (component instanceof Parameterizable) {
            ContainerUtil.parameterize(component, (Parameters)Parameters.fromConfiguration((Configuration)info.configuration));
        }
        ContainerUtil.initialize(component);
        return component;
    }

    protected static class BuilderInfo {
        public Configuration configuration;
        public Class builderClass;

        protected BuilderInfo() {
        }
    }
}

