/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.Processor;
import org.apache.cocoon.components.source.impl.SitemapSourceInfo;
import org.apache.cocoon.components.treeprocessor.InvokeContext;
import org.apache.cocoon.components.treeprocessor.ProcessingNode;
import org.apache.cocoon.components.treeprocessor.TreeProcessor;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.ForwardRedirector;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.environment.internal.EnvironmentHelper;
import org.apache.cocoon.environment.internal.ForwardEnvironmentWrapper;
import org.apache.cocoon.environment.wrapper.EnvironmentWrapper;
import org.apache.cocoon.environment.wrapper.MutableEnvironmentFacade;
import org.apache.cocoon.sitemap.EnterSitemapEvent;
import org.apache.cocoon.sitemap.EnterSitemapEventListener;
import org.apache.cocoon.sitemap.ExecutionContext;
import org.apache.cocoon.sitemap.LeaveSitemapEvent;
import org.apache.cocoon.sitemap.LeaveSitemapEventListener;
import org.apache.cocoon.sitemap.SitemapExecutor;
import org.apache.cocoon.spring.configurator.WebAppContextUtils;
import org.apache.cocoon.util.AbstractLogEnabled;
import org.apache.cocoon.util.location.Location;
import org.apache.cocoon.util.location.LocationImpl;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.web.context.WebApplicationContext;

public class ConcreteTreeProcessor
extends AbstractLogEnabled
implements Processor,
Disposable,
ExecutionContext {
    private ServiceManager manager;
    private TreeProcessor wrappingProcessor;
    private List disposableNodes;
    private ProcessingNode rootNode;
    private int requestCount;
    private SitemapExecutor sitemapExecutor;
    private List enterSitemapEventListeners = Collections.EMPTY_LIST;
    private List leaveSitemapEventListeners = Collections.EMPTY_LIST;
    protected Map processorAttributes = new HashMap();
    protected WebApplicationContext webAppContext;
    protected ClassLoader classLoader;

    public ConcreteTreeProcessor(TreeProcessor wrappingProcessor, SitemapExecutor sitemapExecutor) {
        this.wrappingProcessor = wrappingProcessor;
        this.sitemapExecutor = sitemapExecutor;
    }

    public void setProcessorData(WebApplicationContext webAppContext, ProcessingNode rootNode, List disposableNodes, List enterSitemapEventListeners, List leaveSitemapEventListeners) {
        if (this.rootNode != null) {
            throw new IllegalStateException("setProcessorData() can only be called once");
        }
        this.classLoader = webAppContext.getClassLoader();
        this.webAppContext = webAppContext;
        this.manager = (ServiceManager)this.webAppContext.getBean("org.apache.avalon.framework.service.ServiceManager");
        this.rootNode = rootNode;
        this.disposableNodes = disposableNodes;
        this.enterSitemapEventListeners = enterSitemapEventListeners;
        this.leaveSitemapEventListeners = leaveSitemapEventListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markForDisposal() {
        ConcreteTreeProcessor concreteTreeProcessor = this;
        synchronized (concreteTreeProcessor) {
            --this.requestCount;
        }
        if (this.requestCount < 0) {
            this.dispose();
        }
    }

    public TreeProcessor getWrappingProcessor() {
        return this.wrappingProcessor;
    }

    public Processor getRootProcessor() {
        return this.wrappingProcessor.getRootProcessor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(Environment environment) throws Exception {
        InvokeContext context = new InvokeContext();
        try {
            boolean bl = this.process(environment, context);
            return bl;
        }
        finally {
            context.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Processor.InternalPipelineDescription buildPipeline(Environment environment) throws Exception {
        InvokeContext context = new InvokeContext(true);
        try {
            if (this.process(environment, context)) {
                Processor.InternalPipelineDescription internalPipelineDescription = context.getInternalPipelineDescription(environment);
                return internalPipelineDescription;
            }
            Processor.InternalPipelineDescription internalPipelineDescription = null;
            return internalPipelineDescription;
        }
        finally {
            context.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    protected boolean process(Environment environment, InvokeContext context) throws Exception {
        ConcreteTreeProcessor concreteTreeProcessor = this;
        synchronized (concreteTreeProcessor) {
            ++this.requestCount;
        }
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        Object handle = null;
        try {
            handle = WebAppContextUtils.enteringContext((WebApplicationContext)this.webAppContext);
            if (!context.isBuildingPipelineOnly()) {
                EnterSitemapEvent enterEvent = new EnterSitemapEvent((Processor)this, environment);
                Iterator i = this.enterSitemapEventListeners.iterator();
                while (i.hasNext()) {
                    EnterSitemapEventListener current = (EnterSitemapEventListener)i.next();
                    current.enteredSitemap(enterEvent);
                }
            }
            this.sitemapExecutor.enterSitemap((ExecutionContext)this, environment.getObjectModel(), this.wrappingProcessor.source.getURI());
            EnvironmentHelper.enterProcessor(this, environment);
            Redirector oldRedirector = context.getRedirector();
            try {
                TreeProcessorRedirector redirector = new TreeProcessorRedirector(environment, context);
                context.setRedirector((Redirector)redirector);
                context.service(this.manager);
                context.setLastProcessor(this);
                boolean bl = this.rootNode.invoke(environment, context);
                return bl;
            }
            finally {
                EnvironmentHelper.leaveProcessor();
                context.setRedirector(oldRedirector);
            }
        }
        catch (Throwable throwable2) {
            Object var10_11 = null;
            if (handle != null) {
                this.sitemapExecutor.leaveSitemap((ExecutionContext)this, environment.getObjectModel());
                if (!context.isBuildingPipelineOnly()) {
                    LeaveSitemapEvent leaveEvent = new LeaveSitemapEvent((Processor)this, environment);
                    Iterator i = this.leaveSitemapEventListeners.iterator();
                    while (i.hasNext()) {
                        LeaveSitemapEventListener current = (LeaveSitemapEventListener)i.next();
                        current.leftSitemap(leaveEvent);
                    }
                }
                WebAppContextUtils.leavingContext((WebApplicationContext)this.webAppContext, (Object)handle);
            }
            ConcreteTreeProcessor concreteTreeProcessor2 = this;
            synchronized (concreteTreeProcessor2) {
                --this.requestCount;
            }
            if (this.requestCount < 0) {
                this.dispose();
            }
            Thread.currentThread().setContextClassLoader(oldClassLoader);
            throw throwable2;
        }
    }

    protected boolean handleCocoonRedirect(String uri, Environment env, InvokeContext context) throws Exception {
        MutableEnvironmentFacade facade;
        Object environment = env;
        MutableEnvironmentFacade mutableEnvironmentFacade = facade = environment instanceof MutableEnvironmentFacade ? (MutableEnvironmentFacade)environment : null;
        if (facade != null) {
            environment = facade.getDelegate();
        }
        boolean isRedirect = environment.getObjectModel().remove("cocoon:forward") == null;
        SitemapSourceInfo info = SitemapSourceInfo.parseURI(environment, uri);
        Object newEnv = new ForwardEnvironmentWrapper((Environment)environment, info);
        if (isRedirect) {
            ((EnvironmentWrapper)((Object)newEnv)).setInternalRedirect(true);
        }
        if (facade != null) {
            facade.setDelegate((EnvironmentWrapper)((Object)newEnv));
            newEnv = facade;
        }
        ConcreteTreeProcessor processor = newEnv.getURIPrefix().equals("") ? ((TreeProcessor)this.getRootProcessor()).concreteProcessor : this;
        boolean result = processor.process((Environment)newEnv, context);
        if (facade != null) {
            newEnv = facade.getDelegate();
        }
        if (((EnvironmentWrapper)((Object)newEnv)).getRedirectURL() != null) {
            environment.redirect(((EnvironmentWrapper)((Object)newEnv)).getRedirectURL(), false, false);
        }
        return result;
    }

    public void dispose() {
        if (this.disposableNodes != null) {
            for (int i = this.disposableNodes.size() - 1; i > -1; --i) {
                ((Disposable)this.disposableNodes.get(i)).dispose();
            }
            this.disposableNodes = null;
        }
        this.rootNode = null;
        this.sitemapExecutor = null;
        this.enterSitemapEventListeners.clear();
        this.leaveSitemapEventListeners.clear();
        if (this.webAppContext != null) {
            if (this.webAppContext instanceof ConfigurableApplicationContext) {
                ((ConfigurableApplicationContext)this.webAppContext).close();
            } else if (this.webAppContext instanceof ConfigurableBeanFactory) {
                ((ConfigurableBeanFactory)this.webAppContext).destroySingletons();
            }
            this.webAppContext = null;
        }
    }

    public SourceResolver getSourceResolver() {
        return this.wrappingProcessor.getSourceResolver();
    }

    public String getContext() {
        return this.wrappingProcessor.getContext();
    }

    public SitemapExecutor getSitemapExecutor() {
        return this.sitemapExecutor;
    }

    public ServiceManager getServiceManager() {
        return this.manager;
    }

    public Object getAttribute(String name) {
        return this.processorAttributes.get(name);
    }

    public Object removeAttribute(String name) {
        return this.processorAttributes.remove(name);
    }

    public void setAttribute(String name, Object value) {
        this.processorAttributes.put(name, value);
    }

    public Location getLocation() {
        return new LocationImpl("[sitemap]", this.wrappingProcessor.source.getURI());
    }

    public String getType() {
        return "sitemap";
    }

    public Processor getParent() {
        return this.wrappingProcessor.getParent();
    }

    private class TreeProcessorRedirector
    extends ForwardRedirector {
        private InvokeContext context;

        public TreeProcessorRedirector(Environment env, InvokeContext context) {
            super(env);
            this.context = context;
        }

        protected void cocoonRedirect(String uri) throws IOException, ProcessingException {
            try {
                ConcreteTreeProcessor.this.handleCocoonRedirect(uri, this.env, this.context);
            }
            catch (IOException e) {
                throw e;
            }
            catch (ProcessingException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ProcessingException(e);
            }
        }
    }
}

