/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.modules.input;

import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.ServiceSelector;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.modules.input.AbstractInputModule;
import org.apache.cocoon.components.modules.input.InputModule;
import org.apache.cocoon.components.modules.input.ModuleHolder;

public abstract class AbstractMetaModule
extends AbstractInputModule
implements Serviceable {
    protected ServiceManager manager;
    protected ServiceSelector inputSelector;
    protected InputModule input;
    protected String defaultInput = "request-param";
    protected Configuration inputConf;
    protected boolean initialized = false;
    protected static final String INPUT_MODULE_SELECTOR = InputModule.ROLE + "Selector";
    private static final int OP_GET = 0;
    private static final int OP_VALUES = 1;
    private static final int OP_NAMES = 2;
    private static final String[] OPNAME = new String[]{"GET_VALUE", "GET_VALUES", "GET_NAMES"};

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
    }

    public synchronized void lazy_initialize() {
        block4: {
            try {
                if (!this.initialized) {
                    this.inputSelector = (ServiceSelector)this.manager.lookup(INPUT_MODULE_SELECTOR);
                    if (this.defaultInput != null) {
                        this.input = this.obtainModule(this.defaultInput);
                    }
                    this.initialized = true;
                }
            }
            catch (Exception e) {
                if (!this.getLogger().isWarnEnabled()) break block4;
                this.getLogger().error((Object)("A problem occurred setting up input modules :'" + e.getMessage()), (Throwable)e);
            }
        }
    }

    public void dispose() {
        if (this.inputSelector != null) {
            this.inputSelector.release((Object)this.input);
            this.input = null;
            this.manager.release((Object)this.inputSelector);
            this.inputSelector = null;
        }
        this.manager = null;
    }

    protected InputModule obtainModule(String type) {
        InputModule module;
        block9: {
            if (this.inputSelector == null) {
                if (this.getLogger().isWarnEnabled()) {
                    this.getLogger().warn((Object)("A problem occurred setting up '" + type + "': Selector is null"));
                }
                return null;
            }
            module = null;
            try {
                if (this.inputSelector.isSelectable((Object)type)) {
                    module = (InputModule)this.inputSelector.select((Object)type);
                    if (!(module instanceof ThreadSafe)) {
                        if (this.getLogger().isWarnEnabled()) {
                            this.getLogger().warn((Object)("A problem occurred setting up '" + type + "': Component is not thread safe."));
                        }
                        this.inputSelector.release((Object)module);
                        module = null;
                    }
                } else if (this.getLogger().isWarnEnabled()) {
                    this.getLogger().warn((Object)("A problem occurred setting up '" + type + "': Component is unknown."));
                }
            }
            catch (ServiceException ce) {
                if (!this.getLogger().isWarnEnabled()) break block9;
                this.getLogger().warn((Object)("Could not obtain InputModules: " + ce.getMessage()), (Throwable)ce);
            }
        }
        return module;
    }

    protected void releaseModule(InputModule module) {
        if (module != null) {
            this.inputSelector.release((Object)module);
        }
    }

    protected Iterator getNames(Map objectModel, InputModule staticMod, String staticModName, Configuration staticModConf) throws ConfigurationException {
        return (Iterator)this.get(2, null, objectModel, staticMod, staticModName, staticModConf, null, null, null);
    }

    protected Iterator getNames(Map objectModel, InputModule staticMod, String staticModName, Configuration staticModConf, InputModule dynamicMod, String dynamicModName, Configuration dynamicModConf) throws ConfigurationException {
        return (Iterator)this.get(2, null, objectModel, staticMod, staticModName, staticModConf, dynamicMod, dynamicModName, dynamicModConf);
    }

    protected Object getValue(String attr, Map objectModel, ModuleHolder holder) throws ConfigurationException {
        return this.getValue(attr, objectModel, holder.input, holder.name, holder.config);
    }

    protected Object getValue(String attr, Map objectModel, ModuleHolder staticHolder, ModuleHolder dynamicHolder) throws ConfigurationException {
        return this.getValue(attr, objectModel, staticHolder.input, staticHolder.name, dynamicHolder.config);
    }

    protected Object[] getValues(String attr, Map objectModel, ModuleHolder holder) throws ConfigurationException {
        return this.getValues(attr, objectModel, holder.input, holder.name, holder.config);
    }

    protected Object[] getValues(String attr, Map objectModel, ModuleHolder staticHolder, ModuleHolder dynamicHolder) throws ConfigurationException {
        return this.getValues(attr, objectModel, staticHolder.input, staticHolder.name, dynamicHolder.config);
    }

    protected Object getValue(String attr, Map objectModel, InputModule staticMod, String staticModName, Configuration staticModConf) throws ConfigurationException {
        return this.get(0, attr, objectModel, staticMod, staticModName, staticModConf, null, null, null);
    }

    protected Object getValue(String attr, Map objectModel, InputModule staticMod, String staticModName, Configuration staticModConf, InputModule dynamicMod, String dynamicModName, Configuration dynamicModConf) throws ConfigurationException {
        return this.get(0, attr, objectModel, staticMod, staticModName, staticModConf, dynamicMod, dynamicModName, dynamicModConf);
    }

    protected Object[] getValues(String attr, Map objectModel, InputModule staticMod, String staticModName, Configuration staticModConf) throws ConfigurationException {
        return (Object[])this.get(1, attr, objectModel, staticMod, staticModName, staticModConf, null, null, null);
    }

    protected Object[] getValues(String attr, Map objectModel, InputModule staticMod, String staticModName, Configuration staticModConf, InputModule dynamicMod, String dynamicModName, Configuration dynamicModConf) throws ConfigurationException {
        return (Object[])this.get(1, attr, objectModel, staticMod, staticModName, staticModConf, dynamicMod, dynamicModName, dynamicModConf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object get(int op, String attr, Map objectModel, InputModule staticMod, String staticModName, Configuration staticModConf, InputModule dynamicMod, String dynamicModName, Configuration dynamicModConf) throws ConfigurationException {
        Object[] value;
        ServiceSelector cs;
        block22: {
            cs = this.inputSelector;
            value = null;
            String name = null;
            InputModule input = null;
            Configuration conf = null;
            boolean release = false;
            try {
                boolean useDynamic;
                if (cs == null) {
                    try {
                        cs = (ServiceSelector)this.manager.lookup(INPUT_MODULE_SELECTOR);
                    }
                    catch (ServiceException e) {
                        throw new ConfigurationException("Could not find MetaModule's module selector", (Throwable)e);
                    }
                }
                if (dynamicMod == null && dynamicModName == null) {
                    useDynamic = false;
                    input = staticMod;
                    name = staticModName;
                    conf = staticModConf;
                } else {
                    useDynamic = true;
                    input = dynamicMod;
                    name = dynamicModName;
                    conf = dynamicModConf;
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("MetaModule performing op " + OPNAME[op] + " on " + (useDynamic ? "dynamically" : "statically") + " " + (input == null ? "created" : "assigned") + " module '" + name + "', using config " + dynamicModConf));
                }
                if (input == null) {
                    if (cs.isSelectable((Object)name)) {
                        release = true;
                        try {
                            input = (InputModule)cs.select((Object)name);
                        }
                        catch (ServiceException e) {
                            throw new ConfigurationException("MetaModule unable to create " + (useDynamic ? "dynamically" : "statically") + " specified internal module '" + name + "'", (Throwable)e);
                        }
                    } else {
                        throw new ConfigurationException("MetaModule: No such InputModule: " + name);
                    }
                }
                switch (op) {
                    case 0: {
                        value = input.getAttribute(attr, conf, objectModel);
                        break;
                    }
                    case 1: {
                        value = input.getAttributeValues(attr, conf, objectModel);
                        break;
                    }
                    case 2: {
                        value = input.getAttributeNames(conf, objectModel);
                    }
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("using " + name + " as " + input + " for " + op + " (" + attr + ") and " + conf + " gives " + value));
                }
                Object var19_19 = null;
                if (!release) break block22;
            }
            catch (Throwable throwable) {
                Object var19_20 = null;
                if (release) {
                    cs.release((Object)input);
                }
                if (this.inputSelector == null) {
                    this.manager.release((Object)cs);
                }
                throw throwable;
            }
            cs.release((Object)input);
        }
        if (this.inputSelector == null) {
            this.manager.release((Object)cs);
        }
        return value;
    }
}

