/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation.helpers;

import EDU.oswego.cs.dl.util.concurrent.CountDown;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CachedResponse;
import org.apache.cocoon.components.sax.XMLByteStreamCompiler;
import org.apache.cocoon.components.sax.XMLByteStreamInterpreter;
import org.apache.cocoon.components.sax.XMLTeePipe;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.environment.CocoonRunnable;
import org.apache.cocoon.thread.RunnableManager;
import org.apache.cocoon.transformation.helpers.IncludeCacheManager;
import org.apache.cocoon.transformation.helpers.IncludeCacheManagerSession;
import org.apache.cocoon.transformation.helpers.IncludeCacheStorageProxy;
import org.apache.cocoon.transformation.helpers.ModifiableSourceIncludeCacheStorageProxy;
import org.apache.cocoon.transformation.helpers.PreemptiveLoader;
import org.apache.cocoon.transformation.helpers.StoreIncludeCacheStorageProxy;
import org.apache.cocoon.util.AbstractLogEnabled;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.store.Store;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public final class DefaultIncludeCacheManager
extends AbstractLogEnabled
implements IncludeCacheManager,
ThreadSafe,
Serviceable,
Disposable,
Parameterizable {
    private ServiceManager manager;
    private SourceResolver resolver;
    private Store store;
    private IncludeCacheStorageProxy defaultCacheStorage;
    private String preemptiveLoaderURI;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public IncludeCacheManagerSession getSession(Parameters pars) {
        void var3_3;
        IncludeCacheManagerSession session;
        String sourceURI = pars.getParameter("source", null);
        if (null == sourceURI) {
            session = new IncludeCacheManagerSession(pars, this.defaultCacheStorage);
        } else {
            Source source = null;
            try {
                source = this.resolver.resolveURI(sourceURI);
                ModifiableSourceIncludeCacheStorageProxy proxy = new ModifiableSourceIncludeCacheStorageProxy(this.resolver, source.getURI());
                session = new IncludeCacheManagerSession(pars, proxy);
            }
            catch (Exception local) {
                session = new IncludeCacheManagerSession(pars, this.defaultCacheStorage);
                this.getLogger().warn((Object)"Error creating writeable source.", (Throwable)local);
            }
            finally {
                this.resolver.release(source);
            }
        }
        if (var3_3.isPreemptive()) {
            if (null == this.preemptiveLoaderURI) {
                this.getLogger().error((Object)"Preemptive loading is turned off because the preemptive-loader-url is not configured.");
                var3_3.setPreemptive(false);
            } else if (!PreemptiveLoader.getInstance().alive) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("Booting preemptive loader: " + this.preemptiveLoaderURI));
                }
                PreemptiveBooter thread = new PreemptiveBooter(this.preemptiveLoaderURI);
                try {
                    RunnableManager runnableManager = (RunnableManager)this.manager.lookup(RunnableManager.ROLE);
                    runnableManager.execute((Runnable)thread);
                    this.manager.release((Object)runnableManager);
                }
                catch (ServiceException se) {
                    this.getLogger().error((Object)"Cannot lookup RunnableManager", (Throwable)se);
                }
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Creating cache manager session: " + var3_3));
        }
        return var3_3;
    }

    public String load(String uri, IncludeCacheManagerSession session) throws IOException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Load " + uri + " for session " + session));
        }
        if (uri.indexOf("://") == -1) {
            Source source = session.resolveURI(uri, this.resolver);
            uri = source.getURI();
        }
        if (session.isParallel() && !session.isPreemptive()) {
            IncludeCacheStorageProxy storage = session.getCacheStorageProxy();
            CachedResponse response = (CachedResponse)storage.get(uri);
            if (null != response) {
                SourceValidity[] validities = response.getValidityObjects();
                if (!session.isPurging() && validities[0].isValid() == 1) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug((Object)"Using cached response for parallel processing.");
                    }
                    session.add(uri, response.getResponse());
                    return uri;
                }
                storage.remove(uri);
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("Starting parallel thread for loading " + uri));
            }
            try {
                XMLByteStreamCompiler serializer = new XMLByteStreamCompiler();
                Source source = session.resolveURI(uri, this.resolver);
                LoaderThread loader = new LoaderThread(source, serializer);
                RunnableManager runnableManager = (RunnableManager)this.manager.lookup(RunnableManager.ROLE);
                session.add(uri, loader);
                runnableManager.execute((Runnable)((Object)new CocoonRunnable(loader)));
                this.manager.release((Object)runnableManager);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("Thread started for " + uri));
                }
            }
            catch (ServiceException ce) {
                throw new SourceException("Unable to lookup thread pool, RunnableManager, or xml serializer.", (Throwable)ce);
            }
            catch (Exception e) {
                throw new SourceException("Unable to get pooled thread.", (Throwable)e);
            }
        }
        return uri;
    }

    public void stream(String uri, IncludeCacheManagerSession session, XMLConsumer handler) throws IOException, SAXException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Stream " + uri + " for session " + session));
        }
        if (session.isParallel() && !session.isPreemptive()) {
            byte[] result;
            Object object = session.get(uri);
            if (object == null) {
                throw new SAXException("No pooled thread found for " + uri);
            }
            if (object instanceof LoaderThread) {
                LoaderThread loader = (LoaderThread)object;
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)"Waiting for pooled thread to finish loading.");
                }
                loader.join();
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)"Pooled thread finished loading.");
                }
                if (null != loader.exception) {
                    if (loader.exception instanceof SAXException) {
                        throw (SAXException)loader.exception;
                    }
                    if (loader.exception instanceof SourceException) {
                        throw (SourceException)loader.exception;
                    }
                    if (loader.exception instanceof IOException) {
                        throw (IOException)loader.exception;
                    }
                    throw new SAXException("Exception.", loader.exception);
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)"Streaming from pooled thread.");
                }
                result = loader.content;
                if (session.getExpires() > 0L) {
                    SourceValidity[] validities = new SourceValidity[]{session.getExpiresValidity()};
                    CachedResponse response = new CachedResponse(validities, result);
                    session.getCacheStorageProxy().put(uri, (Serializable)response);
                }
            } else {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)"Streaming from cached response.");
                }
                result = (byte[])object;
            }
            XMLByteStreamInterpreter deserializer = new XMLByteStreamInterpreter();
            deserializer.setConsumer(handler);
            deserializer.deserialize((Object)result);
            return;
        }
        IncludeCacheStorageProxy storage = session.getCacheStorageProxy();
        CachedResponse response = (CachedResponse)storage.get(uri);
        if (null != response) {
            SourceValidity[] validities = response.getValidityObjects();
            if (!session.isPurging() && (session.isPreemptive() || validities[0].isValid() == 1)) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)"Streaming from cached response.");
                }
                XMLByteStreamInterpreter deserializer = new XMLByteStreamInterpreter();
                deserializer.setConsumer(handler);
                deserializer.deserialize((Object)response.getResponse());
                if (session.getExpires() > 0L && session.isPreemptive() && validities[0].isValid() != 1) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug((Object)("Add uri to preemptive loader list " + uri));
                    }
                    if (!PreemptiveLoader.getInstance().alive) {
                        this.getLogger().error((Object)"Preemptive loader has not started yet.");
                    }
                    PreemptiveLoader.getInstance().add(session.getCacheStorageProxy(), uri, session.getExpires());
                }
                return;
            }
            storage.remove(uri);
        }
        try {
            Source source = session.resolveURI(uri, this.resolver);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)"Streaming directly from source.");
            }
            if (session.getExpires() > 0L) {
                XMLByteStreamCompiler serializer = new XMLByteStreamCompiler();
                XMLTeePipe tee = new XMLTeePipe(handler, (XMLConsumer)serializer);
                SourceUtil.toSAX(source, (ContentHandler)tee);
                SourceValidity[] validities = new SourceValidity[]{session.getExpiresValidity()};
                CachedResponse response2 = new CachedResponse(validities, (byte[])serializer.getSAXFragment());
                session.getCacheStorageProxy().put(uri, (Serializable)response2);
            } else {
                SourceUtil.toSAX(source, (ContentHandler)handler);
            }
        }
        catch (ProcessingException pe) {
            throw new SAXException("ProcessingException", (Exception)((Object)pe));
        }
    }

    public void terminateSession(IncludeCacheManagerSession session) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Terminating cache manager session " + session));
        }
        session.cleanup(this.resolver);
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
        this.resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
    }

    public void dispose() {
        PreemptiveLoader.getInstance().stop();
        if (null != this.manager) {
            this.manager.release((Object)this.resolver);
            this.manager.release((Object)this.store);
            this.store = null;
            this.resolver = null;
            this.manager = null;
            this.defaultCacheStorage = null;
        }
    }

    public void parameterize(Parameters parameters) throws ParameterException {
        this.preemptiveLoaderURI = parameters.getParameter("preemptive-loader-url", null);
        if (null != this.preemptiveLoaderURI && this.preemptiveLoaderURI.indexOf("://") == -1) {
            throw new ParameterException("The preemptive-loader-url must be absolute: " + this.preemptiveLoaderURI);
        }
        String storeRole = parameters.getParameter("use-store", Store.ROLE);
        try {
            this.store = (Store)this.manager.lookup(storeRole);
        }
        catch (ServiceException e) {
            throw new ParameterException("Unable to lookup store with role " + storeRole, (Throwable)e);
        }
        this.defaultCacheStorage = new StoreIncludeCacheStorageProxy(this.store);
    }

    private static final class PreemptiveBooter
    implements Runnable {
        private final String uri;

        public PreemptiveBooter(String uri) {
            this.uri = uri;
        }

        public void run() {
            try {
                URL url = new URL(this.uri);
                url.getContent();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static final class LoaderThread
    implements Runnable {
        private final Source source;
        private final XMLByteStreamCompiler serializer;
        private final CountDown finished;
        Exception exception;
        byte[] content;

        public LoaderThread(Source source, XMLByteStreamCompiler serializer) {
            this.source = source;
            this.serializer = serializer;
            this.finished = new CountDown(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                SourceUtil.toSAX(this.source, (ContentHandler)this.serializer);
                this.content = (byte[])this.serializer.getSAXFragment();
            }
            catch (Exception local) {
                this.exception = local;
            }
            finally {
                this.finished.release();
            }
        }

        void join() {
            try {
                this.finished.acquire();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

