/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation;

import java.io.IOException;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.components.treeprocessor.variables.VariableExpressionTokenizer;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolver;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolverFactory;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.i18n.Bundle;
import org.apache.cocoon.i18n.BundleFactory;
import org.apache.cocoon.i18n.I18nUtils;
import org.apache.cocoon.sitemap.PatternException;
import org.apache.cocoon.transformation.AbstractTransformer;
import org.apache.cocoon.xml.ParamSaxBuffer;
import org.apache.cocoon.xml.SaxBuffer;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.NOPValidity;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class I18nTransformer
extends AbstractTransformer
implements CacheableProcessingComponent,
Serviceable,
Configurable,
Disposable {
    public static final String I18N_NAMESPACE_URI = "http://apache.org/cocoon/i18n/2.1";
    public static final String I18N_OLD_NAMESPACE_URI = "http://apache.org/cocoon/i18n/2.0";
    public static final String I18N_TEXT_ELEMENT = "text";
    public static final String I18N_TRANSLATE_ELEMENT = "translate";
    public static final String I18N_CHOOSE_ELEMENT = "choose";
    public static final String I18N_WHEN_ELEMENT = "when";
    public static final String I18N_IF_ELEMENT = "if";
    public static final String I18N_OTHERWISE_ELEMENT = "otherwise";
    public static final String I18N_PARAM_ELEMENT = "param";
    public static final String I18N_PARAM_NAME_ATTRIBUTE = "name";
    public static final String I18N_DATE_ELEMENT = "date";
    public static final String I18N_DATE_TIME_ELEMENT = "date-time";
    public static final String I18N_TIME_ELEMENT = "time";
    public static final String I18N_NUMBER_ELEMENT = "number";
    public static final String I18N_CURRENCY_ELEMENT = "currency";
    public static final String I18N_PERCENT_ELEMENT = "percent";
    public static final String I18N_INT_CURRENCY_ELEMENT = "int-currency";
    public static final String I18N_CURRENCY_NO_UNIT_ELEMENT = "currency-no-unit";
    public static final String I18N_INT_CURRENCY_NO_UNIT_ELEMENT = "int-currency-no-unit";
    public static final String I18N_KEY_ATTRIBUTE = "key";
    public static final String I18N_ATTR_ATTRIBUTE = "attr";
    public static final String I18N_EXPR_ATTRIBUTE = "expr";
    public static final String I18N_SRC_PATTERN_ATTRIBUTE = "src-pattern";
    public static final String I18N_PATTERN_ATTRIBUTE = "pattern";
    public static final String I18N_LOCALE_ATTRIBUTE = "locale";
    public static final String I18N_SRC_LOCALE_ATTRIBUTE = "src-locale";
    public static final String I18N_VALUE_ATTRIBUTE = "value";
    public static final String I18N_TYPE_ATTRIBUTE = "type";
    public static final String CURRENCY_LOCALE_ATTRIBUTE = "currency";
    public static final String I18N_CATALOGUE_ATTRIBUTE = "catalogue";
    public static final String I18N_LOCALE = "locale";
    public static final String I18N_DEFAULT_CATALOGUE_ID = "default-catalogue-id";
    public static final String I18N_UNTRANSLATED = "untranslated-text";
    public static final String I18N_PRELOAD = "preload";
    public static final String I18N_FRACTION_DIGITS_ATTRIBUTE = "fraction-digits";
    private static final int STATE_OUTSIDE = 0;
    private static final int STATE_INSIDE_TEXT = 10;
    private static final int STATE_INSIDE_PARAM = 20;
    private static final int STATE_INSIDE_TRANSLATE = 30;
    private static final int STATE_INSIDE_CHOOSE = 50;
    private static final int STATE_INSIDE_WHEN = 51;
    private static final int STATE_INSIDE_OTHERWISE = 52;
    private static final int STATE_INSIDE_DATE = 60;
    private static final int STATE_INSIDE_DATE_TIME = 61;
    private static final int STATE_INSIDE_TIME = 62;
    private static final int STATE_INSIDE_NUMBER = 63;
    private static final Set dateTypes;
    private static final Set numberTypes;
    private static final Map datePatterns;
    protected ServiceManager manager;
    protected BundleFactory factory;
    private Map catalogues;
    private CatalogueInfo defaultCatalogue;
    private String defaultUntranslated;
    protected Map objectModel;
    protected Locale locale;
    private CatalogueInfo catalogue;
    private String untranslated;
    private ParamSaxBuffer untranslatedRecorder;
    private int current_state;
    private int prev_state;
    private String currentKey;
    private String currentCatalogueId;
    private StringBuffer strBuffer;
    private boolean translate_copy;
    private boolean translate_end;
    private ParamSaxBuffer tr_text_recorder;
    private ParamSaxBuffer text_recorder;
    private SaxBuffer param_recorder;
    private int param_count;
    private String param_name;
    private HashMap indexedParams;
    private String param_value;
    private HashMap formattingParams;

    public Locale getLocale() {
        return this.locale;
    }

    public Serializable getKey() {
        StringBuffer key = new StringBuffer();
        if (this.catalogue != null) {
            key.append(this.catalogue.getLocation()[0]);
        }
        key.append("?");
        if (this.locale != null) {
            key.append(this.locale.getLanguage());
            key.append("_");
            key.append(this.locale.getCountry());
            key.append("_");
            key.append(this.locale.getVariant());
        }
        return key.toString();
    }

    public SourceValidity getValidity() {
        return NOPValidity.SHARED_INSTANCE;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
        try {
            this.factory = (BundleFactory)manager.lookup(BundleFactory.ROLE);
        }
        catch (ServiceException e) {
            this.getLogger().debug((Object)("Failed to lookup <" + BundleFactory.ROLE + ">"), (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(Configuration conf) throws ConfigurationException {
        CatalogueInfo catalogueInfo;
        Configuration cataloguesConf = conf.getChild("catalogues", false);
        if (cataloguesConf == null) {
            throw new ConfigurationException("Required <catalogues> configuration is missing.", conf);
        }
        Configuration[] catalogueConfs = cataloguesConf.getChildren(I18N_CATALOGUE_ATTRIBUTE);
        this.catalogues = new HashMap(catalogueConfs.length + 3);
        for (int i = 0; i < catalogueConfs.length; ++i) {
            String[] locations;
            String msg;
            String id = catalogueConfs[i].getAttribute("id");
            String name = catalogueConfs[i].getAttribute(I18N_PARAM_NAME_ATTRIBUTE);
            String location = catalogueConfs[i].getAttribute("location", null);
            Configuration[] locationConf = catalogueConfs[i].getChildren("location");
            if (location != null) {
                if (locationConf.length > 0) {
                    msg = "Location attribute cannot be specified with location elements";
                    this.getLogger().error((Object)msg);
                    throw new ConfigurationException(msg, catalogueConfs[i]);
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("name=" + name + ", location=" + location));
                }
                locations = new String[]{location};
            } else {
                if (locationConf.length == 0) {
                    msg = "A location attribute or location elements must be specified";
                    this.getLogger().error((Object)msg);
                    throw new ConfigurationException(msg, catalogueConfs[i]);
                }
                locations = new String[locationConf.length];
                for (int j = 0; j < locationConf.length; ++j) {
                    locations[j] = locationConf[j].getValue();
                    if (!this.getLogger().isDebugEnabled()) continue;
                    this.getLogger().debug((Object)("name=" + name + ", location=" + locations[j]));
                }
            }
            try {
                catalogueInfo = new CatalogueInfo(name, locations);
            }
            catch (PatternException e) {
                throw new ConfigurationException("Error in name or location attribute on catalogue element with id " + id, catalogueConfs[i], (Throwable)e);
            }
            this.catalogues.put(id, catalogueInfo);
        }
        String defaultCatalogueId = cataloguesConf.getAttribute("default");
        this.defaultCatalogue = (CatalogueInfo)this.catalogues.get(defaultCatalogueId);
        if (this.defaultCatalogue == null) {
            throw new ConfigurationException("Default catalogue id '" + defaultCatalogueId + "' denotes a nonexisting catalogue", cataloguesConf);
        }
        this.defaultUntranslated = conf.getChild(I18N_UNTRANSLATED).getValue(null);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Default untranslated text is '" + this.defaultUntranslated + "'"));
        }
        Configuration[] preloadConfs = conf.getChildren(I18N_PRELOAD);
        for (int i = 0; i < preloadConfs.length; ++i) {
            String localeStr = preloadConfs[i].getValue();
            this.locale = I18nUtils.parseLocale(localeStr);
            String id = preloadConfs[i].getAttribute(I18N_CATALOGUE_ATTRIBUTE, null);
            if (id != null) {
                CatalogueInfo catalogueInfo2 = (CatalogueInfo)this.catalogues.get(id);
                if (catalogueInfo2 == null) {
                    throw new ConfigurationException("Invalid catalogue id '" + id + "' in preload element.", preloadConfs[i]);
                }
                try {
                    catalogueInfo2.getCatalogue();
                    continue;
                }
                finally {
                    catalogueInfo2.releaseCatalog();
                }
            }
            Iterator j = this.catalogues.values().iterator();
            while (j.hasNext()) {
                catalogueInfo = (CatalogueInfo)j.next();
                try {
                    catalogueInfo.getCatalogue();
                }
                finally {
                    catalogueInfo.releaseCatalog();
                }
            }
        }
        this.locale = null;
    }

    public void setup(SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws ProcessingException, SAXException, IOException {
        this.objectModel = objectModel;
        this.untranslated = parameters.getParameter(I18N_UNTRANSLATED, this.defaultUntranslated);
        if (this.untranslated != null) {
            this.untranslatedRecorder = new ParamSaxBuffer();
            this.untranslatedRecorder.characters(this.untranslated.toCharArray(), 0, this.untranslated.length());
        }
        String lc = parameters.getParameter("locale", null);
        Locale locale = I18nUtils.parseLocale(lc);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Using locale '" + locale + "'"));
        }
        this.locale = locale;
        this.current_state = 0;
        this.prev_state = 0;
        this.currentKey = null;
        this.currentCatalogueId = null;
        this.translate_copy = false;
        this.tr_text_recorder = null;
        this.text_recorder = new ParamSaxBuffer();
        this.param_count = 0;
        this.param_name = null;
        this.param_value = null;
        this.param_recorder = null;
        this.indexedParams = new HashMap(3);
        this.formattingParams = null;
        this.strBuffer = null;
        String catalogueId = parameters.getParameter(I18N_DEFAULT_CATALOGUE_ID, null);
        if (catalogueId != null) {
            CatalogueInfo catalogueInfo = (CatalogueInfo)this.catalogues.get(catalogueId);
            if (catalogueInfo == null) {
                throw new ProcessingException("I18nTransformer: '" + catalogueId + "' is not an existing catalogue id.");
            }
            this.catalogue = catalogueInfo;
        } else {
            this.catalogue = this.defaultCatalogue;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Default catalogue is " + this.catalogue.getName()));
        }
    }

    public void startElement(String uri, String name, String raw, Attributes attr) throws SAXException {
        if (this.current_state != 0 && this.strBuffer != null) {
            this.i18nCharacters(this.strBuffer.toString());
            this.strBuffer = null;
        }
        if (I18nUtils.matchesI18nNamespace(uri)) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("Starting i18n element: " + name));
            }
            this.startI18NElement(name, attr);
        } else if (this.current_state == 0) {
            super.startElement(uri, name, raw, this.translateAttributes(name, attr));
        } else if (this.current_state == 20) {
            this.param_recorder.startElement(uri, name, raw, attr);
        } else if (this.current_state == 10) {
            this.text_recorder.startElement(uri, name, raw, attr);
        } else if ((this.current_state == 51 || this.current_state == 52) && this.translate_copy) {
            super.startElement(uri, name, raw, attr);
        }
    }

    public void endElement(String uri, String name, String raw) throws SAXException {
        if (this.current_state != 0 && this.strBuffer != null) {
            this.i18nCharacters(this.strBuffer.toString());
            this.strBuffer = null;
        }
        if (I18nUtils.matchesI18nNamespace(uri)) {
            this.endI18NElement(name);
        } else if (this.current_state == 20) {
            this.param_recorder.endElement(uri, name, raw);
        } else if (this.current_state == 10) {
            this.text_recorder.endElement(uri, name, raw);
        } else if (this.current_state != 50 && (this.current_state != 51 && this.current_state != 52 || this.translate_copy)) {
            super.endElement(uri, name, raw);
        }
    }

    public void characters(char[] ch, int start, int len) throws SAXException {
        if (this.current_state == 0 || (this.current_state == 51 || this.current_state == 52) && this.translate_copy) {
            super.characters(ch, start, len);
        } else {
            if (this.strBuffer == null) {
                this.strBuffer = new StringBuffer();
            }
            this.strBuffer.append(ch, start, len);
        }
    }

    private void startI18NElement(String name, Attributes attr) throws SAXException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Start i18n element: " + name));
        }
        if (I18N_TEXT_ELEMENT.equals(name)) {
            if (this.current_state != 0 && this.current_state != 20 && this.current_state != 30) {
                throw new SAXException(((Object)((Object)this)).getClass().getName() + ": nested i18n:text elements are not allowed." + " Current state: " + this.current_state);
            }
            this.prev_state = this.current_state;
            this.current_state = 10;
            this.currentKey = attr.getValue("", I18N_KEY_ATTRIBUTE);
            if (this.currentKey == null) {
                this.currentKey = attr.getValue(I18N_NAMESPACE_URI, I18N_KEY_ATTRIBUTE);
                if (this.currentKey == null) {
                    this.currentKey = attr.getValue(I18N_OLD_NAMESPACE_URI, I18N_KEY_ATTRIBUTE);
                }
            }
            this.currentCatalogueId = attr.getValue("", I18N_CATALOGUE_ATTRIBUTE);
            if (this.currentCatalogueId == null) {
                this.currentCatalogueId = attr.getValue(I18N_NAMESPACE_URI, I18N_CATALOGUE_ATTRIBUTE);
            }
            if (this.prev_state != 20) {
                this.tr_text_recorder = null;
            }
            if (this.currentKey != null) {
                this.tr_text_recorder = this.getMessage(this.currentKey, (ParamSaxBuffer)null);
            }
        } else if (I18N_TRANSLATE_ELEMENT.equals(name)) {
            if (this.current_state != 0) {
                throw new SAXException(((Object)((Object)this)).getClass().getName() + ": i18n:translate element must be used " + "outside of other i18n elements. Current state: " + this.current_state);
            }
            this.prev_state = this.current_state;
            this.current_state = 30;
        } else if (I18N_PARAM_ELEMENT.equals(name)) {
            if (this.current_state != 30) {
                throw new SAXException(((Object)((Object)this)).getClass().getName() + ": i18n:param element can be used only inside " + "i18n:translate element. Current state: " + this.current_state);
            }
            this.param_name = attr.getValue(I18N_PARAM_NAME_ATTRIBUTE);
            if (this.param_name == null) {
                this.param_name = String.valueOf(this.param_count++);
            }
            this.param_recorder = new SaxBuffer();
            this.setFormattingParams(attr);
            this.current_state = 20;
        } else if (I18N_CHOOSE_ELEMENT.equals(name)) {
            if (this.current_state != 0) {
                throw new SAXException(((Object)((Object)this)).getClass().getName() + ": i18n:choose elements cannot be used" + "inside of other i18n elements.");
            }
            this.translate_copy = false;
            this.translate_end = false;
            this.prev_state = this.current_state;
            this.current_state = 50;
        } else if (I18N_WHEN_ELEMENT.equals(name) || I18N_IF_ELEMENT.equals(name)) {
            if (I18N_WHEN_ELEMENT.equals(name) && this.current_state != 50) {
                throw new SAXException(((Object)((Object)this)).getClass().getName() + ": i18n:when elements are can be used only" + "inside of i18n:choose elements.");
            }
            if (I18N_IF_ELEMENT.equals(name) && this.current_state != 0) {
                throw new SAXException(((Object)((Object)this)).getClass().getName() + ": i18n:if elements cannot be nested.");
            }
            String locale = attr.getValue("locale");
            if (locale == null) {
                throw new SAXException(((Object)((Object)this)).getClass().getName() + ": i18n:" + name + " element cannot be used without 'locale' attribute.");
            }
            if ((!this.translate_end && this.current_state == 50 || this.current_state == 0) && this.locale.toString().startsWith(locale)) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("Locale matching: " + locale));
                }
                this.translate_copy = true;
            }
            this.prev_state = this.current_state;
            this.current_state = 51;
        } else if (I18N_OTHERWISE_ELEMENT.equals(name)) {
            if (this.current_state != 50) {
                throw new SAXException(((Object)((Object)this)).getClass().getName() + ": i18n:otherwise elements are not allowed " + "only inside i18n:choose.");
            }
            this.getLogger().debug((Object)"Matching any locale");
            if (!this.translate_end) {
                this.translate_copy = true;
            }
            this.prev_state = this.current_state;
            this.current_state = 52;
        } else if (I18N_DATE_ELEMENT.equals(name)) {
            if (this.current_state != 0 && this.current_state != 10 && this.current_state != 20) {
                throw new SAXException(((Object)((Object)this)).getClass().getName() + ": i18n:date elements are not allowed " + "inside of other i18n elements.");
            }
            this.setFormattingParams(attr);
            this.prev_state = this.current_state;
            this.current_state = 60;
        } else if (I18N_DATE_TIME_ELEMENT.equals(name)) {
            if (this.current_state != 0 && this.current_state != 10 && this.current_state != 20) {
                throw new SAXException(((Object)((Object)this)).getClass().getName() + ": i18n:date-time elements are not allowed " + "inside of other i18n elements.");
            }
            this.setFormattingParams(attr);
            this.prev_state = this.current_state;
            this.current_state = 61;
        } else if (I18N_TIME_ELEMENT.equals(name)) {
            if (this.current_state != 0 && this.current_state != 10 && this.current_state != 20) {
                throw new SAXException(((Object)((Object)this)).getClass().getName() + ": i18n:date elements are not allowed " + "inside of other i18n elements.");
            }
            this.setFormattingParams(attr);
            this.prev_state = this.current_state;
            this.current_state = 62;
        } else if (I18N_NUMBER_ELEMENT.equals(name)) {
            if (this.current_state != 0 && this.current_state != 10 && this.current_state != 20) {
                throw new SAXException(((Object)((Object)this)).getClass().getName() + ": i18n:number elements are not allowed " + "inside of other i18n elements.");
            }
            this.setFormattingParams(attr);
            this.prev_state = this.current_state;
            this.current_state = 63;
        }
    }

    private void setFormattingParams(Attributes attr) {
        this.formattingParams = new HashMap(3);
        String attr_value = attr.getValue(I18N_SRC_PATTERN_ATTRIBUTE);
        if (attr_value != null) {
            this.formattingParams.put(I18N_SRC_PATTERN_ATTRIBUTE, attr_value);
        }
        if ((attr_value = attr.getValue(I18N_PATTERN_ATTRIBUTE)) != null) {
            this.formattingParams.put(I18N_PATTERN_ATTRIBUTE, attr_value);
        }
        if ((attr_value = attr.getValue(I18N_VALUE_ATTRIBUTE)) != null) {
            this.formattingParams.put(I18N_VALUE_ATTRIBUTE, attr_value);
        }
        if ((attr_value = attr.getValue("locale")) != null) {
            this.formattingParams.put("locale", attr_value);
        }
        if ((attr_value = attr.getValue("currency")) != null) {
            this.formattingParams.put("currency", attr_value);
        }
        if ((attr_value = attr.getValue(I18N_SRC_LOCALE_ATTRIBUTE)) != null) {
            this.formattingParams.put(I18N_SRC_LOCALE_ATTRIBUTE, attr_value);
        }
        if ((attr_value = attr.getValue(I18N_TYPE_ATTRIBUTE)) != null) {
            this.formattingParams.put(I18N_TYPE_ATTRIBUTE, attr_value);
        }
        if ((attr_value = attr.getValue(I18N_FRACTION_DIGITS_ATTRIBUTE)) != null) {
            this.formattingParams.put(I18N_FRACTION_DIGITS_ATTRIBUTE, attr_value);
        }
    }

    private void endI18NElement(String name) throws SAXException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("End i18n element: " + name));
        }
        switch (this.current_state) {
            case 10: {
                this.endTextElement();
                break;
            }
            case 30: {
                this.endTranslateElement();
                break;
            }
            case 50: {
                this.endChooseElement();
                break;
            }
            case 51: 
            case 52: {
                this.endWhenElement();
                break;
            }
            case 20: {
                this.endParamElement();
                break;
            }
            case 60: 
            case 61: 
            case 62: {
                this.endDate_TimeElement();
                break;
            }
            case 63: {
                this.endNumberElement();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void i18nCharacters(String textValue) throws SAXException {
        void var2_2;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("i18n message text = '" + textValue + "'"));
        }
        switch (this.current_state) {
            case 10: {
                ParamSaxBuffer buffer = this.text_recorder;
                break;
            }
            case 20: {
                ParamSaxBuffer buffer = this.param_recorder;
                break;
            }
            case 51: 
            case 52: {
                return;
            }
            case 30: {
                if (this.tr_text_recorder == null) {
                    this.tr_text_recorder = new ParamSaxBuffer();
                }
                ParamSaxBuffer buffer = this.tr_text_recorder;
                break;
            }
            case 50: {
                if (this.getLogger().isDebugEnabled() && (textValue = textValue.trim()).length() > 0) {
                    this.getLogger().debug((Object)("No characters allowed inside <i18n:choose> tag. Received: " + textValue));
                }
                return;
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                textValue = textValue.trim();
                if (textValue.length() > 0 && this.formattingParams.get(I18N_VALUE_ATTRIBUTE) == null) {
                    this.formattingParams.put(I18N_VALUE_ATTRIBUTE, textValue);
                }
                return;
            }
            default: {
                throw new IllegalStateException(((Object)((Object)this)).getClass().getName() + " developer's fault: characters not handled. " + "Current state: " + this.current_state);
            }
        }
        char[] ch = textValue.toCharArray();
        var2_2.characters(ch, 0, ch.length);
    }

    private Attributes translateAttributes(final String element, Attributes attr) throws SAXException {
        int index;
        String name;
        StringTokenizer st;
        if (attr == null) {
            return null;
        }
        AttributesImpl tempAttr = null;
        int attrIndex = attr.getIndex(I18N_NAMESPACE_URI, I18N_ATTR_ATTRIBUTE);
        if (attrIndex == -1) {
            attrIndex = attr.getIndex(I18N_OLD_NAMESPACE_URI, I18N_ATTR_ATTRIBUTE);
        }
        if (attrIndex != -1) {
            st = new StringTokenizer(attr.getValue(attrIndex));
            tempAttr = new AttributesImpl(attr);
            tempAttr.removeAttribute(attrIndex);
            while (st.hasMoreElements()) {
                name = st.nextToken();
                index = tempAttr.getIndex(name);
                if (index == -1) {
                    this.getLogger().warn((Object)("Attribute " + name + " not found in element <" + element + ">"));
                    continue;
                }
                String value = this.translateAttribute(element, name, tempAttr.getValue(index));
                if (value == null) continue;
                tempAttr.setValue(index, value);
            }
            attr = tempAttr;
        }
        if ((attrIndex = attr.getIndex(I18N_NAMESPACE_URI, I18N_EXPR_ATTRIBUTE)) != -1) {
            st = new StringTokenizer(attr.getValue(attrIndex));
            if (tempAttr == null) {
                tempAttr = new AttributesImpl(attr);
            }
            tempAttr.removeAttribute(attrIndex);
            while (st.hasMoreElements()) {
                name = st.nextToken();
                index = tempAttr.getIndex(name);
                if (index == -1) {
                    this.getLogger().warn((Object)("Attribute " + name + " not found in element <" + element + ">"));
                    continue;
                }
                final StringBuffer translated = new StringBuffer();
                VariableExpressionTokenizer.TokenReciever tr = new VariableExpressionTokenizer.TokenReciever(){
                    private String catalogueName;

                    public void addToken(int type, String value) {
                        if (type == -6) {
                            this.catalogueName = value;
                        } else if (type == -8) {
                            translated.append(I18nTransformer.this.translateAttribute(element, name, value));
                        } else if (type == -5) {
                            if (this.catalogueName != null) {
                                translated.append(I18nTransformer.this.translateAttribute(element, name, this.catalogueName + ":" + value));
                                this.catalogueName = null;
                            } else if (value != null) {
                                translated.append(value);
                            }
                        }
                    }
                };
                try {
                    VariableExpressionTokenizer.tokenize((String)tempAttr.getValue(index), (VariableExpressionTokenizer.TokenReciever)tr);
                }
                catch (PatternException e) {
                    throw new SAXException((Exception)((Object)e));
                }
                tempAttr.setValue(index, translated.toString());
            }
            attr = tempAttr;
        }
        return attr;
    }

    private String translateAttribute(String element, String name, String key) {
        ParamSaxBuffer text;
        int colonPos = key.indexOf(":");
        String catalogueID = null;
        if (colonPos != -1) {
            catalogueID = key.substring(0, colonPos);
            key = key.substring(colonPos + 1, key.length());
        }
        if ((text = this.getMessage(catalogueID, key)) == null) {
            this.getLogger().warn((Object)("Translation not found for attribute " + name + " in element <" + element + ">"));
            return this.untranslated;
        }
        return text.toString();
    }

    private void endTextElement() throws SAXException {
        switch (this.prev_state) {
            case 0: {
                if (this.tr_text_recorder == null) {
                    if (this.currentKey == null) {
                        this.tr_text_recorder = this.getMessage(this.text_recorder.toString(), this.text_recorder);
                    } else {
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug((Object)("Translation not found for key '" + this.currentKey + "'"));
                        }
                        this.tr_text_recorder = this.text_recorder.isEmpty() && this.untranslatedRecorder != null ? this.untranslatedRecorder : this.text_recorder;
                    }
                }
                if (this.tr_text_recorder != null) {
                    this.tr_text_recorder.toSAX(this.contentHandler);
                }
                this.text_recorder.recycle();
                this.tr_text_recorder = null;
                this.currentKey = null;
                this.currentCatalogueId = null;
                break;
            }
            case 30: {
                if (this.tr_text_recorder == null && !this.text_recorder.isEmpty()) {
                    this.tr_text_recorder = this.getMessage(this.text_recorder.toString(), this.text_recorder);
                    if (this.tr_text_recorder == this.text_recorder) {
                        this.tr_text_recorder = new ParamSaxBuffer(this.text_recorder);
                    }
                }
                this.text_recorder.recycle();
                break;
            }
            case 20: {
                if (this.text_recorder.isEmpty()) break;
                this.getMessage(this.text_recorder.toString(), this.text_recorder).toSAX((ContentHandler)this.param_recorder);
                this.text_recorder.recycle();
            }
        }
        this.current_state = this.prev_state;
        this.prev_state = 0;
    }

    private void endParamElement() throws SAXException {
        String paramType = (String)this.formattingParams.get(I18N_TYPE_ATTRIBUTE);
        if (paramType != null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("Param type: " + paramType));
            }
            if (this.formattingParams.get(I18N_VALUE_ATTRIBUTE) == null && this.param_value != null) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("Put param value: " + this.param_value));
                }
                this.formattingParams.put(I18N_VALUE_ATTRIBUTE, this.param_value);
            }
            if (dateTypes.contains(paramType)) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("Formatting date_time param: " + this.formattingParams));
                }
                this.param_value = this.formatDate_Time(this.formattingParams);
            } else if (numberTypes.contains(paramType)) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("Formatting number param: " + this.formattingParams));
                }
                this.param_value = this.formatNumber(this.formattingParams);
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("Added substitution param: " + this.param_value));
            }
        }
        this.param_value = null;
        this.current_state = 30;
        if (this.param_recorder == null) {
            return;
        }
        this.indexedParams.put(this.param_name, this.param_recorder);
        this.param_recorder = null;
    }

    private void endTranslateElement() throws SAXException {
        if (this.tr_text_recorder != null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("End of translate with params. Fragment for substitution : " + (Object)((Object)this.tr_text_recorder)));
            }
            this.tr_text_recorder.toSAX(this.contentHandler, this.indexedParams);
            this.tr_text_recorder = null;
            this.text_recorder.recycle();
        }
        this.indexedParams.clear();
        this.param_count = 0;
        this.current_state = 0;
    }

    private void endChooseElement() {
        this.current_state = 0;
    }

    private void endWhenElement() {
        this.current_state = this.prev_state;
        if (this.translate_copy) {
            this.translate_copy = false;
            this.translate_end = true;
        }
    }

    private void endDate_TimeElement() throws SAXException {
        String result = this.formatDate_Time(this.formattingParams);
        switch (this.prev_state) {
            case 0: {
                this.contentHandler.characters(result.toCharArray(), 0, result.length());
                break;
            }
            case 20: {
                this.param_recorder.characters(result.toCharArray(), 0, result.length());
                break;
            }
            case 10: {
                this.text_recorder.characters(result.toCharArray(), 0, result.length());
            }
        }
        this.current_state = this.prev_state;
    }

    private Locale getLocale(Map params, String attribute) {
        String lc = (String)params.get(attribute);
        return I18nUtils.parseLocale(lc, this.locale);
    }

    /*
     * WARNING - void declaration
     */
    private String formatDate_Time(Map params) throws SAXException {
        void var14_14;
        Date dateValue;
        SimpleDateFormat from_fmt;
        SimpleDateFormat to_fmt;
        Integer patternValue;
        if (params == null) {
            throw new IllegalArgumentException("Nothing to format");
        }
        int srcStyle = 2;
        int style = 2;
        boolean realPattern = false;
        boolean realSrcPattern = false;
        Locale srcLoc = this.getLocale(params, I18N_SRC_LOCALE_ATTRIBUTE);
        Locale loc = this.getLocale(params, "locale");
        String srcPattern = (String)params.get(I18N_SRC_PATTERN_ATTRIBUTE);
        String pattern = (String)params.get(I18N_PATTERN_ATTRIBUTE);
        String value = (String)params.get(I18N_VALUE_ATTRIBUTE);
        if (srcPattern != null) {
            patternValue = (Integer)datePatterns.get(srcPattern.toUpperCase());
            if (patternValue != null) {
                srcStyle = patternValue;
            } else {
                realSrcPattern = true;
            }
        }
        if (pattern != null) {
            patternValue = (Integer)datePatterns.get(pattern.toUpperCase());
            if (patternValue != null) {
                style = patternValue;
            } else {
                realPattern = true;
            }
        }
        String paramType = (String)this.formattingParams.get(I18N_TYPE_ATTRIBUTE);
        if (this.current_state == 60 || I18N_DATE_ELEMENT.equals(paramType)) {
            to_fmt = (SimpleDateFormat)DateFormat.getDateInstance(style, loc);
            from_fmt = (SimpleDateFormat)DateFormat.getDateInstance(srcStyle, srcLoc);
        } else if (this.current_state == 61 || I18N_DATE_TIME_ELEMENT.equals(paramType)) {
            to_fmt = (SimpleDateFormat)DateFormat.getDateTimeInstance(style, style, loc);
            from_fmt = (SimpleDateFormat)DateFormat.getDateTimeInstance(srcStyle, srcStyle, srcLoc);
        } else {
            to_fmt = (SimpleDateFormat)DateFormat.getTimeInstance(style, loc);
            from_fmt = (SimpleDateFormat)DateFormat.getTimeInstance(srcStyle, srcLoc);
        }
        if (realSrcPattern) {
            from_fmt.applyPattern(srcPattern);
        }
        if (realPattern) {
            to_fmt.applyPattern(pattern);
        }
        if (value == null) {
            dateValue = new Date();
        } else {
            try {
                dateValue = from_fmt.parse(value);
            }
            catch (ParseException pe) {
                throw new SAXException(((Object)((Object)this)).getClass().getName() + "i18n:date - parsing error.", pe);
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("### Formatting date: " + var14_14 + " with localized pattern " + to_fmt.toLocalizedPattern() + " for locale: " + this.locale));
        }
        return to_fmt.format((Date)var14_14);
    }

    private void endNumberElement() throws SAXException {
        String result = this.formatNumber(this.formattingParams);
        switch (this.prev_state) {
            case 0: {
                this.contentHandler.characters(result.toCharArray(), 0, result.length());
                break;
            }
            case 20: {
                this.param_recorder.characters(result.toCharArray(), 0, result.length());
                break;
            }
            case 10: {
                this.text_recorder.characters(result.toCharArray(), 0, result.length());
            }
        }
        this.current_state = this.prev_state;
    }

    /*
     * WARNING - void declaration
     */
    private String formatNumber(Map params) throws SAXException {
        Number numberValue;
        void var14_18;
        DecimalFormat to_fmt;
        if (params == null) {
            throw new SAXException(((Object)((Object)this)).getClass().getName() + ": i18n:number - error in element attributes.");
        }
        String srcPattern = (String)params.get(I18N_SRC_PATTERN_ATTRIBUTE);
        String pattern = (String)params.get(I18N_PATTERN_ATTRIBUTE);
        String value = (String)params.get(I18N_VALUE_ATTRIBUTE);
        if (value == null) {
            return "";
        }
        String type = (String)params.get(I18N_TYPE_ATTRIBUTE);
        int fractionDigits = -1;
        try {
            String fd = (String)params.get(I18N_FRACTION_DIGITS_ATTRIBUTE);
            if (fd != null) {
                fractionDigits = Integer.parseInt(fd);
            }
        }
        catch (NumberFormatException nfe) {
            this.getLogger().warn((Object)"Error in number format with fraction-digits", (Throwable)nfe);
        }
        Locale loc = this.getLocale(params, "locale");
        Locale srcLoc = this.getLocale(params, I18N_SRC_LOCALE_ATTRIBUTE);
        Locale currencyLoc = this.getLocale(params, "currency");
        Locale dgLoc = null;
        if (currencyLoc != null) {
            dgLoc = loc;
            loc = currencyLoc;
        }
        DecimalFormat from_fmt = (DecimalFormat)NumberFormat.getInstance(srcLoc);
        int int_currency = 0;
        if (srcPattern != null) {
            from_fmt.applyPattern(srcPattern);
        }
        char dec = from_fmt.getDecimalFormatSymbols().getDecimalSeparator();
        int decAt = 0;
        boolean appendDec = false;
        if (type == null || type.equals(I18N_NUMBER_ELEMENT)) {
            to_fmt = (DecimalFormat)NumberFormat.getInstance(loc);
            to_fmt.setMaximumFractionDigits(309);
            int i = value.length() - 1;
            while (i >= 0 && value.charAt(i) != dec) {
                --i;
                ++decAt;
            }
            if (decAt < value.length()) {
                to_fmt.setMinimumFractionDigits(decAt);
            }
            decAt = 0;
            for (i = 0; i < value.length() && value.charAt(i) != dec; ++i) {
                if (!Character.isDigit(value.charAt(i))) continue;
                ++decAt;
            }
            to_fmt.setMinimumIntegerDigits(decAt);
            if (value.charAt(value.length() - 1) == dec) {
                appendDec = true;
            }
        } else if (type.equals("currency")) {
            to_fmt = (DecimalFormat)NumberFormat.getCurrencyInstance(loc);
        } else if (type.equals(I18N_INT_CURRENCY_ELEMENT)) {
            to_fmt = (DecimalFormat)NumberFormat.getCurrencyInstance(loc);
            int_currency = 1;
            for (int i = 0; i < to_fmt.getMaximumFractionDigits(); ++i) {
                int_currency *= 10;
            }
        } else if (type.equals(I18N_CURRENCY_NO_UNIT_ELEMENT)) {
            DecimalFormat tmp = (DecimalFormat)NumberFormat.getCurrencyInstance(loc);
            to_fmt = (DecimalFormat)NumberFormat.getInstance(loc);
            to_fmt.setMinimumFractionDigits(tmp.getMinimumFractionDigits());
            to_fmt.setMaximumFractionDigits(tmp.getMaximumFractionDigits());
        } else if (type.equals(I18N_INT_CURRENCY_NO_UNIT_ELEMENT)) {
            DecimalFormat tmp = (DecimalFormat)NumberFormat.getCurrencyInstance(loc);
            int_currency = 1;
            for (int i = 0; i < tmp.getMaximumFractionDigits(); ++i) {
                int_currency *= 10;
            }
            to_fmt = (DecimalFormat)NumberFormat.getInstance(loc);
            to_fmt.setMinimumFractionDigits(tmp.getMinimumFractionDigits());
            to_fmt.setMaximumFractionDigits(tmp.getMaximumFractionDigits());
        } else if (type.equals(I18N_PERCENT_ELEMENT)) {
            to_fmt = (DecimalFormat)NumberFormat.getPercentInstance(loc);
        } else {
            throw new SAXException("&lt;i18n:number>: unknown type: " + type);
        }
        if (fractionDigits > -1) {
            var14_18.setMinimumFractionDigits(fractionDigits);
            var14_18.setMaximumFractionDigits(fractionDigits);
        }
        if (dgLoc != null) {
            DecimalFormat df = (DecimalFormat)NumberFormat.getCurrencyInstance(dgLoc);
            DecimalFormatSymbols dfsNew = df.getDecimalFormatSymbols();
            DecimalFormatSymbols dfsOrig = var14_18.getDecimalFormatSymbols();
            dfsOrig.setDecimalSeparator(dfsNew.getDecimalSeparator());
            dfsOrig.setMonetaryDecimalSeparator(dfsNew.getMonetaryDecimalSeparator());
            dfsOrig.setGroupingSeparator(dfsNew.getGroupingSeparator());
            var14_18.setDecimalFormatSymbols(dfsOrig);
        }
        if (pattern != null) {
            var14_18.applyPattern(pattern);
        }
        try {
            numberValue = from_fmt.parse(value);
            if (int_currency > 0) {
                numberValue = new Double(numberValue.doubleValue() / (double)int_currency);
            }
        }
        catch (ParseException pe) {
            throw new SAXException(((Object)((Object)this)).getClass().getName() + "i18n:number - parsing error.", pe);
        }
        String result = var14_18.format(numberValue);
        if (appendDec) {
            result = result + dec;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("i18n:number result: " + result));
        }
        return result;
    }

    protected ParamSaxBuffer getMessage(String catalogueID, String key) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Getting key " + key + " from catalogue " + catalogueID));
        }
        CatalogueInfo catalogue = this.catalogue;
        if (catalogueID != null && (catalogue = (CatalogueInfo)this.catalogues.get(catalogueID)) == null) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn((Object)("Catalogue not found: " + catalogueID + ", will not translate key " + key));
            }
            return null;
        }
        Bundle bundle = catalogue.getCatalogue();
        if (bundle == null) {
            this.getLogger().debug((Object)("Untranslated key: '" + key + "'"));
            return null;
        }
        try {
            return (ParamSaxBuffer)((Object)bundle.getObject(key));
        }
        catch (MissingResourceException e) {
            this.getLogger().debug((Object)("Untranslated key: '" + key + "'"));
            return null;
        }
    }

    private ParamSaxBuffer getMessage(String key, ParamSaxBuffer defaultValue) {
        ParamSaxBuffer value = this.getMessage(this.currentCatalogueId, key);
        if (value == null) {
            this.getLogger().debug((Object)("Untranslated key: '" + key + "'"));
            return defaultValue;
        }
        return new ParamSaxBuffer(value);
    }

    public void recycle() {
        this.untranslatedRecorder = null;
        this.catalogue = null;
        this.objectModel = null;
        Iterator i = this.catalogues.values().iterator();
        while (i.hasNext()) {
            CatalogueInfo catalogueInfo = (CatalogueInfo)i.next();
            catalogueInfo.releaseCatalog();
        }
        super.recycle();
    }

    public void dispose() {
        if (this.manager != null) {
            this.manager.release((Object)this.factory);
        }
        this.factory = null;
        this.manager = null;
        this.catalogues = null;
    }

    static {
        HashSet<String> set = new HashSet<String>(5);
        set.add(I18N_DATE_ELEMENT);
        set.add(I18N_TIME_ELEMENT);
        set.add(I18N_DATE_TIME_ELEMENT);
        dateTypes = Collections.unmodifiableSet(set);
        set = new HashSet(9);
        set.add(I18N_NUMBER_ELEMENT);
        set.add(I18N_PERCENT_ELEMENT);
        set.add("currency");
        set.add(I18N_INT_CURRENCY_ELEMENT);
        set.add(I18N_CURRENCY_NO_UNIT_ELEMENT);
        set.add(I18N_INT_CURRENCY_NO_UNIT_ELEMENT);
        numberTypes = Collections.unmodifiableSet(set);
        HashMap<String, Integer> map = new HashMap<String, Integer>(7);
        map.put("SHORT", new Integer(3));
        map.put("MEDIUM", new Integer(2));
        map.put("LONG", new Integer(1));
        map.put("FULL", new Integer(0));
        datePatterns = Collections.unmodifiableMap(map);
    }

    public final class CatalogueInfo {
        VariableResolver name;
        VariableResolver[] locations;
        String resolvedName;
        String[] resolvedLocations;
        Bundle catalogue;

        public CatalogueInfo(String name, String[] locations) throws PatternException {
            this.name = VariableResolverFactory.getResolver((String)name, (ServiceManager)I18nTransformer.this.manager);
            this.locations = new VariableResolver[locations.length];
            for (int i = 0; i < locations.length; ++i) {
                this.locations[i] = VariableResolverFactory.getResolver((String)locations[i], (ServiceManager)I18nTransformer.this.manager);
            }
        }

        public String getName() {
            try {
                if (this.resolvedName == null) {
                    this.resolve();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.resolvedName;
        }

        public String[] getLocation() {
            try {
                if (this.resolvedName == null) {
                    this.resolve();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.resolvedLocations;
        }

        private void resolve() throws Exception {
            if (this.resolvedLocations == null) {
                this.resolvedLocations = new String[this.locations.length];
                for (int i = 0; i < this.resolvedLocations.length; ++i) {
                    this.resolvedLocations[i] = this.locations[i].resolve(null, I18nTransformer.this.objectModel);
                }
            }
            if (this.resolvedName == null) {
                this.resolvedName = this.name.resolve(null, I18nTransformer.this.objectModel);
            }
        }

        public Bundle getCatalogue() {
            if (this.catalogue == null) {
                try {
                    this.resolve();
                    this.catalogue = I18nTransformer.this.factory.select(this.resolvedLocations, this.resolvedName, I18nTransformer.this.locale);
                }
                catch (Exception e) {
                    I18nTransformer.this.getLogger().error((Object)("Error obtaining catalogue '" + this.getName() + "' from  <" + this.getLocation() + "> for locale " + I18nTransformer.this.locale), (Throwable)e);
                }
            }
            return this.catalogue;
        }

        public void releaseCatalog() {
            if (this.catalogue != null) {
                I18nTransformer.this.factory.release(this.catalogue);
            }
            this.catalogue = null;
            this.resolvedName = null;
            this.resolvedLocations = null;
        }
    }
}

