/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.servlet.multipart;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;
import org.apache.cocoon.servlet.multipart.MultipartException;
import org.apache.cocoon.servlet.multipart.MultipartHttpServletRequest;
import org.apache.cocoon.servlet.multipart.MultipartParser;

public class RequestFactory {
    private boolean saveUploadedFilesToDisk;
    private File uploadDirectory;
    private boolean allowOverwrite;
    private boolean silentlyRename;
    private String defaultCharEncoding;
    private int maxUploadSize;

    public RequestFactory(boolean saveUploadedFilesToDisk, File uploadDirectory, boolean allowOverwrite, boolean silentlyRename, int maxUploadSize, String defaultCharEncoding) {
        this.saveUploadedFilesToDisk = saveUploadedFilesToDisk;
        this.uploadDirectory = uploadDirectory;
        this.allowOverwrite = allowOverwrite;
        this.silentlyRename = silentlyRename;
        this.maxUploadSize = maxUploadSize;
        this.defaultCharEncoding = defaultCharEncoding;
        if (saveUploadedFilesToDisk) {
            File[] files = uploadDirectory.listFiles();
            for (int i = 0; i < files.length; ++i) {
                files[i].delete();
            }
        }
    }

    public HttpServletRequest getServletRequest(HttpServletRequest request) throws IOException, MultipartException {
        Object req = request;
        String contentType = request.getContentType();
        if (contentType != null && contentType.toLowerCase().indexOf("multipart/form-data") > -1) {
            String charEncoding = request.getCharacterEncoding();
            if (charEncoding == null || charEncoding.equals("")) {
                charEncoding = this.defaultCharEncoding;
            }
            MultipartParser parser = new MultipartParser(this.saveUploadedFilesToDisk, this.uploadDirectory, this.allowOverwrite, this.silentlyRename, this.maxUploadSize, charEncoding);
            Hashtable parts = parser.getParts(request);
            req = new MultipartHttpServletRequest(request, parts);
        }
        return req;
    }
}

