/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.servlet.multipart;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.commons.io.IOUtils;
import org.apache.excalibur.source.ModifiableSource;

public abstract class Part
implements Disposable {
    private boolean disposeWithRequest = true;
    protected Map headers;

    protected Part(Map headers) {
        this.headers = headers;
    }

    public Map getHeaders() {
        return this.headers;
    }

    public abstract String getFileName();

    public String getUploadName() {
        return (String)this.headers.get("filename");
    }

    public abstract int getSize();

    public boolean isRejected() {
        return false;
    }

    public String getMimeType() {
        return (String)this.headers.get("content-type");
    }

    public boolean disposeWithRequest() {
        return this.disposeWithRequest;
    }

    public void setDisposeWithRequest(boolean dispose) {
        this.disposeWithRequest = dispose;
    }

    public abstract InputStream getInputStream() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyToSource(ModifiableSource source) throws IOException {
        InputStream is = this.getInputStream();
        try {
            OutputStream os = source.getOutputStream();
            try {
                IOUtils.copy((InputStream)is, (OutputStream)os);
            }
            finally {
                os.close();
            }
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyToFile(String filename) throws IOException {
        InputStream is = this.getInputStream();
        try {
            FileOutputStream os = new FileOutputStream(filename);
            try {
                IOUtils.copy((InputStream)is, (OutputStream)os);
            }
            finally {
                ((OutputStream)os).close();
            }
        }
        finally {
            is.close();
        }
    }

    public abstract void dispose();
}

