/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cocoon.components.notification.DefaultNotifyingBuilder;
import org.apache.cocoon.components.notification.Notifier;
import org.apache.cocoon.components.notification.Notifying;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.servlet.ServletSettings;
import org.apache.cocoon.servlet.UriHttpServletRequestWrapper;
import org.apache.commons.logging.Log;

public class RequestUtil {
    public static String getCompleteUri(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String pathInfo;
        String uri = request.getServletPath();
        if (uri == null) {
            uri = "";
        }
        if ((pathInfo = request.getPathInfo()) != null) {
            if (uri.length() > 0 && uri.charAt(0) == '/') {
                uri = uri.substring(1);
            }
            uri = uri + pathInfo;
        }
        if (uri.length() == 0) {
            String serverAbsoluteUri = request.getRequestURI();
            serverAbsoluteUri = serverAbsoluteUri == null ? "/" : serverAbsoluteUri + "/";
            response.sendRedirect(response.encodeRedirectURL(serverAbsoluteUri));
            return null;
        }
        if (uri.charAt(0) == '/') {
            uri = uri.substring(1);
        }
        return uri;
    }

    public static String getCompleteBlockUri(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String uri;
        String servletPath = request.getServletPath();
        if (servletPath == null) {
            servletPath = "";
        }
        if ((uri = request.getPathInfo()) == null) {
            uri = "";
        }
        if (uri.length() == 0 && !servletPath.endsWith("/")) {
            String serverAbsoluteUri = request.getRequestURI();
            serverAbsoluteUri = serverAbsoluteUri == null ? "/" : serverAbsoluteUri + "/";
            response.sendRedirect(response.encodeRedirectURL(serverAbsoluteUri));
            return null;
        }
        if (uri.length() > 0 && uri.charAt(0) == '/') {
            return uri.substring(1);
        }
        return uri;
    }

    public static HttpServletRequest createRequestForUri(HttpServletRequest request, String servletPath, String pathInfo) {
        return new UriHttpServletRequestWrapper(request, servletPath, pathInfo);
    }

    public static HttpServletRequest createRequestByRemovingPrefixFromUri(HttpServletRequest request, String prefix) {
        String servletPath = request.getServletPath();
        String pathInfo = request.getPathInfo();
        String newPathInfo = pathInfo.substring(prefix.length() + 1);
        String newServletPath = servletPath == null ? pathInfo.substring(0, prefix.length() + 1) : servletPath + pathInfo.substring(0, prefix.length() + 1);
        return new UriHttpServletRequestWrapper(request, newServletPath, newPathInfo);
    }

    public static void manageException(HttpServletRequest req, HttpServletResponse res, Environment env, String uri, int errorStatus, String title, String message, String description, Exception e, ServletSettings settings, Log logger, Object sender) throws IOException {
        RequestUtil.manageException(req, res, env, uri, errorStatus, title, message, description, e, settings, logger.isInfoEnabled(), sender);
    }

    private static void manageException(HttpServletRequest req, HttpServletResponse res, Environment env, String uri, int errorStatus, String title, String message, String description, Exception e, ServletSettings settings, boolean verbose, Object sender) throws IOException {
        if (settings.isManageExceptions()) {
            if (env != null) {
                env.tryResetResponse();
            } else {
                res.reset();
            }
            String type = "fatal";
            HashMap<String, String> extraDescriptions = null;
            if (errorStatus == 404) {
                type = "resource-not-found";
                e = null;
            } else {
                extraDescriptions = new HashMap<String, String>(2);
                extraDescriptions.put("request-uri", req.getRequestURI());
                if (uri != null) {
                    extraDescriptions.put("Request URI", uri);
                }
                if (verbose) {
                    Throwable t = DefaultNotifyingBuilder.getRootCause((Throwable)e);
                    if (t != null) {
                        extraDescriptions.put("cause", t.getMessage());
                    }
                    e = null;
                }
            }
            Notifying n = new DefaultNotifyingBuilder().build(sender, (Object)e, type, title, "Cocoon Servlet", message, description, extraDescriptions);
            res.setContentType("text/html");
            res.setStatus(errorStatus);
            Notifier.notify((Notifying)n, (OutputStream)res.getOutputStream(), (String)"text/html");
        } else {
            res.sendError(errorStatus, title);
            res.flushBuffer();
        }
    }
}

