/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.matching;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.i18n.I18nUtils;
import org.apache.cocoon.matching.Matcher;
import org.apache.cocoon.sitemap.PatternException;
import org.apache.cocoon.util.AbstractLogEnabled;
import org.apache.commons.lang.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;

public class LocaleMatcher
extends AbstractLogEnabled
implements Matcher,
ThreadSafe,
Serviceable,
Configurable,
Disposable {
    private static final String DEFAULT_LOCALE_ATTRIBUTE = "locale";
    private static final String DEFAULT_DEFAULT_LANG = "en";
    private static final String DEFAULT_DEFAULT_COUNTRY = "US";
    private static final String DEFAULT_DEFAULT_VARIANT = "";
    private ServiceManager manager;
    private SourceResolver resolver;
    private String localeAttribute;
    private boolean useLocale;
    private boolean useLocales;
    private Locale defaultLocale;
    private boolean useBlankLocale;
    private boolean testResourceExists;
    private boolean storeInRequest;
    private boolean storeInSession;
    private boolean createSession;
    private boolean storeInCookie;

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
        this.resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
    }

    public void configure(Configuration config) {
        this.storeInRequest = config.getChild("store-in-request").getValueAsBoolean(false);
        this.createSession = config.getChild("create-session").getValueAsBoolean(false);
        this.storeInSession = config.getChild("store-in-session").getValueAsBoolean(false);
        this.storeInCookie = config.getChild("store-in-cookie").getValueAsBoolean(false);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)((this.storeInRequest ? "will" : "won't") + " set values in request"));
            this.getLogger().debug((Object)((this.createSession ? "will" : "won't") + " create session"));
            this.getLogger().debug((Object)((this.storeInSession ? "will" : "won't") + " set values in session"));
            this.getLogger().debug((Object)((this.storeInCookie ? "will" : "won't") + " set values in cookies"));
        }
        this.localeAttribute = config.getChild("locale-attribute").getValue(DEFAULT_LOCALE_ATTRIBUTE);
        this.testResourceExists = config.getChild("negotiate").getValueAsBoolean(false);
        this.useLocale = config.getChild("use-locale").getValueAsBoolean(true);
        this.useLocales = config.getChild("use-locales").getValueAsBoolean(false);
        this.useBlankLocale = config.getChild("use-blank-locale").getValueAsBoolean(true);
        Configuration child = config.getChild("default-locale", false);
        if (child != null) {
            this.defaultLocale = new Locale(child.getAttribute("language", DEFAULT_DEFAULT_LANG), child.getAttribute("country", DEFAULT_DEFAULT_COUNTRY), child.getAttribute("variant", DEFAULT_DEFAULT_VARIANT));
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Locale attribute name is " + this.localeAttribute));
            this.getLogger().debug((Object)((this.testResourceExists ? "will" : "won't") + " negotiate locale"));
            this.getLogger().debug((Object)((this.useLocale ? "will" : "won't") + " use request locale"));
            this.getLogger().debug((Object)((this.useLocales ? "will" : "won't") + " use request locales"));
            this.getLogger().debug((Object)((this.useBlankLocale ? "will" : "won't") + " blank locales"));
            this.getLogger().debug((Object)("default locale " + this.defaultLocale));
        }
    }

    public void dispose() {
        this.manager.release((Object)this.resolver);
        this.resolver = null;
        this.manager = null;
    }

    public Map match(final String pattern, Map objectModel, Parameters parameters) throws PatternException {
        final HashMap map = new HashMap();
        I18nUtils.LocaleValidator validator = new I18nUtils.LocaleValidator(){

            public boolean test(String name, Locale locale) {
                if (LocaleMatcher.this.getLogger().isDebugEnabled()) {
                    LocaleMatcher.this.getLogger().debug((Object)("Testing " + name + " locale: '" + locale + "'"));
                }
                return LocaleMatcher.this.isValidResource(pattern, locale, map);
            }
        };
        Locale locale = I18nUtils.findLocale(objectModel, this.localeAttribute, parameters, this.defaultLocale, this.useLocale, this.useLocales, this.useBlankLocale, validator);
        if (locale == null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("No locale found for resource: " + pattern));
            }
            return null;
        }
        String localeStr = locale.toString();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Locale " + localeStr + " found for resource: " + pattern));
        }
        I18nUtils.storeLocale(objectModel, this.localeAttribute, localeStr, this.storeInRequest, this.storeInSession, this.storeInCookie, this.createSession);
        return map;
    }

    private boolean isValidResource(String pattern, Locale locale, Map map) {
        Locale testLocale;
        if (locale.getVariant().length() > 0 && this.isValidResource(pattern, locale, locale, map)) {
            return true;
        }
        if (locale.getCountry().length() > 0 && this.isValidResource(pattern, locale, testLocale = new Locale(locale.getLanguage(), locale.getCountry()), map)) {
            return true;
        }
        testLocale = new Locale(locale.getLanguage(), DEFAULT_DEFAULT_VARIANT);
        return this.isValidResource(pattern, locale, testLocale, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isValidResource(String pattern, Locale locale, Locale testLocale, Map map) {
        boolean result;
        String url;
        String testLocaleStr;
        block9: {
            int starPos;
            testLocaleStr = testLocale.toString();
            url = DEFAULT_DEFAULT_VARIANT.equals(testLocaleStr) ? ((starPos = pattern.indexOf("*")) < pattern.length() - 1 && starPos > 1 && pattern.charAt(starPos - 1) == pattern.charAt(starPos + 1) ? pattern.substring(0, starPos - 1) + pattern.substring(starPos + 1) : StringUtils.replace((String)pattern, (String)"*", (String)DEFAULT_DEFAULT_VARIANT)) : StringUtils.replace((String)pattern, (String)"*", (String)testLocaleStr);
            result = true;
            if (this.testResourceExists) {
                Source source = null;
                try {
                    try {
                        source = this.resolver.resolveURI(url);
                        result = source.exists();
                    }
                    catch (IOException e) {
                        result = false;
                        Object var11_10 = null;
                        if (source != null) {
                            this.resolver.release(source);
                        }
                        break block9;
                    }
                    Object var11_9 = null;
                    if (source == null) break block9;
                }
                catch (Throwable throwable) {
                    Object var11_11 = null;
                    if (source != null) {
                        this.resolver.release(source);
                    }
                    throw throwable;
                }
                this.resolver.release(source);
            }
        }
        if (result) {
            map.put("source", url);
            map.put("matched-locale", testLocaleStr);
            if (locale != null) {
                map.put(DEFAULT_LOCALE_ATTRIBUTE, locale.toString());
                map.put("language", locale.getLanguage());
                map.put("country", locale.getCountry());
                map.put("variant", locale.getVariant());
            }
        }
        return result;
    }
}

