/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.i18n;

import java.net.MalformedURLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.cocoon.CascadingIOException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.components.source.impl.validity.DelayedValidity;
import org.apache.cocoon.i18n.Bundle;
import org.apache.cocoon.i18n.I18nUtils;
import org.apache.cocoon.util.AbstractLogEnabled;
import org.apache.cocoon.xml.ParamSaxBuffer;
import org.apache.excalibur.source.SourceNotFoundException;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.ExpiresValidity;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class XMLResourceBundle
extends AbstractLogEnabled
implements Bundle {
    public static final String EL_CATALOGUE = "catalogue";
    public static final String EL_MESSAGE = "message";
    public static final String AT_KEY = "key";
    private String sourceURI;
    private SourceValidity validity;
    private Locale locale;
    protected Bundle parent;
    protected Map values;

    public XMLResourceBundle(String sourceURI, Locale locale, Bundle parent) {
        this.sourceURI = sourceURI;
        this.locale = locale;
        this.parent = parent;
        this.values = Collections.EMPTY_MAP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean reload(SourceResolver resolver, long interval) {
        newSource = null;
        try {
            v0 = valid = this.validity == null ? -1 : this.validity.isValid();
            if (valid != 1) {
                newSource = resolver.resolveURI(this.sourceURI);
                newValidity = newSource.getValidity();
                if (valid == -1 || this.validity.isValid(newValidity) != 1) {
                    newValues = new HashMap<K, V>();
                    SourceUtil.toSAX(newSource, new SAXContentHandler(newValues));
                    var8_16 = this;
                    synchronized (var8_16) {
                        this.validity = interval > 0L && newValidity != null ? new DelayedValidity(interval, newValidity) : newValidity;
                        this.values = newValues;
                    }
                }
            }
            var7_13 = true;
            if (newSource == null) return var7_13;
        }
        catch (MalformedURLException e) {
            this.getLogger().error((Object)("Bundle <" + this.sourceURI + "> not loaded: Invalid URI"), (Throwable)e);
            newValues = Collections.EMPTY_MAP;
            ** if (newSource == null) goto lbl-1000
lbl-1000:
            // 1 sources

            {
                resolver.release(newSource);
            }
lbl-1000:
            // 2 sources

            {
            }
            catch (ResourceNotFoundException e) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().info((Object)("Bundle <" + this.sourceURI + "> not loaded: Source URI not found"), (Throwable)e);
                } else if (this.getLogger().isInfoEnabled()) {
                    this.getLogger().info((Object)("Bundle <" + this.sourceURI + "> not loaded: Source URI not found"));
                }
                newValues = Collections.EMPTY_MAP;
                ** if (newSource == null) goto lbl-1000
lbl-1000:
                // 1 sources

                {
                    resolver.release(newSource);
                }
lbl-1000:
                // 2 sources

                {
                }
                catch (SourceNotFoundException e) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug((Object)("Bundle <" + this.sourceURI + "> not loaded: Source URI not found"));
                    }
                    newValues = Collections.EMPTY_MAP;
                    ** if (newSource == null) goto lbl-1000
lbl-1000:
                    // 1 sources

                    {
                        resolver.release(newSource);
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                    catch (CascadingIOException e) {
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug((Object)("Bundle <" + this.sourceURI + "> not loaded: Source URI not found"));
                        }
                        newValues = Collections.EMPTY_MAP;
                        ** if (newSource == null) goto lbl-1000
lbl-1000:
                        // 1 sources

                        {
                            resolver.release(newSource);
                        }
lbl-1000:
                        // 2 sources

                        {
                        }
                        catch (SAXException e) {
                            this.getLogger().error((Object)("Bundle <" + this.sourceURI + "> not loaded: Invalid XML"), (Throwable)e);
                            newValues = this.values;
                            ** if (newSource == null) goto lbl-1000
lbl-1000:
                            // 1 sources

                            {
                                resolver.release(newSource);
                            }
lbl-1000:
                            // 2 sources

                            {
                            }
                            catch (Exception e) {
                                try {
                                    this.getLogger().error((Object)("Bundle <" + this.sourceURI + "> not loaded: Exception"), (Throwable)e);
                                    newValues = this.values;
                                    ** if (newSource == null) goto lbl-1000
                                }
                                catch (Throwable var10_17) {
                                    if (newSource == null) throw var10_17;
                                    resolver.release(newSource);
                                    throw var10_17;
                                }
lbl-1000:
                                // 1 sources

                                {
                                    resolver.release(newSource);
                                }
lbl-1000:
                                // 2 sources

                                {
                                }
                            }
                        }
                    }
                }
            }
        }
        resolver.release(newSource);
        return var7_13;
        var6_11 = this;
        synchronized (var6_11) {
            this.validity = interval > 0L ? new ExpiresValidity(interval) : null;
            this.values = var5_15;
            return false;
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getSourceURI() {
        return this.sourceURI;
    }

    public SourceValidity getValidity() {
        return this.validity;
    }

    public Object getObject(String key) {
        if (key == null) {
            return null;
        }
        Object value = this.values.get(key);
        if (value != null) {
            return value;
        }
        if (this.parent != null) {
            return this.parent.getObject(key);
        }
        return null;
    }

    public String getString(String key) {
        if (key == null) {
            return null;
        }
        Object value = this.values.get(key);
        if (value != null) {
            return value.toString();
        }
        if (this.parent != null) {
            return this.parent.getString(key);
        }
        return null;
    }

    private static class SAXContentHandler
    implements ContentHandler {
        private Map values;
        private int state;
        private String namespace;
        private ParamSaxBuffer buffer;

        public SAXContentHandler(Map values) {
            this.values = values;
        }

        public void setDocumentLocator(Locator arg0) {
        }

        public void startDocument() throws SAXException {
        }

        public void endDocument() throws SAXException {
        }

        public void processingInstruction(String arg0, String arg1) throws SAXException {
        }

        public void skippedEntity(String arg0) throws SAXException {
        }

        public void startElement(String ns, String localName, String qName, Attributes atts) throws SAXException {
            switch (this.state) {
                case 0: {
                    if (!"".equals(ns) && !I18nUtils.matchesI18nNamespace(ns)) {
                        throw new SAXException("Root element <catalogue> must be non-namespaced or in i18n namespace.");
                    }
                    if (!XMLResourceBundle.EL_CATALOGUE.equals(localName)) {
                        throw new SAXException("Root element must be <catalogue>.");
                    }
                    this.namespace = ns;
                    ++this.state;
                    break;
                }
                case 1: {
                    if (!XMLResourceBundle.EL_MESSAGE.equals(localName)) {
                        throw new SAXException("<catalogue> must contain <message> elements only.");
                    }
                    if (!this.namespace.equals(ns)) {
                        throw new SAXException("<message> element must be in '" + this.namespace + "' namespace.");
                    }
                    String key = atts.getValue(XMLResourceBundle.AT_KEY);
                    if (key == null) {
                        throw new SAXException("<message> must have 'key' attribute.");
                    }
                    this.buffer = new ParamSaxBuffer();
                    this.values.put(key, this.buffer);
                    ++this.state;
                    break;
                }
                case 2: {
                    this.buffer.startElement(ns, localName, qName, atts);
                    break;
                }
                default: {
                    throw new SAXException("Internal error: Invalid state");
                }
            }
        }

        public void endElement(String ns, String localName, String qName) throws SAXException {
            switch (this.state) {
                case 0: {
                    break;
                }
                case 1: {
                    --this.state;
                    break;
                }
                case 2: {
                    if (this.namespace.equals(ns) && XMLResourceBundle.EL_MESSAGE.equals(localName)) {
                        this.buffer = null;
                        --this.state;
                        break;
                    }
                    this.buffer.endElement(ns, localName, qName);
                    break;
                }
                default: {
                    throw new SAXException("Internal error: Invalid state");
                }
            }
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            if (this.buffer != null) {
                this.buffer.startPrefixMapping(prefix, uri);
            }
        }

        public void endPrefixMapping(String prefix) throws SAXException {
            if (this.buffer != null) {
                this.buffer.endPrefixMapping(prefix);
            }
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            if (this.buffer != null) {
                this.buffer.ignorableWhitespace(ch, start, length);
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.buffer != null) {
                this.buffer.characters(ch, start, length);
            }
        }
    }
}

