/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.generation;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.servlet.multipart.Part;
import org.apache.cocoon.util.PostInputStream;
import org.apache.excalibur.xml.sax.SAXParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class StreamGenerator
extends ServiceableGenerator {
    public static final String FORM_NAME = "form-name";

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generate() throws IOException, SAXException, ProcessingException {
        SAXParser parser = null;
        int len = 0;
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        try {
            String charset;
            InputSource source;
            String contentType = request.getContentType();
            if (contentType == null) {
                contentType = this.parameters.getParameter("defaultContentType", null);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("no Content-Type header - using contentType parameter: " + contentType));
                }
                if (contentType == null) {
                    throw new IOException("Both Content-Type header and defaultContentType parameter are not set");
                }
            }
            if (contentType.startsWith("application/x-www-form-urlencoded") || contentType.startsWith("multipart/form-data")) {
                void var8_8;
                Reader xmlReader;
                String parameter = this.parameters.getParameter(FORM_NAME, null);
                if (parameter == null) {
                    throw new ProcessingException("StreamGenerator expects a sitemap parameter called 'form-name' for handling form data");
                }
                Object xmlObject = request.get(parameter);
                if (xmlObject instanceof String) {
                    xmlReader = new StringReader((String)xmlObject);
                } else {
                    if (!(xmlObject instanceof Part)) throw new ProcessingException("Unknown request object encountered named " + parameter + " : " + xmlObject);
                    xmlReader = new InputStreamReader(((Part)xmlObject).getInputStream());
                }
                source = new InputSource((Reader)var8_8);
            } else {
                HttpServletRequest httpRequest;
                if (!(contentType.startsWith("text/plain") || contentType.startsWith("text/xml") || contentType.startsWith("application/xhtml+xml"))) {
                    if (!contentType.startsWith("application/xml")) throw new IOException("Unexpected getContentType(): " + request.getContentType());
                }
                if ((httpRequest = (HttpServletRequest)this.objectModel.get("httprequest")) == null) {
                    throw new ProcessingException("This feature is only available in an http environment.");
                }
                len = request.getContentLength();
                if (len <= 0) {
                    throw new IOException("getContentLen() == 0");
                }
                PostInputStream anStream = new PostInputStream((InputStream)httpRequest.getInputStream(), len);
                source = new InputSource((InputStream)anStream);
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("Processing stream ContentType=" + contentType + " ContentLength=" + len));
            }
            if ((charset = this.getCharacterEncoding(request, contentType)) != null) {
                source.setEncoding(charset);
            }
            parser = (SAXParser)this.manager.lookup(SAXParser.ROLE);
            parser.parse(source, (ContentHandler)this.xmlConsumer);
        }
        catch (IOException e) {
            try {
                this.getLogger().error((Object)"StreamGenerator.generate()", (Throwable)e);
                throw new ResourceNotFoundException("StreamGenerator could not find resource", (Throwable)e);
                catch (SAXException e2) {
                    this.getLogger().error((Object)"StreamGenerator.generate()", (Throwable)e2);
                    throw e2;
                }
                catch (ServiceException e3) {
                    this.getLogger().error((Object)"Could not get parser", (Throwable)e3);
                    throw new ProcessingException("Exception in StreamGenerator.generate()", (Throwable)e3);
                }
            }
            catch (Throwable throwable) {
                this.manager.release(parser);
                throw throwable;
            }
        }
        this.manager.release((Object)parser);
    }

    public String getCharacterEncoding(Request req, String contentType) {
        String encoding;
        if (contentType == null) {
            return null;
        }
        int idx = contentType.indexOf("charset=");
        if (idx == -1) {
            return null;
        }
        try {
            encoding = req.getCharacterEncoding();
            if (encoding != null) {
                encoding = this.cleanup(encoding);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("Using charset from container: " + encoding));
                }
                return encoding;
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        encoding = contentType.substring(idx + "charset=".length());
        int idxEnd = encoding.indexOf(";");
        if (idxEnd != -1) {
            encoding = encoding.substring(0, idxEnd);
        }
        encoding = this.cleanup(encoding);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Using charset from header: " + encoding));
        }
        return encoding;
    }

    private String cleanup(String encoding) {
        if ((encoding = encoding.trim()).length() > 2 && encoding.startsWith("\"") && encoding.endsWith("\"")) {
            encoding = encoding.substring(1, encoding.length() - 1);
        }
        return encoding;
    }
}

