/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.CascadingIOException;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.Cache;
import org.apache.cocoon.caching.CachedResponse;
import org.apache.cocoon.caching.IdentifierCacheKey;
import org.apache.cocoon.components.sax.XMLByteStreamCompiler;
import org.apache.cocoon.components.sax.XMLByteStreamInterpreter;
import org.apache.cocoon.components.source.impl.CachedSourceResponse;
import org.apache.cocoon.components.source.impl.CachingSourceValidityStrategy;
import org.apache.cocoon.util.AbstractLogEnabled;
import org.apache.cocoon.xml.ContentHandlerWrapper;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.TimeStampValidity;
import org.apache.excalibur.xml.sax.XMLizable;
import org.apache.excalibur.xmlizer.XMLizer;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class CachingSource
extends AbstractLogEnabled
implements Serviceable,
Initializable,
XMLizable,
Source {
    public static final String CACHE_EXPIRES_PARAM = "cache-expires";
    public static final String CACHE_NAME_PARAM = "cache-name";
    public static final String CACHE_FAIL_PARAM = "cache-fail";
    private static final SourceMeta DUMMY = new SourceMeta();
    protected final String protocol;
    protected final String uri;
    protected final String sourceUri;
    protected Source source;
    protected ServiceManager manager;
    protected Cache cache;
    private CachedSourceResponse response;
    private CachedSourceResponse previousResponse;
    private boolean freshMeta;
    protected final IdentifierCacheKey cacheKey;
    protected final int expires;
    protected final boolean fail;
    protected final String cacheName;
    protected final boolean async;
    private CachingSourceValidityStrategy validityStrategy;

    public CachingSource(String protocol, String uri, String sourceUri, Source source, int expires, String cacheName, boolean async, CachingSourceValidityStrategy validityStrategy, boolean fail) {
        this.protocol = protocol;
        this.uri = uri;
        this.sourceUri = sourceUri;
        this.source = source;
        this.expires = expires;
        this.cacheName = cacheName;
        this.async = async;
        this.validityStrategy = validityStrategy;
        this.fail = fail;
        String key = "source:" + this.getSourceURI();
        if (cacheName != null) {
            key = key + ":" + cacheName;
        }
        this.cacheKey = new IdentifierCacheKey(key, false);
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
    }

    public void initialize() throws Exception {
        boolean checkValidity = true;
        if (this.async && this.expires > 0 || this.expires == -1) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)"Using cached response if available.");
            }
            checkValidity = false;
        }
        this.response = (CachedSourceResponse)this.cache.get((Serializable)this.cacheKey);
        if (!this.fail) {
            this.previousResponse = this.response;
        }
        if (this.response == null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)"No cached response found.");
            }
            checkValidity = false;
        } else if (this.expires == 0) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)"Not using cached response.");
            }
            this.response = null;
            checkValidity = false;
        }
        if (checkValidity && !this.checkValidity()) {
            this.clearResponse();
        }
    }

    public void dispose() {
        this.response = null;
        this.previousResponse = null;
        this.source = null;
        this.manager = null;
        this.cache = null;
    }

    private CachedSourceResponse getResponse() {
        CachedSourceResponse response = this.response;
        if (response == null) {
            response = new CachedSourceResponse(this.getCacheValidities());
        }
        return response;
    }

    private void setResponse(CachedSourceResponse response) throws IOException {
        this.response = response;
        if (this.expires != 0) {
            try {
                this.cache.store((Serializable)this.cacheKey, (CachedResponse)this.response);
            }
            catch (ProcessingException e) {
                throw new CascadingIOException("Failure storing response.", (Throwable)e);
            }
        }
    }

    private void clearResponse() {
        this.response = null;
        if (!this.fail) {
            this.cache.remove((Serializable)this.cacheKey);
        }
    }

    protected SourceMeta getResponseMeta() throws IOException {
        CachedSourceResponse response = this.getResponse();
        if (response.getExtra() == null) {
            response.setExtra(this.readMeta(this.source));
            this.freshMeta = true;
            this.setResponse(response);
        }
        return (SourceMeta)response.getExtra();
    }

    protected byte[] getBinaryResponse() throws IOException {
        CachedSourceResponse response = this.getResponse();
        if (response.getBinaryResponse() == null) {
            if (!this.freshMeta) {
                response.setExtra(this.readMeta(this.source));
                this.freshMeta = true;
            }
            if (((SourceMeta)response.getExtra()).exists()) {
                response.setBinaryResponse(this.readBinaryResponse(this.source));
            }
            this.setResponse(response);
        }
        return response.getBinaryResponse();
    }

    protected byte[] getXMLResponse() throws SAXException, IOException {
        CachedSourceResponse response = this.getResponse();
        try {
            if (response.getXMLResponse() == null) {
                if (!this.freshMeta) {
                    response.setExtra(this.readMeta(this.source));
                    this.freshMeta = true;
                }
                if (((SourceMeta)response.getExtra()).exists()) {
                    if (response.getBinaryResponse() == null) {
                        response.setBinaryResponse(this.readBinaryResponse(this.source));
                    }
                    response.setXMLResponse(this.readXMLResponse(this.source, response.getBinaryResponse(), this.manager));
                }
                this.setResponse(response);
            }
        }
        catch (Exception e) {
            if (!this.fail && this.previousResponse != null) {
                response = this.cloneResponse(this.previousResponse);
                this.setResponse(this.cloneResponse(response));
            }
            if (e instanceof SAXException) {
                throw (SAXException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new CascadingIOException(e);
        }
        return response.getXMLResponse();
    }

    private SourceMeta getMeta() {
        try {
            return this.getResponseMeta();
        }
        catch (IOException e) {
            return DUMMY;
        }
    }

    private CachedSourceResponse cloneResponse(CachedSourceResponse orig) {
        CachedSourceResponse c = new CachedSourceResponse(this.getCacheValidities());
        c.setBinaryResponse(orig.getBinaryResponse());
        c.setContentType(orig.getContentType());
        c.setExtra(orig.getExtra());
        c.setXMLResponse(orig.getXMLResponse());
        return c;
    }

    public String getScheme() {
        return this.protocol;
    }

    public long getContentLength() {
        return this.getMeta().getContentLength();
    }

    public long getLastModified() {
        return this.getMeta().getLastModified();
    }

    public String getMimeType() {
        return this.getMeta().getMimeType();
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.getBinaryResponse());
    }

    public String getURI() {
        return this.uri;
    }

    public boolean exists() {
        return this.getMeta().exists();
    }

    public SourceValidity getValidity() {
        long lastModified = this.getLastModified();
        if (lastModified > 0L) {
            return new TimeStampValidity(lastModified);
        }
        return null;
    }

    public void refresh() {
        if (this.response != null && this.checkValidity()) {
            return;
        }
        this.source.refresh();
        CachedSourceResponse response = this.getResponse();
        try {
            SourceMeta meta = this.readMeta(this.source);
            response.setExtra(meta);
            if (meta.exists()) {
                if (response.getBinaryResponse() != null) {
                    response.setBinaryResponse(this.readBinaryResponse(this.source));
                }
                if (response.getXMLResponse() != null) {
                    response.setXMLResponse(this.readXMLResponse(this.source, response.getBinaryResponse(), this.manager));
                }
            } else {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("Source " + this.uri + " does not exist."));
                }
                response.setBinaryResponse(null);
                response.setXMLResponse(null);
            }
            this.setResponse(response);
        }
        catch (Exception e) {
            this.getLogger().warn((Object)("Error refreshing source " + this.uri + ". Cached response (if any) may be stale."), (Throwable)e);
        }
    }

    public void toSAX(ContentHandler contentHandler) throws SAXException {
        try {
            XMLByteStreamInterpreter deserializer = new XMLByteStreamInterpreter();
            if (contentHandler instanceof XMLConsumer) {
                deserializer.setConsumer((XMLConsumer)contentHandler);
            } else {
                deserializer.setConsumer((XMLConsumer)new ContentHandlerWrapper(contentHandler));
            }
            deserializer.deserialize((Object)this.getXMLResponse());
        }
        catch (CascadingIOException e) {
            throw new SAXException(e.getMessage(), (Exception)e.getCause());
        }
        catch (IOException e) {
            throw new SAXException("Failure reading SAX response.", e);
        }
    }

    protected String getSourceURI() {
        return this.sourceUri;
    }

    protected String getCacheKey() {
        return this.cacheKey.getKey();
    }

    protected long getExpiration() {
        return this.expires * 1000;
    }

    protected byte[] readXMLResponse(Source source, byte[] binary, ServiceManager manager) throws SAXException, IOException {
        byte[] byArray;
        block8: {
            XMLizer xmlizer = null;
            try {
                XMLByteStreamCompiler serializer = new XMLByteStreamCompiler();
                if (source instanceof XMLizable) {
                    ((XMLizable)source).toSAX((ContentHandler)serializer);
                } else {
                    String mimeType = source.getMimeType();
                    if (mimeType != null) {
                        xmlizer = (XMLizer)manager.lookup(XMLizer.ROLE);
                        xmlizer.toSAX((InputStream)new ByteArrayInputStream(binary), mimeType, source.getURI(), (ContentHandler)serializer);
                    }
                }
                byArray = (byte[])serializer.getSAXFragment();
                if (xmlizer == null) break block8;
            }
            catch (ServiceException e) {
                try {
                    throw new CascadingIOException("Missing service dependency.", (Throwable)e);
                }
                catch (Throwable throwable) {
                    if (xmlizer != null) {
                        manager.release(xmlizer);
                    }
                    throw throwable;
                }
            }
            manager.release((Object)xmlizer);
        }
        return byArray;
    }

    protected byte[] readBinaryResponse(Source source) throws IOException {
        int length;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[2048];
        InputStream inputStream = source.getInputStream();
        while ((length = inputStream.read(buffer)) > -1) {
            baos.write(buffer, 0, length);
        }
        baos.flush();
        inputStream.close();
        return baos.toByteArray();
    }

    protected SourceMeta readMeta(Source source) throws SourceException {
        return new SourceMeta(source);
    }

    private boolean checkValidity() {
        if (this.response == null) {
            return false;
        }
        return this.validityStrategy.checkValidity(this.response, this.source, this.getExpiration());
    }

    protected SourceValidity[] getCacheValidities() {
        return this.validityStrategy.getCacheValidities(this, this.source);
    }

    public void setValidityStrategy(CachingSourceValidityStrategy s) {
        this.validityStrategy = s;
    }

    protected static class SourceMeta
    implements Serializable {
        private boolean exists;
        private long contentLength;
        private String mimeType;
        private long lastModified;

        public SourceMeta() {
        }

        public SourceMeta(Source source) {
            this.setExists(source.exists());
            if (this.exists()) {
                this.setContentLength(source.getContentLength());
                long lastModified = source.getLastModified();
                if (lastModified > 0L) {
                    this.setLastModified(lastModified);
                } else {
                    this.setLastModified(System.currentTimeMillis());
                }
                this.setMimeType(source.getMimeType());
            } else {
                this.contentLength = -1L;
            }
        }

        protected boolean exists() {
            return this.exists;
        }

        protected void setExists(boolean exists) {
            this.exists = exists;
        }

        protected long getContentLength() {
            return this.contentLength;
        }

        protected void setContentLength(long contentLength) {
            this.contentLength = contentLength;
        }

        protected long getLastModified() {
            return this.lastModified;
        }

        protected void setLastModified(long lastModified) {
            this.lastModified = lastModified;
        }

        protected String getMimeType() {
            return this.mimeType;
        }

        protected void setMimeType(String mimeType) {
            this.mimeType = mimeType;
        }
    }
}

