/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.Processor;
import org.apache.cocoon.components.source.SourceFactoryNotFoundException;
import org.apache.cocoon.environment.internal.EnvironmentHelper;
import org.apache.cocoon.util.AbstractLogEnabled;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceFactory;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceUtil;
import org.apache.excalibur.source.URIAbsolutizer;

public class CocoonSourceResolver
extends AbstractLogEnabled
implements org.apache.cocoon.environment.SourceResolver,
Contextualizable,
Serviceable,
Disposable,
ThreadSafe {
    protected SourceResolver customResolver;
    protected ServiceManager manager;
    protected URL baseURL;

    public void contextualize(Context context) throws ContextException {
        try {
            this.baseURL = context.get((Object)"context-root") instanceof URL ? (URL)context.get((Object)"context-root") : ((File)context.get((Object)"context-root")).toURL();
        }
        catch (ContextException ce) {
            try {
                this.baseURL = new File(System.getProperty("user.dir")).toURL();
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("SourceResolver: Using base URL: " + this.baseURL));
                }
            }
            catch (MalformedURLException mue) {
                throw new ContextException("Malformed URL for user.dir, and no container.rootDir exists", (Throwable)mue);
            }
        }
        catch (MalformedURLException mue) {
            throw new ContextException("Malformed URL for container.rootDir", (Throwable)mue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Source resolveURI(String location, String baseURI, Map parameters) throws IOException {
        Processor processor;
        if (baseURI == null && (processor = EnvironmentHelper.getCurrentProcessor()) != null) {
            baseURI = processor.getContext();
        }
        if (this.customResolver != null) {
            return this.customResolver.resolveURI(location, baseURI, parameters);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Resolving '" + location + "' with base '" + baseURI + "' in context '" + this.baseURL + "'"));
        }
        if (location == null) {
            throw new MalformedURLException("Invalid System ID");
        }
        if (baseURI != null && SourceUtil.indexOfSchemeColon((String)baseURI) == -1) {
            throw new MalformedURLException("BaseURI is not valid, it must contain a protocol: " + baseURI);
        }
        if (baseURI == null) {
            baseURI = this.baseURL.toExternalForm();
        }
        String systemID = location;
        if (location.length() > 1 && location.charAt(1) == ':') {
            systemID = "file:/" + location;
        } else if (location.length() > 2 && location.charAt(0) == '/' && location.charAt(2) == ':') {
            systemID = "file:" + location;
        }
        int protocolPos = SourceUtil.indexOfSchemeColon((String)systemID);
        String protocol = protocolPos != -1 ? systemID.substring(0, protocolPos) : ((protocolPos = SourceUtil.indexOfSchemeColon((String)baseURI)) != -1 ? baseURI.substring(0, protocolPos) : "*");
        ServiceManager m = this.getComponentLocator();
        Source source = null;
        SourceFactory factory = null;
        try {
            factory = this.getSourceFactory(m, protocol);
            systemID = this.absolutize(factory, baseURI, systemID);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("Resolved to systemID : " + systemID));
            }
            source = factory.getSource(systemID, parameters);
        }
        catch (ProcessingException ce) {
        }
        finally {
            m.release((Object)factory);
        }
        if (null == source) {
            try {
                factory = this.getSourceFactory(m, "*");
                systemID = this.absolutize(factory, baseURI, systemID);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("Resolved to systemID : " + systemID));
                }
                source = factory.getSource(systemID, parameters);
            }
            catch (ProcessingException se) {
                throw new SourceException("Unable to select source factory for " + systemID, (Throwable)se);
            }
            finally {
                m.release((Object)factory);
            }
        }
        return source;
    }

    public Source resolveURI(String location) throws IOException {
        return this.resolveURI(location, null, null);
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
        if (this.manager.hasService(SourceResolver.ROLE + "/Cocoon")) {
            this.customResolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE + "/Cocoon");
        }
    }

    public void dispose() {
        if (this.manager != null) {
            this.manager.release((Object)this.customResolver);
            this.customResolver = null;
            this.manager = null;
        }
    }

    protected ServiceManager getComponentLocator() {
        ServiceManager l = EnvironmentHelper.getSitemapServiceManager();
        if (l == null) {
            l = this.manager;
        }
        return l;
    }

    protected SourceFactory getSourceFactory(ServiceManager m, String scheme) throws ProcessingException {
        try {
            return (SourceFactory)m.lookup(SourceFactory.ROLE + '/' + scheme);
        }
        catch (ServiceException se) {
            throw new ProcessingException("Unable to lookup source factory for scheme: " + scheme, (Throwable)se);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(Source source) {
        if (source == null) {
            return;
        }
        if (this.customResolver != null) {
            this.customResolver.release(source);
        } else {
            ServiceManager m = this.getComponentLocator();
            String scheme = source.getScheme();
            SourceFactory factory = null;
            try {
                factory = this.getSourceFactory(m, scheme);
                factory.release(source);
            }
            catch (ProcessingException se) {
                try {
                    factory = this.getSourceFactory(m, "*");
                    factory.release(source);
                }
                catch (ProcessingException sse) {
                    throw new SourceFactoryNotFoundException("Unable to select source factory for " + source.getURI(), se);
                }
            }
            finally {
                m.release((Object)factory);
            }
        }
    }

    protected String absolutize(SourceFactory factory, String baseURI, String systemID) {
        systemID = factory instanceof URIAbsolutizer ? ((URIAbsolutizer)factory).absolutize(baseURI, systemID) : SourceUtil.absolutize((String)baseURI, (String)systemID);
        return systemID;
    }
}

