/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store;

import java.util.LinkedHashMap;
import java.util.Map;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.store.DiskStore;
import net.sf.ehcache.store.MemoryStore;
import org.apache.commons.collections.LRUMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class LruMemoryStore
extends MemoryStore {
    private static final Log LOG = LogFactory.getLog((String)LruMemoryStore.class.getName());

    public LruMemoryStore(Ehcache cache, DiskStore diskStore) {
        super(cache, diskStore);
        try {
            this.map = this.loadMapInstance();
        }
        catch (CacheException e) {
            LOG.error((Object)(cache.getName() + "Cache: Cannot start LruMemoryStore. Initial cause was " + e.getMessage()), (Throwable)e);
        }
    }

    private Map loadMapInstance() throws CacheException {
        block7: {
            if (System.getProperty("net.sf.ehcache.useLRUMap") == null) {
                try {
                    Class.forName("java.util.LinkedHashMap");
                    SpoolingLinkedHashMap candidateMap = new SpoolingLinkedHashMap();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(this.cache.getName() + " Cache: Using SpoolingLinkedHashMap implementation"));
                    }
                    return candidateMap;
                }
                catch (Exception e) {
                    if (!LOG.isDebugEnabled()) break block7;
                    LOG.debug((Object)(this.cache.getName() + " Cache: Cannot find java.util.LinkedHashMap"));
                }
            }
        }
        try {
            Class.forName("org.apache.commons.collections.LRUMap");
            SpoolingLRUMap candidateMap = new SpoolingLRUMap();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.cache.getName() + " Cache: Using SpoolingLRUMap implementation"));
            }
            return candidateMap;
        }
        catch (Exception e) {
            throw new CacheException(this.cache.getName() + "Cache: Cannot find org.apache.commons.collections.LRUMap.");
        }
    }

    public final class SpoolingLinkedHashMap
    extends LinkedHashMap {
        private static final int INITIAL_CAPACITY = 100;
        private static final float GROWTH_FACTOR = 0.75f;

        public SpoolingLinkedHashMap() {
            super(100, 0.75f, true);
        }

        protected final boolean removeEldestEntry(Map.Entry eldest) {
            Element element = (Element)eldest.getValue();
            return this.removeLeastRecentlyUsedElement(element);
        }

        private boolean removeLeastRecentlyUsedElement(Element element) throws CacheException {
            if (element.isExpired()) {
                LruMemoryStore.this.notifyExpiry(element);
                return true;
            }
            if (LruMemoryStore.this.isFull()) {
                LruMemoryStore.this.evict(element);
                return true;
            }
            return false;
        }
    }

    public final class SpoolingLRUMap
    extends LRUMap {
        public SpoolingLRUMap() {
            this.setMaximumSize(LruMemoryStore.this.cache.getMaxElementsInMemory());
        }

        protected final void processRemovedLRU(Object key, Object value) {
            Element element = (Element)value;
            if (element == null) {
                return;
            }
            if (element.isExpired()) {
                LruMemoryStore.this.notifyExpiry(element);
            } else {
                LruMemoryStore.this.evict(element);
            }
        }
    }
}

