/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution;

import java.util.Properties;
import java.util.StringTokenizer;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.distribution.CacheManagerPeerProvider;
import net.sf.ehcache.distribution.JNDIManualRMICacheManagerPeerProvider;
import net.sf.ehcache.distribution.RMICacheManagerPeerProviderFactory;
import net.sf.ehcache.util.PropertyUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JNDIManualRMICacheManagerPeerProviderFactory
extends RMICacheManagerPeerProviderFactory {
    private static final Log LOG = LogFactory.getLog((String)JNDIManualRMICacheManagerPeerProviderFactory.class.getName());
    private static final String JNDI_URLS = "jndiUrls";
    private static final String STASH_CONTEXTS = "stashContexts";
    private static final String STASH_REMOTE_CACHE_PEERS = "stashRemoteCachePeers";

    protected CacheManagerPeerProvider createManuallyConfiguredCachePeerProvider(Properties properties) {
        String urls = PropertyUtil.extractAndLogProperty(JNDI_URLS, properties);
        if (urls == null || urls.length() == 0) {
            throw new CacheException("jndiUrls must be specified when peerDiscovery is manual");
        }
        boolean stashContexts = this.isStashContexts(properties);
        boolean stashRemoteCachePeers = this.isStashRemoteCachePeers(properties);
        JNDIManualRMICacheManagerPeerProvider jndiPeerProvider = new JNDIManualRMICacheManagerPeerProvider(stashContexts, stashRemoteCachePeers);
        urls = urls.trim();
        StringTokenizer stringTokenizer = new StringTokenizer(urls, "|");
        while (stringTokenizer.hasMoreTokens()) {
            String jndiUrl = stringTokenizer.nextToken();
            jndiUrl = jndiUrl.trim();
            jndiPeerProvider.registerPeer(jndiUrl);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Registering peer " + jndiUrl));
        }
        return jndiPeerProvider;
    }

    private boolean isStashRemoteCachePeers(Properties properties) {
        String stashRemoteCachePeersString = PropertyUtil.extractAndLogProperty(STASH_REMOTE_CACHE_PEERS, properties);
        boolean stashRemoteCachePeers = stashRemoteCachePeersString == null || stashRemoteCachePeersString.length() == 0 ? true : Boolean.valueOf(stashRemoteCachePeersString);
        return stashRemoteCachePeers;
    }

    private boolean isStashContexts(Properties properties) {
        String stashContextsString = PropertyUtil.extractAndLogProperty(STASH_CONTEXTS, properties);
        boolean stashContexts = stashContextsString == null || stashContextsString.length() == 0 ? true : Boolean.valueOf(stashContextsString);
        return stashContexts;
    }
}

