/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.template.script;

import org.apache.cocoon.el.objectmodel.ObjectModel;
import org.apache.cocoon.template.environment.ExecutionContext;
import org.apache.cocoon.template.environment.LocatorFacade;
import org.apache.cocoon.template.instruction.Call;
import org.apache.cocoon.template.instruction.Define;
import org.apache.cocoon.template.instruction.Instruction;
import org.apache.cocoon.template.instruction.MacroContext;
import org.apache.cocoon.template.script.event.Event;
import org.apache.cocoon.template.script.event.StartElement;
import org.apache.cocoon.xml.IncludeXMLConsumer;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.cocoon.xml.dom.DOMBuilder;
import org.apache.cocoon.xml.dom.DOMStreamer;
import org.apache.cocoon.xml.util.NamespacesTable;
import org.apache.commons.lang.ArrayUtils;
import org.apache.excalibur.xml.sax.XMLizable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Invoker {
    private static final Attributes EMPTY_ATTRS = new AttributesImpl();

    public static void execute(XMLConsumer consumer, ObjectModel objectModel, ExecutionContext executionContext, MacroContext macroContext, NamespacesTable namespaces, Event startEvent, Event endEvent) throws SAXException {
        Event ev = startEvent;
        LocatorFacade loc = new LocatorFacade(ev.getLocation());
        consumer.setDocumentLocator((Locator)loc);
        while (ev != endEvent) {
            loc.setDocumentLocator(ev.getLocation());
            if (ev instanceof StartElement) {
                StartElement startElement = (StartElement)ev;
                Define def = (Define)executionContext.getDefinitions().get(startElement.getQname());
                if (def == null) {
                    ev = ev.execute(consumer, objectModel, executionContext, macroContext, namespaces, startEvent, endEvent);
                    continue;
                }
                Call call = new Call(def, startElement);
                ev = call.execute(consumer, objectModel, executionContext, macroContext, namespaces, startEvent, endEvent);
                continue;
            }
            ev = ev.execute(consumer, objectModel, executionContext, macroContext, namespaces, startEvent, endEvent);
        }
    }

    public static void executeNode(XMLConsumer consumer, Object val) throws SAXException {
        Invoker.executeNode(consumer, val, false);
    }

    public static void executeNode(XMLConsumer consumer, Object val, boolean stripRoot) throws SAXException {
        if (val instanceof Node) {
            Invoker.executeDOM(consumer, (Node)val, stripRoot);
        } else if (val instanceof NodeList) {
            NodeList nodeList = (NodeList)val;
            int len = nodeList.getLength();
            for (int i = 0; i < len; ++i) {
                Node n = nodeList.item(i);
                Invoker.executeDOM(consumer, n);
            }
        } else if (val instanceof Node[]) {
            Node[] nodeList = (Node[])val;
            int len = nodeList.length;
            for (int i = 0; i < len; ++i) {
                Node n = nodeList[i];
                Invoker.executeDOM(consumer, n);
            }
        } else if (val instanceof XMLizable) {
            IncludeXMLConsumer includer = new IncludeXMLConsumer(consumer);
            includer.setIgnoreRootElement(stripRoot);
            ((XMLizable)val).toSAX((ContentHandler)includer);
        } else {
            char[] ch = val == null ? ArrayUtils.EMPTY_CHAR_ARRAY : val.toString().toCharArray();
            consumer.characters(ch, 0, ch.length);
        }
    }

    public static void executeDOM(XMLConsumer consumer, Node node) throws SAXException {
        Invoker.executeDOM(consumer, node, false);
    }

    public static void executeDOM(XMLConsumer consumer, Node node, boolean stripRoot) throws SAXException {
        IncludeXMLConsumer includer = new IncludeXMLConsumer(consumer);
        includer.setIgnoreRootElement(stripRoot);
        DOMStreamer streamer = new DOMStreamer((XMLConsumer)includer);
        streamer.stream(node);
    }

    public static NodeList toDOMNodeList(String elementName, Instruction si, ObjectModel objectModel, ExecutionContext executionContext, MacroContext macroContext, NamespacesTable namespaces) throws SAXException {
        DOMBuilder builder = new DOMBuilder();
        builder.startDocument();
        builder.startElement("http://apache.org/cocoon/templates/jx/1.0", elementName, elementName, EMPTY_ATTRS);
        Invoker.execute((XMLConsumer)builder, objectModel, executionContext, macroContext, namespaces, si.getNext(), si.getEndInstruction());
        builder.endElement("http://apache.org/cocoon/templates/jx/1.0", elementName, elementName);
        builder.endDocument();
        Element node = builder.getDocument().getDocumentElement();
        return node.getChildNodes();
    }
}

