/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.el.impl.jexl;

import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Iterator;
import org.apache.commons.jexl.util.introspection.Info;
import org.apache.commons.jexl.util.introspection.UberspectImpl;
import org.apache.commons.jexl.util.introspection.VelMethod;
import org.apache.commons.jexl.util.introspection.VelPropertyGet;
import org.apache.commons.jexl.util.introspection.VelPropertySet;
import org.apache.commons.lang.StringUtils;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeJavaClass;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;

public class JSIntrospector
extends UberspectImpl {
    static /* synthetic */ Class class$java$lang$Object;

    public Iterator getIterator(Object obj, Info i) throws Exception {
        if (!(obj instanceof Scriptable)) {
            if (obj instanceof Enumeration) {
                final Enumeration e = (Enumeration)obj;
                return new Iterator(){

                    public boolean hasNext() {
                        return e.hasMoreElements();
                    }

                    public Object next() {
                        return e.nextElement();
                    }

                    public void remove() {
                    }
                };
            }
            if (obj instanceof Iterator) {
                return (Iterator)obj;
            }
            return super.getIterator(obj, i);
        }
        if (obj instanceof NativeArray) {
            return new NativeArrayIterator((NativeArray)obj);
        }
        return new ScriptableIterator((Scriptable)obj);
    }

    public VelMethod getMethod(Object obj, String methodName, Object[] args, Info i) throws Exception {
        return !(obj instanceof Scriptable) ? super.getMethod(obj, methodName, args, i) : new JSMethod((Scriptable)obj, methodName);
    }

    public VelPropertyGet getPropertyGet(Object obj, String identifier, Info i) throws Exception {
        return !(obj instanceof Scriptable) ? super.getPropertyGet(obj, identifier, i) : new JSPropertyGet((Scriptable)obj, identifier);
    }

    public VelPropertySet getPropertySet(Object obj, String identifier, Object arg, Info i) throws Exception {
        return !(obj instanceof Scriptable) ? super.getPropertySet(obj, identifier, arg, i) : new JSPropertySet((Scriptable)obj, identifier);
    }

    private static Object unwrap(Object result) {
        if (result == Undefined.instance || result == Scriptable.NOT_FOUND) {
            return null;
        }
        if (!(result instanceof NativeJavaClass)) {
            Object value;
            while (result instanceof Wrapper && (value = ((Wrapper)result).unwrap()) != result) {
                result = value;
            }
        }
        return result;
    }

    static class ScriptableIterator
    implements Iterator {
        Scriptable scope;
        Object[] ids;
        int index;

        public ScriptableIterator(Scriptable scope) {
            this.scope = scope;
            this.ids = scope.getIds();
            this.index = 0;
        }

        public boolean hasNext() {
            return this.index < this.ids.length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object next() {
            Context.enter();
            try {
                Object result = ScriptableObject.getProperty((Scriptable)this.scope, (String)this.ids[this.index++].toString());
                Object object = JSIntrospector.unwrap(result);
                return object;
            }
            finally {
                Context.exit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove() {
            Context.enter();
            try {
                this.scope.delete(this.ids[this.index].toString());
            }
            finally {
                Context.exit();
            }
        }
    }

    public static class NativeArrayIterator
    implements Iterator {
        NativeArray arr;
        int index;

        public NativeArrayIterator(NativeArray arr) {
            this.arr = arr;
            this.index = 0;
        }

        public boolean hasNext() {
            return this.index < (int)this.arr.getLength();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object next() {
            Context.enter();
            try {
                Object result = this.arr.get(this.index++, (Scriptable)this.arr);
                Object object = JSIntrospector.unwrap(result);
                return object;
            }
            finally {
                Context.exit();
            }
        }

        public void remove() {
            this.arr.delete(this.index);
        }
    }

    static class JSPropertySet
    implements VelPropertySet {
        Scriptable scope;
        String name;

        public JSPropertySet(Scriptable scope, String name) {
            this.scope = scope;
            this.name = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(Object thisArg, Object rhs) throws Exception {
            Context.enter();
            try {
                Object arg = rhs;
                Scriptable thisObj = !(thisArg instanceof Scriptable) ? Context.toObject((Object)thisArg, (Scriptable)this.scope) : (Scriptable)thisArg;
                if (!(arg == null || arg instanceof Number || arg instanceof Boolean || arg instanceof String || arg instanceof Scriptable)) {
                    arg = Context.toObject((Object)arg, (Scriptable)this.scope);
                }
                ScriptableObject.putProperty((Scriptable)thisObj, (String)this.name, (Object)arg);
                Object object = rhs;
                return object;
            }
            finally {
                Context.exit();
            }
        }

        public boolean isCacheable() {
            return false;
        }

        public String getMethodName() {
            return this.name;
        }
    }

    static class JSPropertyGet
    implements VelPropertyGet {
        Scriptable scope;
        String name;

        public JSPropertyGet(Scriptable scope, String name) {
            this.scope = scope;
            this.name = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(Object thisArg) throws Exception {
            Context cx = Context.enter();
            try {
                Scriptable thisObj = !(thisArg instanceof Scriptable) ? Context.toObject((Object)thisArg, (Scriptable)this.scope) : (Scriptable)thisArg;
                Object result = ScriptableObject.getProperty((Scriptable)thisObj, (String)this.name);
                if (result == Scriptable.NOT_FOUND && (result = ScriptableObject.getProperty((Scriptable)thisObj, (String)("get" + StringUtils.capitalize((String)this.name)))) != Scriptable.NOT_FOUND && result instanceof Function) {
                    try {
                        result = ((Function)result).call(cx, ScriptableObject.getTopLevelScope((Scriptable)thisObj), thisObj, new Object[0]);
                    }
                    catch (JavaScriptException exc) {
                        exc.printStackTrace();
                        result = null;
                    }
                }
                Object object = JSIntrospector.unwrap(result);
                return object;
            }
            finally {
                Context.exit();
            }
        }

        public boolean isCacheable() {
            return false;
        }

        public String getMethodName() {
            return this.name;
        }
    }

    static class JSMethod
    implements VelMethod {
        Scriptable scope;
        String name;

        public JSMethod(Scriptable scope, String name) {
            this.scope = scope;
            this.name = name;
        }

        public Object invoke(Object thisArg, Object[] args) throws Exception {
            Context cx = Context.enter();
            try {
                Scriptable thisObj = !(thisArg instanceof Scriptable) ? Context.toObject((Object)thisArg, (Scriptable)this.scope) : (Scriptable)thisArg;
                Object result = ScriptableObject.getProperty((Scriptable)thisObj, (String)this.name);
                Object[] newArgs = null;
                if (args != null) {
                    newArgs = new Object[args.length];
                    int len = args.length;
                    for (int i = 0; i < len; ++i) {
                        newArgs[i] = args[i];
                        if (args[i] == null || args[i] instanceof Number || args[i] instanceof Boolean || args[i] instanceof String || args[i] instanceof Scriptable) continue;
                        newArgs[i] = Context.toObject((Object)args[i], (Scriptable)this.scope);
                    }
                }
                result = ScriptRuntime.call((Context)cx, (Object)result, (Object)thisObj, (Object[])newArgs, (Scriptable)this.scope);
                Object object = JSIntrospector.unwrap(result);
                return object;
            }
            catch (JavaScriptException e) {
                throw new InvocationTargetException(e);
            }
            finally {
                Context.exit();
            }
        }

        public boolean isCacheable() {
            return false;
        }

        public String getMethodName() {
            return this.name;
        }

        public Class getReturnType() {
            return class$java$lang$Object == null ? (class$java$lang$Object = JSIntrospector.class$("java.lang.Object")) : class$java$lang$Object;
        }
    }
}

