/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.servletservice;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cocoon.servletservice.DynamicProxyRequestHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class DispatcherServlet
extends HttpServlet {
    private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private long applicationContextStartDate;
    private Map blockServletCollector;

    public void init() throws ServletException {
        this.log("Block dispatcher was initialized successfully.");
    }

    protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        Map mountableServlets = this.getBlockServletMap();
        String path = req.getPathInfo();
        if (path == null) {
            path = "";
        }
        int index = path.length();
        Servlet servlet = null;
        while (servlet == null && index != -1) {
            path = path.substring(0, index);
            servlet = (Servlet)mountableServlets.get(path);
            index = path.lastIndexOf(47);
        }
        Servlet servlet2 = servlet = servlet == null ? (Servlet)mountableServlets.get("/") : servlet;
        if (servlet == null) {
            String message = "No block for " + req.getPathInfo();
            res.sendError(404, message);
            this.logger.info((Object)message);
            return;
        }
        HttpServletRequest request = (HttpServletRequest)Proxy.newProxyInstance(req.getClass().getClassLoader(), this.getInterfaces(req.getClass()), (InvocationHandler)new DynamicProxyRequestHandler(req, path));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("DispatcherServlet: service servlet=" + servlet + " mountPath=" + path + " servletPath=" + request.getServletPath() + " pathInfo=" + request.getPathInfo()));
        }
        servlet.service((ServletRequest)request, (ServletResponse)res);
    }

    private void getInterfaces(Set interfaces, Class clazz) {
        Class<?>[] clazzInterfaces = clazz.getInterfaces();
        for (int i = 0; i < clazzInterfaces.length; ++i) {
            this.getInterfaces(interfaces, clazzInterfaces[i]);
        }
        Class superclazz = clazz.getSuperclass();
        if (superclazz != null) {
            this.getInterfaces(interfaces, superclazz);
        }
        interfaces.addAll(Arrays.asList(clazzInterfaces));
    }

    private Class[] getInterfaces(Class clazz) {
        LinkedHashSet interfaces = new LinkedHashSet();
        this.getInterfaces(interfaces, clazz);
        return interfaces.toArray(new Class[interfaces.size()]);
    }

    public Map getBlockServletMap() {
        WebApplicationContext applicationContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        if (this.blockServletCollector == null || applicationContext.getStartupDate() != this.applicationContextStartDate) {
            this.applicationContextStartDate = applicationContext.getStartupDate();
            this.blockServletCollector = (Map)applicationContext.getBean("org.apache.cocoon.servletservice.spring.BlockServletMap");
        }
        return this.blockServletCollector;
    }
}

