/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.store.impl;

import com.coyotegulch.jisp.BTreeIndex;
import com.coyotegulch.jisp.IndexedObjectDatabase;
import com.coyotegulch.jisp.KeyNotFound;
import com.coyotegulch.jisp.ObjectIndex;
import java.io.File;
import java.io.IOException;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.excalibur.store.impl.AbstractJispFilesystemStore;

public class JispFilesystemStore
extends AbstractJispFilesystemStore
implements Parameterizable,
Disposable {
    public void parameterize(Parameters params) throws ParameterException {
        try {
            String dir = params.getParameter("directory");
            this.setDirectory(new File(dir));
        }
        catch (IOException e) {
            throw new ParameterException("Unable to set directory", (Throwable)e);
        }
        String databaseName = params.getParameter("data-file", "store.dat");
        String indexName = params.getParameter("index-file", "store.idx");
        int order = params.getParameterAsInteger("order", 301);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Database file name = " + databaseName);
            this.getLogger().debug("Index file name = " + indexName);
            this.getLogger().debug("Order=" + order);
        }
        File databaseFile = new File(this.m_directoryFile, databaseName);
        File indexFile = new File(this.m_directoryFile, indexName);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Initializing JispFilesystemStore");
        }
        try {
            boolean isOld = databaseFile.exists();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("initialize(): Datafile exists: " + isOld);
            }
            this.m_Index = !isOld ? new BTreeIndex(indexFile.toString(), order, super.getNullKey(), false) : new BTreeIndex(indexFile.toString());
            this.m_Database = new IndexedObjectDatabase(databaseFile.toString(), !isOld);
            this.m_Database.attachIndex((ObjectIndex)this.m_Index);
        }
        catch (KeyNotFound ignore) {
        }
        catch (Exception e) {
            this.getLogger().error("initialize(..) Exception", (Throwable)e);
        }
    }

    public void dispose() {
        try {
            this.getLogger().debug("Disposing");
            if (this.m_Index != null) {
                this.m_Index.close();
            }
            if (this.m_Database != null) {
                this.m_Database.close();
            }
        }
        catch (Exception e) {
            this.getLogger().error("dispose(..) Exception", (Throwable)e);
        }
    }
}

