/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.logger;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.apache.avalon.framework.logger.Logger;

public class ServletLogger
implements Logger {
    public static final int LEVEL_DEBUG = 0;
    public static final int LEVEL_INFO = 1;
    public static final int LEVEL_WARN = 2;
    public static final int LEVEL_ERROR = 3;
    public static final int LEVEL_FATAL = 4;
    public static final int LEVEL_DISABLED = 5;
    private final ServletContext m_servletContext;
    private final int m_logLevel;
    private final String m_prompt;

    public ServletLogger(ServletConfig servletConfig) {
        this(servletConfig, 0);
    }

    private void checkState() {
        if (this.m_servletContext == null) {
            throw new NullPointerException("servletContext");
        }
        if (this.m_logLevel < 0 || this.m_logLevel > 5) {
            throw new IllegalArgumentException("Bad logLevel: " + this.m_logLevel);
        }
    }

    public ServletLogger(ServletContext servletContext, String prompt, int logLevel) {
        this.m_servletContext = servletContext;
        this.m_logLevel = logLevel;
        this.checkState();
        this.m_prompt = prompt;
    }

    public ServletLogger(ServletConfig servletConfig, int logLevel) {
        this.m_servletContext = servletConfig.getServletContext();
        this.m_logLevel = logLevel;
        this.checkState();
        String servletName = servletConfig.getServletName();
        this.m_prompt = servletName == null || "".equals(servletName) ? "unknown: " : servletName + ": ";
    }

    public void debug(String message) {
        this.debug(message, null);
    }

    public void debug(String message, Throwable throwable) {
        if (this.m_logLevel <= 0) {
            this.m_servletContext.log(this.m_prompt + "[DEBUG] " + message, throwable);
        }
    }

    public boolean isDebugEnabled() {
        return this.m_logLevel <= 0;
    }

    public void info(String message) {
        this.info(message, null);
    }

    public void info(String message, Throwable throwable) {
        if (this.m_logLevel <= 1) {
            this.m_servletContext.log(this.m_prompt + "[INFO] " + message, throwable);
        }
    }

    public boolean isInfoEnabled() {
        return this.m_logLevel <= 1;
    }

    public void warn(String message) {
        this.warn(message, null);
    }

    public void warn(String message, Throwable throwable) {
        if (this.m_logLevel <= 2) {
            this.m_servletContext.log(this.m_prompt + "[WARNING] " + message, throwable);
        }
    }

    public boolean isWarnEnabled() {
        return this.m_logLevel <= 2;
    }

    public void error(String message) {
        this.error(message, null);
    }

    public void error(String message, Throwable throwable) {
        if (this.m_logLevel <= 3) {
            this.m_servletContext.log(this.m_prompt + "[ERROR] " + message, throwable);
        }
    }

    public boolean isErrorEnabled() {
        return this.m_logLevel <= 3;
    }

    public void fatalError(String message) {
        this.fatalError(message, null);
    }

    public void fatalError(String message, Throwable throwable) {
        if (this.m_logLevel <= 4) {
            this.m_servletContext.log(this.m_prompt + "[FATAL ERROR] " + message, throwable);
        }
    }

    public boolean isFatalErrorEnabled() {
        return this.m_logLevel <= 4;
    }

    public Logger getChildLogger(String name) {
        return this;
    }
}

