/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.AbstractTransformer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class AugmentTransformer
extends AbstractTransformer {
    protected Map objectModel;
    protected Request request;
    protected String baseURI;
    protected Set augmentedAttributes;
    public static final String AUGMENTED_ATTRIBUTES = "attributes";

    public void setup(SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws ProcessingException, SAXException, IOException {
        this.objectModel = objectModel;
        this.request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String mountPoint = parameters.getParameter("mount", null);
        StringBuffer uribuf = new StringBuffer();
        boolean isSecure = this.request.isSecure();
        int port = this.request.getServerPort();
        if (isSecure) {
            uribuf.append("https://");
        } else {
            uribuf.append("http://");
        }
        uribuf.append(this.request.getServerName());
        if (isSecure) {
            if (port != 443) {
                uribuf.append(":").append(port);
            }
        } else if (port != 80) {
            uribuf.append(":").append(port);
        }
        if (mountPoint == null) {
            String requestedURI = this.request.getRequestURI();
            requestedURI = requestedURI.substring(0, requestedURI.lastIndexOf("/"));
            uribuf.append(requestedURI);
            uribuf.append("/");
        } else {
            uribuf.append(this.request.getContextPath());
            uribuf.append("/");
            uribuf.append(mountPoint);
        }
        this.baseURI = uribuf.toString();
        this.augmentedAttributes = new HashSet();
        this.myAugmentedAttributes(parameters);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("List of attributes to augment: " + this.augmentedAttributes));
        }
    }

    public void startElement(String uri, String name, String qname, Attributes attrs) throws SAXException {
        AttributesImpl newAttrs = null;
        int size = attrs.getLength();
        for (int i = 0; i < size; ++i) {
            String value;
            String attrName = attrs.getLocalName(i);
            if (!this.augmentedAttributes.contains(attrName) || (value = attrs.getValue(i)).startsWith("http:") || value.startsWith("https:")) continue;
            if (newAttrs == null) {
                newAttrs = new AttributesImpl(attrs);
            }
            String newValue = this.baseURI + value;
            newAttrs.setValue(i, newValue);
        }
        if (newAttrs == null) {
            super.startElement(uri, name, qname, attrs);
        } else {
            super.startElement(uri, name, qname, newAttrs);
        }
    }

    public void recycle() {
        this.objectModel = null;
        this.request = null;
        this.baseURI = null;
        super.recycle();
    }

    private void myAugmentedAttributes(Parameters parameters) {
        String augmentedAttributesStr = parameters.getParameter(AUGMENTED_ATTRIBUTES, "href");
        if (augmentedAttributesStr != null) {
            StringTokenizer t = new StringTokenizer(augmentedAttributesStr, " \t\r\n\f,:");
            while (t.hasMoreTokens()) {
                String attr = t.nextToken();
                if ((attr = attr.trim()).length() <= 0) continue;
                this.augmentedAttributes.add(attr);
            }
        }
    }
}

