/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.generation;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.components.source.util.SourceUtil;
import org.apache.cocoon.core.xml.SAXParser;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.generation.Generator;
import org.apache.cocoon.sitemap.DisposableSitemapComponent;
import org.apache.cocoon.util.AbstractLogEnabled;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceValidity;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class FileGeneratorBean
extends AbstractLogEnabled
implements Generator,
CacheableProcessingComponent,
DisposableSitemapComponent {
    protected Source inputSource;
    protected SourceResolver resolver;
    protected XMLConsumer consumer;
    protected SAXParser parser;

    public void setParser(SAXParser parser) {
        this.parser = parser;
    }

    public void dispose() {
        if (this.inputSource != null) {
            this.resolver.release(this.inputSource);
            this.inputSource = null;
        }
        this.resolver = null;
        this.consumer = null;
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        this.resolver = resolver;
        try {
            this.inputSource = this.resolver.resolveURI(src);
        }
        catch (SourceException se) {
            throw SourceUtil.handle((String)("Error during resolving of '" + src + "'."), (SourceException)se);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Source " + src + " resolved to " + this.inputSource.getURI()));
        }
    }

    public Serializable getKey() {
        return this.inputSource.getURI();
    }

    public SourceValidity getValidity() {
        return this.inputSource.getValidity();
    }

    public void setConsumer(XMLConsumer consumer) {
        this.consumer = consumer;
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        try {
            SourceUtil.parse((SAXParser)this.parser, (Source)this.inputSource, (ContentHandler)this.consumer);
        }
        catch (SAXException e) {
            SourceUtil.handleSAXException((String)this.inputSource.getURI(), (SAXException)e);
        }
    }
}

