/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.generation;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.components.source.util.SourceUtil;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceValidity;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class DirectoryGenerator
extends ServiceableGenerator
implements CacheableProcessingComponent {
    private static final String FILE = "file:";
    protected static final String URI = "http://apache.org/cocoon/directory/2.0";
    protected static final String PREFIX = "dir";
    protected static final String DIR_NODE_NAME = "directory";
    protected static final String FILE_NODE_NAME = "file";
    protected static final String FILENAME_ATTR_NAME = "name";
    protected static final String LASTMOD_ATTR_NAME = "lastModified";
    protected static final String DATE_ATTR_NAME = "date";
    protected static final String SIZE_ATTR_NAME = "size";
    protected DirValidity validity;
    protected AttributesImpl attributes;
    protected List cacheKeyParList;
    protected int depth;
    protected SimpleDateFormat dateFormatter;
    protected long refreshDelay;
    protected String sort;
    protected boolean reverse;
    protected RE rootRE;
    protected RE includeRE;
    protected RE excludeRE;
    protected boolean isRequestedDirectory;
    protected Source directorySource;

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        if (src == null) {
            throw new ProcessingException("No src attribute pointing to a directory to be XMLized specified.");
        }
        super.setup(resolver, objectModel, src, par);
        try {
            this.directorySource = this.resolver.resolveURI(src);
        }
        catch (SourceException se) {
            throw SourceUtil.handle((SourceException)se);
        }
        this.cacheKeyParList = new ArrayList();
        this.cacheKeyParList.add(this.directorySource.getURI());
        this.depth = par.getParameterAsInteger("depth", 1);
        this.cacheKeyParList.add(String.valueOf(this.depth));
        String dateFormatString = par.getParameter("dateFormat", null);
        this.cacheKeyParList.add(dateFormatString);
        this.dateFormatter = dateFormatString != null ? new SimpleDateFormat(dateFormatString) : new SimpleDateFormat();
        this.sort = par.getParameter("sort", FILENAME_ATTR_NAME);
        this.cacheKeyParList.add(this.sort);
        this.reverse = par.getParameterAsBoolean("reverse", false);
        this.cacheKeyParList.add(String.valueOf(this.reverse));
        this.refreshDelay = par.getParameterAsLong("refreshDelay", 1L) * 1000L;
        this.cacheKeyParList.add(String.valueOf(this.refreshDelay));
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("depth: " + this.depth));
            this.getLogger().debug((Object)("dateFormat: " + this.dateFormatter.toPattern()));
            this.getLogger().debug((Object)("sort: " + this.sort));
            this.getLogger().debug((Object)("reverse: " + this.reverse));
            this.getLogger().debug((Object)("refreshDelay: " + this.refreshDelay));
        }
        String rePattern = null;
        try {
            rePattern = par.getParameter("root", null);
            this.cacheKeyParList.add(rePattern);
            RE rE = this.rootRE = rePattern == null ? null : new RE(rePattern);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("root pattern: " + rePattern));
            }
            rePattern = par.getParameter("include", null);
            this.cacheKeyParList.add(rePattern);
            RE rE2 = this.includeRE = rePattern == null ? null : new RE(rePattern);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("include pattern: " + rePattern));
            }
            rePattern = par.getParameter("exclude", null);
            this.cacheKeyParList.add(rePattern);
            RE rE3 = this.excludeRE = rePattern == null ? null : new RE(rePattern);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("exclude pattern: " + rePattern));
            }
        }
        catch (RESyntaxException rese) {
            throw new ProcessingException("Syntax error in regexp pattern '" + rePattern + "'", (Throwable)rese);
        }
        this.isRequestedDirectory = false;
        this.attributes = new AttributesImpl();
    }

    public Serializable getKey() {
        StringBuffer buffer = new StringBuffer();
        int len = this.cacheKeyParList.size();
        for (int i = 0; i < len; ++i) {
            buffer.append(this.cacheKeyParList.get(i)).append(":");
        }
        return buffer.toString();
    }

    public SourceValidity getValidity() {
        if (this.validity == null) {
            this.validity = new DirValidity(this.refreshDelay);
        }
        return this.validity;
    }

    public void generate() throws SAXException, ProcessingException {
        try {
            String systemId = this.directorySource.getURI();
            if (!systemId.startsWith(FILE)) {
                throw new ResourceNotFoundException(systemId + " does not denote a directory");
            }
            File directoryFile = new File(new URL(systemId).getFile());
            if (!directoryFile.isDirectory()) {
                throw new ResourceNotFoundException(this.source + " is not a directory.");
            }
            this.contentHandler.startDocument();
            this.contentHandler.startPrefixMapping(PREFIX, URI);
            Stack ancestors = this.getAncestors(directoryFile);
            this.addAncestorPath(directoryFile, ancestors);
            this.contentHandler.endPrefixMapping(PREFIX);
            this.contentHandler.endDocument();
        }
        catch (IOException ioe) {
            throw new ResourceNotFoundException("Could not read directory " + this.source, (Throwable)ioe);
        }
    }

    protected Stack getAncestors(File path) {
        File parent = path;
        Stack<File> ancestors = new Stack<File>();
        while (parent != null && !this.isRoot(parent)) {
            if ((parent = parent.getParentFile()) != null) {
                ancestors.push(parent);
                continue;
            }
            ancestors.clear();
        }
        return ancestors;
    }

    protected void addAncestorPath(File path, Stack ancestors) throws SAXException {
        if (ancestors.empty()) {
            this.isRequestedDirectory = true;
            this.addPath(path, this.depth);
        } else {
            this.startNode(DIR_NODE_NAME, (File)ancestors.pop());
            this.addAncestorPath(path, ancestors);
            this.endNode(DIR_NODE_NAME);
        }
    }

    protected void addPath(File path, int depth) throws SAXException {
        if (path.isDirectory()) {
            this.startNode(DIR_NODE_NAME, path);
            if (depth > 0) {
                File[] contents = path.listFiles();
                if (this.sort.equals(FILENAME_ATTR_NAME)) {
                    Arrays.sort(contents, new Comparator(){

                        public int compare(Object o1, Object o2) {
                            if (DirectoryGenerator.this.reverse) {
                                return ((File)o2).getName().compareTo(((File)o1).getName());
                            }
                            return ((File)o1).getName().compareTo(((File)o2).getName());
                        }
                    });
                } else if (this.sort.equals(SIZE_ATTR_NAME)) {
                    Arrays.sort(contents, new Comparator(){

                        public int compare(Object o1, Object o2) {
                            if (DirectoryGenerator.this.reverse) {
                                return new Long(((File)o2).length()).compareTo(new Long(((File)o1).length()));
                            }
                            return new Long(((File)o1).length()).compareTo(new Long(((File)o2).length()));
                        }
                    });
                } else if (this.sort.equals("lastmodified")) {
                    Arrays.sort(contents, new Comparator(){

                        public int compare(Object o1, Object o2) {
                            if (DirectoryGenerator.this.reverse) {
                                return new Long(((File)o2).lastModified()).compareTo(new Long(((File)o1).lastModified()));
                            }
                            return new Long(((File)o1).lastModified()).compareTo(new Long(((File)o2).lastModified()));
                        }
                    });
                } else if (this.sort.equals(DIR_NODE_NAME)) {
                    Arrays.sort(contents, new Comparator(){

                        public int compare(Object o1, Object o2) {
                            File f1 = (File)o1;
                            File f2 = (File)o2;
                            if (DirectoryGenerator.this.reverse) {
                                if (f2.isDirectory() && f1.isFile()) {
                                    return -1;
                                }
                                if (f2.isFile() && f1.isDirectory()) {
                                    return 1;
                                }
                                return f2.getName().compareTo(f1.getName());
                            }
                            if (f2.isDirectory() && f1.isFile()) {
                                return 1;
                            }
                            if (f2.isFile() && f1.isDirectory()) {
                                return -1;
                            }
                            return f1.getName().compareTo(f2.getName());
                        }
                    });
                }
                for (int i = 0; i < contents.length; ++i) {
                    if (!this.isIncluded(contents[i]) || this.isExcluded(contents[i])) continue;
                    this.addPath(contents[i], depth - 1);
                }
            }
            this.endNode(DIR_NODE_NAME);
        } else if (this.isIncluded(path) && !this.isExcluded(path)) {
            this.startNode(FILE_NODE_NAME, path);
            this.endNode(FILE_NODE_NAME);
        }
    }

    protected void startNode(String nodeName, File path) throws SAXException {
        if (this.validity != null) {
            this.validity.addFile(path);
        }
        this.setNodeAttributes(path);
        this.contentHandler.startElement(URI, nodeName, "dir:" + nodeName, this.attributes);
    }

    protected void setNodeAttributes(File path) throws SAXException {
        long lastModified = path.lastModified();
        this.attributes.clear();
        this.attributes.addAttribute("", FILENAME_ATTR_NAME, FILENAME_ATTR_NAME, "CDATA", path.getName());
        this.attributes.addAttribute("", LASTMOD_ATTR_NAME, LASTMOD_ATTR_NAME, "CDATA", Long.toString(path.lastModified()));
        this.attributes.addAttribute("", DATE_ATTR_NAME, DATE_ATTR_NAME, "CDATA", this.dateFormatter.format(new Date(lastModified)));
        this.attributes.addAttribute("", SIZE_ATTR_NAME, SIZE_ATTR_NAME, "CDATA", Long.toString(path.length()));
        if (this.isRequestedDirectory) {
            this.attributes.addAttribute("", "sort", "sort", "CDATA", this.sort);
            this.attributes.addAttribute("", "reverse", "reverse", "CDATA", String.valueOf(this.reverse));
            this.attributes.addAttribute("", "requested", "requested", "CDATA", "true");
            this.isRequestedDirectory = false;
        }
    }

    protected void endNode(String nodeName) throws SAXException {
        this.contentHandler.endElement(URI, nodeName, "dir:" + nodeName);
    }

    protected boolean isRoot(File path) {
        return this.rootRE == null || this.rootRE.match(path.getName());
    }

    protected boolean isIncluded(File path) {
        return this.includeRE == null || this.includeRE.match(path.getName());
    }

    protected boolean isExcluded(File path) {
        return this.excludeRE != null && this.excludeRE.match(path.getName());
    }

    public void recycle() {
        if (this.resolver != null) {
            this.resolver.release(this.directorySource);
            this.directorySource = null;
        }
        this.cacheKeyParList = null;
        this.attributes = null;
        this.dateFormatter = null;
        this.rootRE = null;
        this.includeRE = null;
        this.excludeRE = null;
        this.validity = null;
        super.recycle();
    }

    public static class DirValidity
    implements SourceValidity {
        private long expiry;
        private long delay;
        List files = new ArrayList();
        List fileDates = new ArrayList();

        public DirValidity(long delay) {
            this.expiry = System.currentTimeMillis() + delay;
            this.delay = delay;
        }

        public int isValid() {
            if (System.currentTimeMillis() <= this.expiry) {
                return 1;
            }
            int len = this.files.size();
            for (int i = 0; i < len; ++i) {
                long newDate;
                File f = (File)this.files.get(i);
                if (!f.exists()) {
                    return -1;
                }
                long oldDate = (Long)this.fileDates.get(i);
                if (oldDate == (newDate = f.lastModified())) continue;
                return -1;
            }
            this.expiry = System.currentTimeMillis() + this.delay;
            return 1;
        }

        public int isValid(SourceValidity newValidity) {
            return this.isValid();
        }

        public void addFile(File f) {
            this.files.add(f);
            this.fileDates.add(new Long(f.lastModified()));
        }
    }
}

