/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.generation;

import java.io.IOException;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.commons.lang.BooleanUtils;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.NOPValidity;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class CalendarGenerator
extends ServiceableGenerator
implements CacheableProcessingComponent {
    protected static final String URI = "http://apache.org/cocoon/calendar/1.0";
    protected static final String PREFIX = "calendar";
    protected static final String CALENDAR_NODE_NAME = "calendar";
    protected static final String WEEK_NODE_NAME = "week";
    protected static final String DAY_NODE_NAME = "day";
    protected static final String MONTH_ATTR_NAME = "month";
    protected static final String YEAR_ATTR_NAME = "year";
    protected static final String DATE_ATTR_NAME = "date";
    protected static final String NUMBER_ATTR_NAME = "number";
    protected static final String WEEKDAY_ATTR_NAME = "weekday";
    protected static final String PREV_MONTH_ATTR_NAME = "prevMonth";
    protected static final String PREV_YEAR_ATTR_NAME = "prevYear";
    protected static final String NEXT_MONTH_ATTR_NAME = "nextMonth";
    protected static final String NEXT_YEAR_ATTR_NAME = "nextYear";
    protected static final DecimalFormat monthNumberFormatter = new DecimalFormat("00");
    protected AttributesImpl attributes;
    protected List cacheKeyParList;
    protected int year;
    protected int month;
    protected DateFormat dateFormatter;
    protected DateFormat monthFormatter;
    protected Locale locale;
    protected boolean padWeeks;
    protected String[] weekdays = new String[]{"", "SUNDAY", "MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY"};

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, par);
        this.cacheKeyParList = new ArrayList();
        this.cacheKeyParList.add(src);
        String langString = par.getParameter("lang", null);
        this.locale = Locale.getDefault();
        if (langString != null) {
            this.cacheKeyParList.add(langString);
            String countryString = par.getParameter("country", "");
            if (!"".equals(countryString)) {
                this.cacheKeyParList.add(countryString);
            }
            this.locale = new Locale(langString, countryString);
        }
        Calendar now = Calendar.getInstance(this.locale);
        this.year = par.getParameterAsInteger(YEAR_ATTR_NAME, now.get(1));
        this.cacheKeyParList.add(String.valueOf(this.year));
        this.month = par.getParameterAsInteger(MONTH_ATTR_NAME, now.get(2) + 1) - 1;
        this.cacheKeyParList.add(String.valueOf(this.month));
        String dateFormatString = par.getParameter("dateFormat", null);
        this.cacheKeyParList.add(dateFormatString);
        this.dateFormatter = dateFormatString != null ? new SimpleDateFormat(dateFormatString, this.locale) : DateFormat.getDateInstance(1, this.locale);
        this.padWeeks = par.getParameterAsBoolean("padWeeks", false);
        this.cacheKeyParList.add(BooleanUtils.toBooleanObject((boolean)this.padWeeks));
        this.monthFormatter = new SimpleDateFormat("MMMM", this.locale);
        this.attributes = new AttributesImpl();
    }

    public void generate() throws SAXException, ProcessingException {
        Calendar start = Calendar.getInstance(this.locale);
        start.clear();
        start.set(1, this.year);
        start.set(2, this.month);
        start.set(5, 1);
        Calendar end = (Calendar)start.clone();
        end.add(2, 1);
        Calendar prevMonth = (Calendar)start.clone();
        prevMonth.add(2, -1);
        this.contentHandler.startDocument();
        this.contentHandler.startPrefixMapping("calendar", URI);
        this.attributes.clear();
        this.attributes.addAttribute("", YEAR_ATTR_NAME, YEAR_ATTR_NAME, "CDATA", String.valueOf(this.year));
        this.attributes.addAttribute("", MONTH_ATTR_NAME, MONTH_ATTR_NAME, "CDATA", this.monthFormatter.format(start.getTime()));
        this.attributes.addAttribute("", PREV_YEAR_ATTR_NAME, PREV_YEAR_ATTR_NAME, "CDATA", String.valueOf(prevMonth.get(1)));
        this.attributes.addAttribute("", PREV_MONTH_ATTR_NAME, PREV_MONTH_ATTR_NAME, "CDATA", monthNumberFormatter.format(prevMonth.get(2) + 1));
        this.attributes.addAttribute("", NEXT_YEAR_ATTR_NAME, NEXT_YEAR_ATTR_NAME, "CDATA", String.valueOf(end.get(1)));
        this.attributes.addAttribute("", NEXT_MONTH_ATTR_NAME, NEXT_MONTH_ATTR_NAME, "CDATA", monthNumberFormatter.format(end.get(2) + 1));
        this.contentHandler.startElement(URI, "calendar", "calendar:calendar", this.attributes);
        int weekNo = start.get(4);
        int firstDay = start.getFirstDayOfWeek();
        if (start.get(7) != firstDay) {
            this.attributes.clear();
            this.attributes.addAttribute("", NUMBER_ATTR_NAME, NUMBER_ATTR_NAME, "CDATA", String.valueOf(weekNo));
            this.contentHandler.startElement(URI, WEEK_NODE_NAME, "calendar:week", this.attributes);
            if (this.padWeeks) {
                Calendar previous = (Calendar)start.clone();
                while (previous.get(7) != firstDay) {
                    previous.add(5, -1);
                }
                while (previous.before(start)) {
                    this.attributes.clear();
                    this.attributes.addAttribute("", NUMBER_ATTR_NAME, NUMBER_ATTR_NAME, "CDATA", String.valueOf(previous.get(5)));
                    this.attributes.addAttribute("", WEEKDAY_ATTR_NAME, WEEKDAY_ATTR_NAME, "CDATA", this.weekdays[previous.get(7)]);
                    this.attributes.addAttribute("", DATE_ATTR_NAME, DATE_ATTR_NAME, "CDATA", this.dateFormatter.format(previous.getTime()));
                    this.contentHandler.startElement(URI, DAY_NODE_NAME, "calendar:day", this.attributes);
                    this.addContent(previous, this.locale);
                    this.contentHandler.endElement(URI, DAY_NODE_NAME, "calendar:day");
                    previous.add(5, 1);
                }
            }
        }
        while (start.before(end)) {
            if (start.get(7) == firstDay) {
                weekNo = start.get(4);
                this.attributes.clear();
                this.attributes.addAttribute("", NUMBER_ATTR_NAME, NUMBER_ATTR_NAME, "CDATA", String.valueOf(weekNo));
                this.contentHandler.startElement(URI, WEEK_NODE_NAME, "calendar:week", this.attributes);
            }
            this.attributes.clear();
            this.attributes.addAttribute("", NUMBER_ATTR_NAME, NUMBER_ATTR_NAME, "CDATA", String.valueOf(start.get(5)));
            this.attributes.addAttribute("", WEEKDAY_ATTR_NAME, WEEKDAY_ATTR_NAME, "CDATA", this.weekdays[start.get(7)]);
            this.attributes.addAttribute("", DATE_ATTR_NAME, DATE_ATTR_NAME, "CDATA", this.dateFormatter.format(start.getTime()));
            this.contentHandler.startElement(URI, DAY_NODE_NAME, "calendar:day", this.attributes);
            this.addContent(start, this.locale);
            this.contentHandler.endElement(URI, DAY_NODE_NAME, "calendar:day");
            start.add(5, 1);
            if (start.get(7) != firstDay && (this.padWeeks || start.before(end))) continue;
            this.contentHandler.endElement(URI, WEEK_NODE_NAME, "calendar:week");
        }
        if (this.padWeeks) {
            while (firstDay != end.get(7)) {
                this.attributes.clear();
                this.attributes.addAttribute("", NUMBER_ATTR_NAME, NUMBER_ATTR_NAME, "CDATA", String.valueOf(end.get(5)));
                this.attributes.addAttribute("", WEEKDAY_ATTR_NAME, WEEKDAY_ATTR_NAME, "CDATA", this.weekdays[end.get(7)]);
                this.attributes.addAttribute("", DATE_ATTR_NAME, DATE_ATTR_NAME, "CDATA", this.dateFormatter.format(end.getTime()));
                this.contentHandler.startElement(URI, DAY_NODE_NAME, "calendar:day", this.attributes);
                this.addContent(end, this.locale);
                this.contentHandler.endElement(URI, DAY_NODE_NAME, "calendar:day");
                end.add(5, 1);
                if (firstDay != end.get(7)) continue;
                this.contentHandler.endElement(URI, WEEK_NODE_NAME, "calendar:week");
            }
        }
        this.contentHandler.endElement(URI, "calendar", "calendar:calendar");
        this.contentHandler.endPrefixMapping("calendar");
        this.contentHandler.endDocument();
    }

    protected void addContent(Calendar date, Locale locale) throws SAXException {
    }

    public Serializable getKey() {
        StringBuffer buffer = new StringBuffer();
        int len = this.cacheKeyParList.size();
        for (int i = 0; i < len; ++i) {
            buffer.append(this.cacheKeyParList.get(i)).append(":");
        }
        return buffer.toString();
    }

    public SourceValidity getValidity() {
        return NOPValidity.SHARED_INSTANCE;
    }

    public void recycle() {
        this.cacheKeyParList = null;
        this.attributes = null;
        this.dateFormatter = null;
        this.monthFormatter = null;
        this.locale = null;
        super.recycle();
    }
}

