/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.modules.output;

import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.modules.output.AbstractOutputModule;
import org.apache.cocoon.environment.ObjectModelHelper;

public class SessionAttributeOutputModule
extends AbstractOutputModule
implements ThreadSafe {
    public static final String PREFIX = "org.apache.cocoon.components.modules.output.OutputModule";
    public static final String TRANS_PREFIX = "org.apache.cocoon.components.modules.output.OutputModule.SessionAttributeOutputModule.transient";
    public static final String ROLLBACK_LIST = "org.apache.cocoon.components.modules.output.OutputModule.SessionAttributeOutputModule.rollback";

    public void setAttribute(Configuration modeConf, Map objectModel, String name, Object value) {
        if (this.settings.get((Object)"isolation-level", (Object)"0").equals("1")) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("setting transient ['" + name + "'] to ['" + value + "']"));
            }
            this.transientSetAttribute(objectModel, TRANS_PREFIX, name, value);
        } else {
            HttpSession session = ObjectModelHelper.getRequest((Map)objectModel).getSession();
            if (!this.attributeExists(objectModel, ROLLBACK_LIST, name = this.getName(name))) {
                Object tmp = session.getAttribute(name);
                this.transientSetAttribute(objectModel, ROLLBACK_LIST, name, tmp);
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("setting ['" + name + "'] to ['" + value + "']"));
            }
            session.setAttribute(name, value);
        }
    }

    public void rollback(Configuration modeConf, Map objectModel, Exception e) {
        String prefix;
        if (this.settings.get((Object)"isolation-level", (Object)"0").equals("1")) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)"rolling back");
            }
            this.rollback(objectModel, TRANS_PREFIX);
        } else {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)"start rolling back");
            }
            HttpSession session = ObjectModelHelper.getRequest((Map)objectModel).getSession();
            Map tmp = this.prepareCommit(objectModel, ROLLBACK_LIST);
            if (tmp != null) {
                Map rollbackList = tmp;
                Iterator iter = rollbackList.keySet().iterator();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    Object val = rollbackList.get(key);
                    if (val != null) {
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug((Object)("rolling back ['" + key + "'] to ['" + val + "']"));
                        }
                        session.setAttribute(key, val);
                        continue;
                    }
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug((Object)("rolling back ['" + key + "']"));
                    }
                    session.removeAttribute(key);
                }
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)"done rolling back");
        }
        if (!(prefix = (String)this.settings.get((Object)"key-prefix", (Object)PREFIX)).equals("")) {
            ObjectModelHelper.getRequest((Map)objectModel).getSession().setAttribute(prefix + ":", (Object)e.getMessage());
        } else {
            ObjectModelHelper.getRequest((Map)objectModel).getSession().setAttribute("errorMessage", (Object)e.getMessage());
        }
    }

    public void commit(Configuration modeConf, Map objectModel) {
        if (this.settings.get((Object)"isolation-level", (Object)"0").equals("1")) {
            Map aMap;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)"prepare commit");
            }
            if ((aMap = this.prepareCommit(objectModel, TRANS_PREFIX)) == null) {
                return;
            }
            Iterator iter = aMap.keySet().iterator();
            if (!iter.hasNext()) {
                return;
            }
            String prefix = (String)this.settings.get((Object)"key-prefix", (Object)PREFIX);
            prefix = prefix.length() > 0 ? prefix + ":" : null;
            HttpSession session = ObjectModelHelper.getRequest((Map)objectModel).getSession();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                Object value = aMap.get(key);
                if (prefix != null) {
                    key = prefix + key;
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("committing ['" + key + "'] to ['" + value + "']"));
                }
                session.setAttribute(key, value);
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)"done commit");
            }
        } else {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)"commit");
            }
            this.prepareCommit(objectModel, ROLLBACK_LIST);
        }
    }

    protected String getName(String name) {
        String prefix = (String)this.settings.get((Object)"key-prefix", (Object)PREFIX);
        return prefix.length() == 0 ? name : prefix + ":" + name;
    }
}

