/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.sax;

import java.util.HashMap;
import org.apache.cocoon.components.sax.DocumentLocatorException;
import org.apache.cocoon.components.sax.XMLByteStreamConstants;
import org.apache.cocoon.xml.XMLConsumer;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public abstract class AbstractXMLByteStreamCompiler
implements XMLConsumer,
XMLByteStreamConstants {
    private HashMap map = new HashMap();
    private int mapCount;
    private boolean hasProlog = false;

    protected AbstractXMLByteStreamCompiler() {
        this.initOutput();
    }

    private void initOutput() {
        this.mapCount = 0;
        this.map.clear();
        this.hasProlog = false;
    }

    public void recycle() {
        this.initOutput();
    }

    public void startDocument() throws SAXException {
        if (!this.hasProlog) {
            this.writeProlog();
        }
        this.writeEvent(0);
    }

    public void endDocument() throws SAXException {
        this.writeEvent(1);
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (!this.hasProlog) {
            this.writeProlog();
        }
        this.writeEvent(2);
        this.writeString(prefix);
        this.writeString(uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.writeEvent(3);
        this.writeString(prefix);
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        int length = atts.getLength();
        this.writeEvent(4);
        this.writeAttributes(length);
        for (int i = 0; i < length; ++i) {
            this.writeString(atts.getURI(i));
            this.writeString(atts.getLocalName(i));
            this.writeString(atts.getQName(i));
            this.writeString(atts.getType(i));
            this.writeString(atts.getValue(i));
        }
        this.writeString(namespaceURI == null ? "" : namespaceURI);
        this.writeString(localName);
        this.writeString(qName);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.writeEvent(5);
        this.writeString(namespaceURI == null ? "" : namespaceURI);
        this.writeString(localName);
        this.writeString(qName);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.writeEvent(6);
        this.writeChars(ch, start, length);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (!this.hasProlog) {
            this.writeProlog();
        }
        this.writeEvent(7);
        this.writeChars(ch, start, length);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.writeEvent(8);
        this.writeString(target);
        this.writeString(data);
    }

    public void setDocumentLocator(Locator locator) {
        try {
            if (!this.hasProlog) {
                this.writeProlog();
            }
            this.writeEvent(10);
            String publicId = locator.getPublicId();
            String systemId = locator.getSystemId();
            this.writeString(publicId != null ? publicId : "");
            this.writeString(systemId != null ? systemId : "");
            this.write(locator.getLineNumber());
            this.write(locator.getColumnNumber());
        }
        catch (Exception e) {
            throw new DocumentLocatorException("Error while handling locator", e);
        }
    }

    public void skippedEntity(String name) throws SAXException {
        this.writeEvent(15);
        this.writeString(name);
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.writeEvent(11);
        this.writeString(name);
        this.writeString(publicId != null ? publicId : "");
        this.writeString(systemId != null ? systemId : "");
    }

    public void endDTD() throws SAXException {
        this.writeEvent(12);
    }

    public void startEntity(String name) throws SAXException {
        this.writeEvent(16);
        this.writeString(name);
    }

    public void endEntity(String name) throws SAXException {
        this.writeEvent(17);
        this.writeString(name);
    }

    public void startCDATA() throws SAXException {
        this.writeEvent(13);
    }

    public void endCDATA() throws SAXException {
        this.writeEvent(14);
    }

    public void comment(char[] ary, int start, int length) throws SAXException {
        try {
            this.writeEvent(9);
            this.writeChars(ary, start, length);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    public final void writeEvent(int event) throws SAXException {
        this.write(event);
    }

    public final void writeAttributes(int attributes) throws SAXException {
        if (attributes > 65535) {
            throw new SAXException("Too many attributes");
        }
        this.write(attributes >>> 8 & 0xFF);
        this.write(attributes >>> 0 & 0xFF);
    }

    public final void writeString(String str) throws SAXException {
        Integer index = (Integer)this.map.get(str);
        if (index == null) {
            this.map.put(str, new Integer(this.mapCount++));
            int length = str.length();
            this.writeChars(str.toCharArray(), 0, length);
        } else {
            int i = index;
            if (i <= Short.MAX_VALUE) {
                this.write(i >>> 8 & 0xFF | 0x80);
                this.write(i >>> 0 & 0xFF);
            } else {
                this.write(127);
                this.write(-1);
                this.write((byte)(i >>> 24 & 0xFF) | 0x80);
                this.write((byte)(i >>> 16 & 0xFF));
                this.write((byte)(i >>> 8 & 0xFF));
                this.write((byte)(i >>> 0 & 0xFF));
            }
        }
    }

    public final void writeChars(char[] ch, int start, int length) throws SAXException {
        char c;
        int i;
        int utflen = 0;
        for (i = 0; i < length; ++i) {
            c = ch[i + start];
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        if (utflen >= Short.MAX_VALUE) {
            this.write(127);
            this.write(-1);
            this.write((byte)(utflen >>> 24 & 0xFF));
            this.write((byte)(utflen >>> 16 & 0xFF));
            this.write((byte)(utflen >>> 8 & 0xFF));
            this.write((byte)(utflen >>> 0 & 0xFF));
        } else {
            this.write((byte)(utflen >>> 8 & 0xFF));
            this.write((byte)(utflen >>> 0 & 0xFF));
        }
        for (i = 0; i < length; ++i) {
            c = ch[i + start];
            if (c >= '\u0001' && c <= '\u007f') {
                this.write((byte)c);
                continue;
            }
            if (c > '\u07ff') {
                this.write((byte)(0xE0 | c >> 12 & 0xF));
                this.write((byte)(0x80 | c >> 6 & 0x3F));
                this.write((byte)(0x80 | c >> 0 & 0x3F));
                continue;
            }
            this.write((byte)(0xC0 | c >> 6 & 0x1F));
            this.write((byte)(0x80 | c >> 0 & 0x3F));
        }
    }

    protected abstract void write(int var1) throws SAXException;

    private void writeProlog() throws SAXException {
        this.write(67);
        this.write(88);
        this.write(77);
        this.write(76);
        this.write(1);
        this.write(0);
        this.hasProlog = true;
    }
}

