/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.pipeline.spring;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.cocoon.components.pipeline.spring.PipelineComponentScopeHolder;
import org.apache.cocoon.generation.Generator;
import org.apache.cocoon.serialization.Serializer;
import org.apache.cocoon.transformation.Transformer;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class PipelineComponentProxyDecorator
implements BeanPostProcessor {
    private PipelineComponentScopeHolder holder;

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof Generator || bean instanceof Transformer || bean instanceof Serializer) {
            bean = Proxy.newProxyInstance(bean.getClass().getClassLoader(), this.getInterfaces(bean.getClass()), (InvocationHandler)new ScopeChangerProxy(bean, this.holder));
        }
        return bean;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public PipelineComponentScopeHolder getHolder() {
        return this.holder;
    }

    public void setHolder(PipelineComponentScopeHolder holder) {
        this.holder = holder;
    }

    private void getInterfaces(Set interfaces, Class clazz) {
        Class<?>[] clazzInterfaces = clazz.getInterfaces();
        for (int i = 0; i < clazzInterfaces.length; ++i) {
            this.getInterfaces(interfaces, clazzInterfaces[i]);
        }
        Class superclazz = clazz.getSuperclass();
        if (superclazz != null) {
            this.getInterfaces(interfaces, superclazz);
        }
        interfaces.addAll(Arrays.asList(clazzInterfaces));
    }

    private Class[] getInterfaces(Class clazz) {
        LinkedHashSet interfaces = new LinkedHashSet();
        this.getInterfaces(interfaces, clazz);
        return interfaces.toArray(new Class[interfaces.size()]);
    }

    private class ScopeChangerProxy
    implements InvocationHandler {
        private Map beans;
        private Map destructionCallbacks;
        private PipelineComponentScopeHolder holder;
        private Object wrapped;

        public ScopeChangerProxy(Object wrapped, PipelineComponentScopeHolder holder) {
            this.wrapped = wrapped;
            this.holder = holder;
            this.beans = new HashMap();
            this.destructionCallbacks = new HashMap();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object result;
            boolean modified = false;
            try {
                if (!this.holder.getInScope()) {
                    this.holder.setParentBeans(this.holder.getBeans());
                    this.holder.setParentDestructionCallbacks(this.holder.getDestructionCallbacks());
                    this.holder.setBeans(this.beans);
                    this.holder.setDestructionCallbacks(this.destructionCallbacks);
                    this.holder.setInScope(true);
                    modified = true;
                }
                result = method.invoke(this.wrapped, args);
                Object var7_6 = null;
                if (modified) {
                    this.holder.setBeans(this.holder.getParentBeans());
                    this.holder.setDestructionCallbacks(this.holder.getParentDestructionCallbacks());
                    this.holder.setParentBeans(null);
                    this.holder.setParentDestructionCallbacks(null);
                    this.holder.setInScope(false);
                }
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (modified) {
                    this.holder.setBeans(this.holder.getParentBeans());
                    this.holder.setDestructionCallbacks(this.holder.getParentDestructionCallbacks());
                    this.holder.setParentBeans(null);
                    this.holder.setParentDestructionCallbacks(null);
                    this.holder.setInScope(false);
                }
                throw throwable;
            }
            return result;
        }
    }
}

