/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cocoon.forms.event.RepeaterEvent;
import org.apache.cocoon.forms.event.RepeaterEventAction;
import org.apache.cocoon.forms.event.RepeaterListener;
import org.apache.cocoon.forms.event.WidgetEventMulticaster;
import org.apache.cocoon.forms.formmodel.Repeater;
import org.apache.cocoon.forms.formmodel.Widget;
import org.apache.commons.lang.StringUtils;

public class WidgetFinder {
    private boolean keepUpdated = false;
    private List noRepeaterWidgets = null;
    private Map repeaterPaths = null;
    private Map repeaterWidgets = null;
    private List newAdditions = new ArrayList();
    private RefreshingRepeaterListener refreshingListener = new RefreshingRepeaterListener();
    private RepeaterListener listener;

    public WidgetFinder(Widget context, Iterator paths, boolean keepUpdated) {
        this.keepUpdated = keepUpdated;
        while (paths.hasNext()) {
            String path = (String)paths.next();
            if ((path = this.toAsterisk(path)).indexOf(42) == -1) {
                this.addSimpleWidget(context, path);
                continue;
            }
            this.recurseRepeaters(context, path, true);
        }
    }

    public WidgetFinder(Widget context, String path, boolean keepUpdated) {
        path = this.toAsterisk(path);
        this.keepUpdated = keepUpdated;
        if (path.indexOf(42) == -1) {
            this.addSimpleWidget(context, path);
        } else {
            this.recurseRepeaters(context, path, true);
        }
    }

    private String toAsterisk(String path) {
        return StringUtils.replace((String)path, (String)"/./", (String)"/*/");
    }

    private void recurseRepeaters(Widget context, String path, boolean root) {
        String reppath = path.substring(0, path.indexOf(42) - 1);
        String childpath = path.substring(path.indexOf(42) + 2);
        Widget wdg = context.lookupWidget(reppath);
        if (wdg == null) {
            if (root) {
                throw new IllegalArgumentException("Cannot find a repeater with path " + reppath + " relative to widget " + context.getName());
            }
            return;
        }
        if (!(wdg instanceof Repeater)) {
            throw new IllegalArgumentException("The widget with path " + reppath + " relative to widget " + context.getName() + " is not a repeater!");
        }
        Repeater repeater = (Repeater)wdg;
        if (context instanceof Repeater.RepeaterRow) {
            this.addRepeaterWidget((Repeater)context.getParent(), repeater);
        }
        this.addRepeaterPath(repeater, childpath);
        if (childpath.indexOf(42) != -1) {
            for (int i = 0; i < repeater.getSize(); ++i) {
                Repeater.RepeaterRow row = repeater.getRow(i);
                this.recurseRepeaters(row, childpath, false);
            }
        } else {
            for (int i = 0; i < repeater.getSize(); ++i) {
                Repeater.RepeaterRow row = repeater.getRow(i);
                Widget okwdg = row.lookupWidget(childpath);
                if (okwdg == null) continue;
                this.addRepeaterWidget(repeater, okwdg);
            }
        }
    }

    private void addRepeaterWidget(Repeater repeater, Widget okwdg) {
        HashSet<Widget> widgets;
        if (this.repeaterWidgets == null) {
            this.repeaterWidgets = new HashMap();
        }
        if ((widgets = (HashSet<Widget>)this.repeaterWidgets.get(repeater)) == null) {
            widgets = new HashSet<Widget>();
            this.repeaterWidgets.put(repeater, widgets);
        }
        widgets.add(okwdg);
        this.newAdditions.add(okwdg);
    }

    private void addRepeaterPath(Repeater repeater, String childpath) {
        HashSet<String> paths;
        if (this.repeaterPaths == null) {
            this.repeaterPaths = new HashMap();
        }
        if ((paths = (HashSet<String>)this.repeaterPaths.get(repeater)) == null) {
            paths = new HashSet<String>();
            this.repeaterPaths.put(repeater, paths);
            if (this.keepUpdated) {
                repeater.addRepeaterListener(this.refreshingListener);
            }
        }
        paths.add(childpath);
    }

    protected void refreshForAdd(Repeater repeater, int index) {
        Repeater.RepeaterRow row = repeater.getRow(index);
        if (this.repeaterPaths == null) {
            this.repeaterPaths = new HashMap();
        }
        Set paths = (Set)this.repeaterPaths.get(repeater);
        Iterator iter = paths.iterator();
        while (iter.hasNext()) {
            String path = (String)iter.next();
            if (path.indexOf(42) != -1) {
                this.recurseRepeaters(row, path, false);
                continue;
            }
            Widget wdg = row.lookupWidget(path);
            if (wdg == null) {
                throw new IllegalStateException("Even after row addition cannot find a widget with path " + path + " in repeater " + repeater.getName());
            }
            this.addRepeaterWidget(repeater, wdg);
        }
    }

    protected void refreshForDelete(Repeater repeater, int index) {
        Repeater.RepeaterRow row = repeater.getRow(index);
        Set widgets = (Set)this.repeaterWidgets.get(repeater);
        Iterator iter = widgets.iterator();
        while (iter.hasNext()) {
            Widget widget = (Widget)iter.next();
            boolean ischild = false;
            for (Widget parent = widget.getParent(); parent != null; parent = parent.getParent()) {
                if (parent != row) continue;
                ischild = true;
                break;
            }
            if (!ischild) continue;
            iter.remove();
            if (!(widget instanceof Repeater)) continue;
            if (this.repeaterPaths != null) {
                this.repeaterPaths.remove(widget);
            }
            this.repeaterWidgets.remove(widget);
        }
    }

    protected void refreshForClear(Repeater repeater) {
        Set widgets = (Set)this.repeaterWidgets.get(repeater);
        Iterator iter = widgets.iterator();
        while (iter.hasNext()) {
            Widget widget = (Widget)iter.next();
            if (!(widget instanceof Repeater)) continue;
            if (this.repeaterPaths != null) {
                this.repeaterPaths.remove(widget);
            }
            this.repeaterWidgets.remove(widget);
        }
        widgets.clear();
    }

    private void addSimpleWidget(Widget context, String path) {
        Widget widget = context.lookupWidget(path);
        if (widget == null) {
            throw new IllegalArgumentException("Cannot find a widget with path " + path + " relative to widget " + context.getName());
        }
        if (this.noRepeaterWidgets == null) {
            this.noRepeaterWidgets = new ArrayList();
        }
        this.noRepeaterWidgets.add(widget);
        this.newAdditions.add(widget);
    }

    public Collection getWidgets() {
        ArrayList list = new ArrayList();
        if (this.noRepeaterWidgets != null) {
            list.addAll(this.noRepeaterWidgets);
        }
        if (this.repeaterWidgets != null) {
            Iterator iter = this.repeaterWidgets.keySet().iterator();
            while (iter.hasNext()) {
                Repeater repeater = (Repeater)iter.next();
                list.addAll((Collection)this.repeaterWidgets.get(repeater));
            }
        }
        return list;
    }

    public boolean isMutable() {
        return this.repeaterPaths != null && this.repeaterPaths.size() > 0;
    }

    public boolean hasNewAdditions() {
        return this.newAdditions.size() > 0;
    }

    public List getNewAdditions() {
        ArrayList ret = new ArrayList(this.newAdditions);
        this.newAdditions.clear();
        return ret;
    }

    public void addRepeaterListener(RepeaterListener listener) {
        this.listener = WidgetEventMulticaster.add(this.listener, listener);
    }

    public void removeRepeaterListener(RepeaterListener listener) {
        this.listener = WidgetEventMulticaster.remove(this.listener, listener);
    }

    public boolean hasRepeaterListeners() {
        return this.listener != null;
    }

    class RefreshingRepeaterListener
    implements RepeaterListener {
        RefreshingRepeaterListener() {
        }

        public void repeaterModified(RepeaterEvent event) {
            if (event.getAction() == RepeaterEventAction.ROW_ADDED) {
                WidgetFinder.this.refreshForAdd((Repeater)event.getSourceWidget(), event.getRow());
            }
            if (event.getAction() == RepeaterEventAction.ROW_DELETING) {
                WidgetFinder.this.refreshForDelete((Repeater)event.getSourceWidget(), event.getRow());
            }
            if (event.getAction() == RepeaterEventAction.ROWS_CLEARING) {
                WidgetFinder.this.refreshForClear((Repeater)event.getSourceWidget());
            }
            if (WidgetFinder.this.listener != null) {
                WidgetFinder.this.listener.repeaterModified(event);
            }
        }
    }
}

