/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import org.apache.cocoon.core.xml.SAXParser;
import org.apache.cocoon.forms.FormsException;
import org.apache.cocoon.util.location.Location;
import org.apache.cocoon.util.location.LocationAttributes;
import org.apache.cocoon.xml.SaxBuffer;
import org.apache.cocoon.xml.dom.DOMBuilder;
import org.apache.cocoon.xml.dom.DOMStreamer;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.excalibur.xml.sax.XMLizable;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DomHelper {
    public static final String XMLNS_URI = "http://www.w3.org/2000/xmlns/";
    private static Log LOG = LogFactory.getLog((Class)DomHelper.class);

    public static Location getLocationObject(Element element) {
        return LocationAttributes.getLocation((Element)element);
    }

    public static String getLocation(Element element) {
        return LocationAttributes.getLocationString((Element)element);
    }

    public static String getSystemIdLocation(Element element) {
        return LocationAttributes.getURI((Element)element);
    }

    public static int getLineLocation(Element element) {
        return LocationAttributes.getLine((Element)element);
    }

    public static int getColumnLocation(Element element) {
        return LocationAttributes.getColumn((Element)element);
    }

    public static Element[] getChildElements(Element element, String namespace) {
        ArrayList<Node> elements = new ArrayList<Node>();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !namespace.equals(node.getNamespaceURI())) continue;
            elements.add(node);
        }
        return elements.toArray(new Element[elements.size()]);
    }

    public static Element[] getChildElements(Element element, String namespace, String localName) {
        ArrayList<Node> elements = new ArrayList<Node>();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !namespace.equals(node.getNamespaceURI()) || !localName.equals(node.getLocalName())) continue;
            elements.add(node);
        }
        return elements.toArray(new Element[elements.size()]);
    }

    public static Element getChildElement(Element element, String namespace, String localName) {
        Element node;
        try {
            node = DomHelper.getChildElement(element, namespace, localName, false);
        }
        catch (Exception e) {
            node = null;
        }
        return node;
    }

    public static Element getChildElement(Element element, String namespace, String localName, boolean required) throws FormsException {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !namespace.equals(node.getNamespaceURI()) || !localName.equals(node.getLocalName())) continue;
            return (Element)node;
        }
        if (required) {
            throw new FormsException("Required element '" + localName + "' is missing.", DomHelper.getLocationObject(element));
        }
        return null;
    }

    public static String getAttribute(Element element, String attributeName) throws FormsException {
        String attrValue = element.getAttribute(attributeName);
        if (attrValue.length() == 0) {
            throw new FormsException("Required attribute '" + attributeName + "' is missing.", DomHelper.getLocationObject(element));
        }
        return attrValue;
    }

    public static String getAttribute(Element element, String attributeName, String defaultValue) {
        String attrValue = element.getAttribute(attributeName);
        if (attrValue.length() == 0) {
            return defaultValue;
        }
        return attrValue;
    }

    public static int getAttributeAsInteger(Element element, String attributeName) throws FormsException {
        String attrValue = DomHelper.getAttribute(element, attributeName);
        try {
            return Integer.parseInt(attrValue);
        }
        catch (NumberFormatException e) {
            throw new FormsException("Cannot parse the value '" + attrValue + "' " + "as an integer in the attribute '" + attributeName + "'," + DomHelper.getLocationObject(element));
        }
    }

    public static int getAttributeAsInteger(Element element, String attributeName, int defaultValue) throws FormsException {
        String attrValue = element.getAttribute(attributeName);
        if (attrValue.length() == 0) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(attrValue);
        }
        catch (NumberFormatException e) {
            throw new FormsException("Cannot parse the value '" + attrValue + "' " + "as an integer in the attribute '" + attributeName + "'," + DomHelper.getLocationObject(element));
        }
    }

    public static boolean getAttributeAsBoolean(Element element, String attributeName, boolean defaultValue) {
        Boolean result;
        String attrValue = element.getAttribute(attributeName);
        if (attrValue.length() == 0) {
            return defaultValue;
        }
        try {
            result = BooleanUtils.toBooleanObject((String)attrValue, (String)"true", (String)"false", null);
        }
        catch (IllegalArgumentException e1) {
            try {
                result = BooleanUtils.toBooleanObject((String)attrValue, (String)"yes", (String)"no", null);
            }
            catch (IllegalArgumentException e2) {
                result = null;
            }
        }
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public static String getElementText(Element element) {
        StringBuffer value = new StringBuffer();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Text) && !(node instanceof CDATASection)) continue;
            value.append(node.getNodeValue());
        }
        return value.toString();
    }

    public static XMLizable compileElementContent(Element element) {
        LocationAttributes.remove((Element)element, (boolean)true);
        SaxBuffer saxBuffer = new SaxBuffer();
        DOMStreamer domStreamer = new DOMStreamer();
        domStreamer.setContentHandler((ContentHandler)saxBuffer);
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            try {
                domStreamer.stream(childNodes.item(i));
                continue;
            }
            catch (SAXException e) {
                throw new RuntimeException("Error in DomHelper.compileElementContent: " + e.toString());
            }
        }
        return saxBuffer;
    }

    public static Document parse(InputSource inputSource, SAXParser parser) throws SAXException, IOException {
        DOMBuilder builder = new DOMBuilder();
        LocationAttributes.Pipe locationHandler = new LocationAttributes.Pipe((ContentHandler)builder);
        parser.parse(inputSource, (ContentHandler)locationHandler);
        return builder.getDocument();
    }

    public static Map getLocalNSDeclarations(Element elm) {
        return DomHelper.addLocalNSDeclarations(elm, null);
    }

    private static Map addLocalNSDeclarations(Element elm, Map nsDeclarations) {
        NamedNodeMap atts = elm.getAttributes();
        int attsSize = atts.getLength();
        for (int i = 0; i < attsSize; ++i) {
            Attr attr = (Attr)atts.item(i);
            if (!XMLNS_URI.equals(attr.getNamespaceURI())) continue;
            String nsUri = attr.getValue();
            String pfx = attr.getLocalName();
            if (nsDeclarations == null) {
                nsDeclarations = new HashMap<String, String>();
            }
            nsDeclarations.put(nsUri, pfx);
        }
        return nsDeclarations;
    }

    public static Map getInheritedNSDeclarations(Element elm) {
        LinkedList<Element> ancestorsAndSelf = new LinkedList<Element>();
        Element current = elm;
        while (current != null) {
            ancestorsAndSelf.add(current);
            Node parent = current.getParentNode();
            if (parent.getNodeType() == 1) {
                current = (Element)parent;
                continue;
            }
            current = null;
        }
        Map nsDeclarations = null;
        ListIterator i = ancestorsAndSelf.listIterator(ancestorsAndSelf.size());
        while (i.hasPrevious()) {
            Element element = (Element)i.previous();
            nsDeclarations = DomHelper.addLocalNSDeclarations(element, nsDeclarations);
        }
        return nsDeclarations;
    }
}

