/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.transformation;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.components.flow.FlowHelper;
import org.apache.cocoon.components.flow.WebContinuation;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.forms.formmodel.Form;
import org.apache.cocoon.i18n.I18nUtils;
import org.apache.cocoon.util.Deprecation;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathException;
import org.apache.commons.jxpath.Variables;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class FormsPipelineConfig {
    public static final String CFORMSKEY = "CocoonFormsInstance";
    private final String attributeName;
    private final Request request;
    private final JXPathContext jxpathContext;
    private final Locale localeParameter;
    private Locale locale;
    private String formAction;
    private String formMethod;

    private FormsPipelineConfig(JXPathContext jxpc, Request req, Locale localeParam, String attName, String actionExpression, String method) {
        this.attributeName = attName;
        this.request = req;
        this.jxpathContext = jxpc;
        this.localeParameter = localeParam;
        this.formAction = this.translateText(actionExpression);
        this.formMethod = method;
    }

    public static FormsPipelineConfig createConfig(Map objectModel, Parameters parameters) {
        Object flowContext = FlowHelper.getContextObject((Map)objectModel);
        WebContinuation wk = FlowHelper.getWebContinuation((Map)objectModel);
        JXPathContext jxpc = JXPathContext.newContext((Object)flowContext);
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        HttpSession session = request.getSession(false);
        HashMap<String, Object> cocoonOM = new HashMap<String, Object>();
        cocoonOM.put("continuation", wk);
        cocoonOM.put("request", request);
        if (session != null) {
            cocoonOM.put("session", session);
        }
        cocoonOM.put("parameters", parameters);
        FormsVariables vars = new FormsVariables();
        vars.declareVariable("cocoon", cocoonOM);
        vars.declareVariable("continuation", wk);
        vars.declareVariable("request", request);
        vars.declareVariable("session", session);
        vars.declareVariable("parameters", parameters);
        vars.addDeprecatedVariable("continuation");
        vars.addDeprecatedVariable("request");
        vars.addDeprecatedVariable("session");
        vars.addDeprecatedVariable("parameters");
        jxpc.setVariables((Variables)vars);
        Locale localeParameter = null;
        String localeStr = parameters.getParameter("locale", null);
        if (localeStr != null) {
            localeParameter = I18nUtils.parseLocale((String)localeStr);
        }
        String attributeName = parameters.getParameter("attribute-name", null);
        String actionExpression = parameters.getParameter("form-action", null);
        String formMethod = parameters.getParameter("form-method", null);
        return new FormsPipelineConfig(jxpc, request, localeParameter, attributeName, actionExpression, formMethod);
    }

    public Form findForm() throws SAXException {
        return this.findForm(null);
    }

    public Form findForm(String jxpathExpression) throws SAXException {
        Object form = null;
        if (jxpathExpression != null) {
            form = this.jxpathContext.getValue(jxpathExpression);
            if (form == null) {
                throw new SAXException("No Cocoon Form found at location \"" + jxpathExpression + "\".");
            }
            if (!(form instanceof Form)) {
                throw new SAXException("Object returned by expression \"" + jxpathExpression + "\" is not a Cocoon Form.");
            }
        } else if (this.attributeName != null) {
            form = this.request.getAttribute(this.attributeName);
            if (form == null) {
                throw new SAXException("No Cocoon Form found in request attribute with name \"" + this.attributeName + "\"");
            }
            if (!(form instanceof Form)) {
                throw new SAXException("Object found in request (attribute = '" + this.attributeName + "') is not a Cocoon Form.");
            }
        } else {
            jxpathExpression = "/CocoonFormsInstance";
            try {
                form = this.jxpathContext.getValue(jxpathExpression);
            }
            catch (JXPathException jXPathException) {
                // empty catch block
            }
            if (form == null) {
                throw new SAXException("No Cocoon Form found.");
            }
        }
        return (Form)form;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String translateText(String original) {
        if (original == null) {
            return null;
        }
        StringBuffer translated = new StringBuffer();
        StringReader in = new StringReader(original);
        try {
            int chr;
            while ((chr = in.read()) != -1) {
                boolean more;
                StringBuffer expression;
                char c;
                block10: {
                    c = (char)chr;
                    if (c == '#') {
                        chr = in.read();
                        if (chr != -1) {
                            c = (char)chr;
                            if (c != '{') continue;
                            expression = new StringBuffer();
                            more = true;
                            break block10;
                        } else {
                            translated.append((char)chr);
                            continue;
                        }
                    }
                    translated.append(c);
                    continue;
                }
                while (more) {
                    more = false;
                    chr = in.read();
                    if (chr != -1) {
                        c = (char)chr;
                        if (c != '}') {
                            expression.append(c);
                            more = true;
                            continue;
                        }
                        translated.append(this.evaluateExpression(expression.toString()).toString());
                        continue;
                    }
                    translated.append('#').append('{').append(expression);
                }
            }
            return translated.toString();
        }
        catch (IOException ignored) {
            ignored.printStackTrace();
        }
        return translated.toString();
    }

    public Object evaluateExpression(String expression) {
        return this.jxpathContext.getValue(expression);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocaleParameter() {
        return this.localeParameter;
    }

    public String getFormAction() {
        return this.formAction;
    }

    public String getFormMethod() {
        return this.formMethod;
    }

    public void setFormMethod(String method) {
        this.formMethod = method;
    }

    public Attributes getFormAttributes() {
        org.apache.cocoon.xml.AttributesImpl attrs = new org.apache.cocoon.xml.AttributesImpl();
        this.addFormAttributes((AttributesImpl)attrs);
        return attrs;
    }

    public void addFormAttributes(AttributesImpl attrs) {
        if (this.getFormAction() != null) {
            attrs.addAttribute("", "action", "action", "CDATA", this.getFormAction());
        }
        if (this.getFormMethod() != null) {
            attrs.addAttribute("", "method", "method", "CDATA", this.getFormMethod());
        }
    }

    public static final class FormsVariables
    implements Variables {
        final Map vars = new HashMap();
        final List deprecatedNames = new ArrayList();

        public void addDeprecatedVariable(String name) {
            this.deprecatedNames.add(name);
        }

        public void declareVariable(String name, Object value) {
            this.vars.put(name, value);
        }

        public Object getVariable(String name) {
            Object value = this.vars.get(name);
            if (this.deprecatedNames.contains(name)) {
                Deprecation.logger.warn((Object)("CForms: usage of the variable '" + name + "' is deprecated." + "Please use 'cocoon/" + name + "' instead. The usage of just '" + name + "' will be removed in Cocoon 2.2."));
            }
            return value;
        }

        public boolean isDeclaredVariable(String name) {
            return this.vars.containsKey(name);
        }

        public void undeclareVariable(String name) {
            this.vars.remove(name);
        }
    }
}

