/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.transformation;

import java.util.LinkedList;
import org.apache.cocoon.xml.AbstractXMLPipe;
import org.apache.cocoon.xml.SaxBuffer;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.LocatorImpl;

public class EffectPipe
extends AbstractXMLPipe {
    protected final Handler hNull = new NullHandler();
    protected final Handler hBuffer = new BufferHandler();
    protected Locator locator;
    private LinkedList handlers;
    private Handler handler;
    private LinkedList buffers;
    private LinkedList locators;
    protected SaxBuffer buffer;

    private ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    private LexicalHandler getLexicalHandler() {
        return this.lexicalHandler;
    }

    protected void init(Handler top) {
        this.locators = new LinkedList();
        this.handlers = new LinkedList();
        this.handler = top;
    }

    public void recycle() {
        super.recycle();
        this.handlers = null;
        this.handler = null;
        this.buffers = null;
        this.buffer = null;
        this.locator = null;
        this.locators = null;
    }

    protected String getLocation() {
        if (this.locator == null) {
            return "unknown";
        }
        return " (" + this.locator.getSystemId() + ":" + this.locator.getLineNumber() + ":" + this.locator.getColumnNumber() + ")";
    }

    protected void pushHandler(Handler handler) {
        this.handlers.addFirst(this.handler);
        this.handler = handler;
    }

    protected void popHandler() {
        this.handler = (Handler)this.handlers.removeFirst();
    }

    protected void beginBuffer() {
        if (this.buffer != null) {
            if (this.buffers == null) {
                this.buffers = new LinkedList();
            }
            this.buffers.addFirst(this.buffer);
        }
        if (this.locator != null) {
            this.locators.addFirst(this.locator);
            this.locator = new LocatorImpl(this.locator);
        }
        this.buffer = new SaxBuffer();
    }

    protected SaxBuffer endBuffer() {
        SaxBuffer buffer = this.buffer;
        this.buffer = this.buffers != null && this.buffers.size() > 0 ? (SaxBuffer)this.buffers.removeFirst() : null;
        if (this.locator != null) {
            this.locator = (Locator)this.locators.removeFirst();
        }
        return buffer;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startDocument() throws SAXException {
        this.pushHandler(this.handler.startDocument());
    }

    public void endDocument() throws SAXException {
        this.handler.endDocument();
        this.popHandler();
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.handler.startPrefixMapping(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.handler.endPrefixMapping(prefix);
    }

    public void startElement(String uri, String loc, String raw, Attributes attrs) throws SAXException {
        this.pushHandler(this.handler.nestedElement(uri, loc, raw, attrs));
        this.handler = this.handler.startElement(uri, loc, raw, attrs);
    }

    public void endElement(String uri, String loc, String raw) throws SAXException {
        this.handler.endElement(uri, loc, raw);
        this.popHandler();
    }

    public void characters(char[] ch, int start, int len) throws SAXException {
        this.handler = this.handler.characters(ch, start, len);
    }

    public void ignorableWhitespace(char[] ch, int start, int len) throws SAXException {
        this.handler = this.handler.ignorableWhitespace(ch, start, len);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.handler = this.handler.processingInstruction(target, data);
    }

    public void skippedEntity(String name) throws SAXException {
        this.handler = this.handler.skippedEntity(name);
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.handler = this.handler.startDTD(name, publicId, systemId);
    }

    public void endDTD() throws SAXException {
        this.handler = this.handler.endDTD();
    }

    public void startEntity(String name) throws SAXException {
        this.handler = this.handler.startEntity(name);
    }

    public void endEntity(String name) throws SAXException {
        this.handler = this.handler.endEntity(name);
    }

    public void startCDATA() throws SAXException {
        this.handler = this.handler.startCDATA();
    }

    public void endCDATA() throws SAXException {
        this.handler = this.handler.endCDATA();
    }

    public void comment(char[] ch, int start, int len) throws SAXException {
        this.handler = this.handler.comment(ch, start, len);
    }

    protected class ErrorHandler
    extends NullHandler {
        protected ErrorHandler() {
        }

        protected String getName() {
            return "<unknown>";
        }

        public Handler startDocument() throws SAXException {
            throw new SAXException("Unexpected startDocument in '" + this.getName() + "' (" + EffectPipe.this.getLocation() + ")");
        }

        public void endDocument() throws SAXException {
            throw new SAXException("Unexpected endDocument in '" + this.getName() + "' (" + EffectPipe.this.getLocation() + ")");
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            throw new SAXException("Unexpected startPrefixMapping in '" + this.getName() + "' (" + EffectPipe.this.getLocation() + ")");
        }

        public void endPrefixMapping(String prefix) throws SAXException {
            throw new SAXException("Unexpected endPrefixMapping in '" + this.getName() + "' (" + EffectPipe.this.getLocation() + ")");
        }

        public Handler startElement(String uri, String loc, String raw, Attributes attrs) throws SAXException {
            throw new SAXException("Unexpected startElement in '" + this.getName() + "' (" + EffectPipe.this.getLocation() + ")");
        }

        public void endElement(String uri, String loc, String raw) throws SAXException {
            throw new SAXException("Unexpected endElement in '" + this.getName() + "' (" + EffectPipe.this.getLocation() + ")");
        }

        public Handler characters(char[] ch, int start, int length) throws SAXException {
            throw new SAXException("Unexpected characters in '" + this.getName() + "' (" + EffectPipe.this.getLocation() + ")");
        }

        public Handler processingInstruction(String target, String data) throws SAXException {
            throw new SAXException("Unexpected processingInstruction in '" + this.getName() + "' (" + EffectPipe.this.getLocation() + ")");
        }

        public Handler skippedEntity(String name) throws SAXException {
            throw new SAXException("Unexpected skippedEntity in '" + this.getName() + "' (" + EffectPipe.this.getLocation() + ")");
        }

        public Handler startDTD(String name, String publicId, String systemId) throws SAXException {
            throw new SAXException("Unexpected startDTD in '" + this.getName() + "' (" + EffectPipe.this.getLocation() + ")");
        }

        public Handler endDTD() throws SAXException {
            throw new SAXException("Unexpected endDTD in '" + this.getName() + "' (" + EffectPipe.this.getLocation() + ")");
        }

        public Handler startEntity(String name) throws SAXException {
            throw new SAXException("Unexpected startEntity in '" + this.getName() + "' (" + EffectPipe.this.getLocation() + ")");
        }

        public Handler endEntity(String name) throws SAXException {
            throw new SAXException("Unexpected endEntity in '" + this.getName() + "' (" + EffectPipe.this.getLocation() + ")");
        }

        public Handler startCDATA() throws SAXException {
            throw new SAXException("Unexpected startCDATA in '" + this.getName() + "' (" + EffectPipe.this.getLocation() + ")");
        }

        public Handler endCDATA() throws SAXException {
            throw new SAXException("Unexpected endCDATA in '" + this.getName() + "' (" + EffectPipe.this.getLocation() + ")");
        }

        public Handler comment(char[] c, int start, int len) throws SAXException {
            throw new SAXException("Unexpected comment in '" + this.getName() + "' (" + EffectPipe.this.getLocation() + ")");
        }
    }

    protected class CopyHandler
    extends NullHandler {
        protected CopyHandler() {
        }

        public Handler startDocument() throws SAXException {
            EffectPipe.this.getContentHandler().startDocument();
            return this;
        }

        public void endDocument() throws SAXException {
            EffectPipe.this.getContentHandler().endDocument();
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            EffectPipe.this.getContentHandler().startPrefixMapping(prefix, uri);
        }

        public void endPrefixMapping(String prefix) throws SAXException {
            EffectPipe.this.getContentHandler().endPrefixMapping(prefix);
        }

        public Handler startElement(String uri, String loc, String raw, Attributes attrs) throws SAXException {
            EffectPipe.this.getContentHandler().startElement(uri, loc, raw, attrs);
            return this;
        }

        public void endElement(String uri, String loc, String raw) throws SAXException {
            EffectPipe.this.getContentHandler().endElement(uri, loc, raw);
        }

        public Handler characters(char[] ch, int start, int length) throws SAXException {
            EffectPipe.this.getContentHandler().characters(ch, start, length);
            return this;
        }

        public Handler ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            EffectPipe.this.getContentHandler().ignorableWhitespace(ch, start, length);
            return this;
        }

        public Handler processingInstruction(String target, String data) throws SAXException {
            EffectPipe.this.getContentHandler().processingInstruction(target, data);
            return this;
        }

        public Handler skippedEntity(String name) throws SAXException {
            EffectPipe.this.getContentHandler().skippedEntity(name);
            return this;
        }

        public Handler startDTD(String name, String publicId, String systemId) throws SAXException {
            if (EffectPipe.this.getLexicalHandler() != null) {
                EffectPipe.this.getLexicalHandler().startDTD(name, publicId, systemId);
            }
            return this;
        }

        public Handler endDTD() throws SAXException {
            if (EffectPipe.this.getLexicalHandler() != null) {
                EffectPipe.this.getLexicalHandler().endDTD();
            }
            return this;
        }

        public Handler startEntity(String name) throws SAXException {
            if (EffectPipe.this.getLexicalHandler() != null) {
                EffectPipe.this.getLexicalHandler().startEntity(name);
            }
            return this;
        }

        public Handler endEntity(String name) throws SAXException {
            if (EffectPipe.this.getLexicalHandler() != null) {
                EffectPipe.this.getLexicalHandler().endEntity(name);
            }
            return this;
        }

        public Handler startCDATA() throws SAXException {
            if (EffectPipe.this.getLexicalHandler() != null) {
                EffectPipe.this.getLexicalHandler().startCDATA();
            }
            return this;
        }

        public Handler endCDATA() throws SAXException {
            if (EffectPipe.this.getLexicalHandler() != null) {
                EffectPipe.this.getLexicalHandler().endCDATA();
            }
            return this;
        }

        public Handler comment(char[] c, int start, int len) throws SAXException {
            if (EffectPipe.this.getLexicalHandler() != null) {
                EffectPipe.this.getLexicalHandler().comment(c, start, len);
            }
            return this;
        }
    }

    protected class BufferHandler
    extends NullHandler {
        protected BufferHandler() {
        }

        public Handler startDocument() throws SAXException {
            if (EffectPipe.this.buffer != null) {
                EffectPipe.this.buffer.startDocument();
            }
            return this;
        }

        public void setDocumentLocator(Locator paramLocator) {
            EffectPipe.this.locator = new LocatorImpl(paramLocator);
            if (EffectPipe.this.buffer != null) {
                EffectPipe.this.buffer.setDocumentLocator(paramLocator);
            }
        }

        public void endDocument() throws SAXException {
            if (EffectPipe.this.buffer != null) {
                EffectPipe.this.buffer.endDocument();
            }
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            if (EffectPipe.this.buffer != null) {
                EffectPipe.this.buffer.startPrefixMapping(prefix, uri);
            }
        }

        public void endPrefixMapping(String prefix) throws SAXException {
            if (EffectPipe.this.buffer != null) {
                EffectPipe.this.buffer.endPrefixMapping(prefix);
            }
        }

        public Handler startElement(String uri, String loc, String raw, Attributes attrs) throws SAXException {
            if (EffectPipe.this.buffer != null) {
                EffectPipe.this.buffer.startElement(uri, loc, raw, attrs);
            }
            return this;
        }

        public void endElement(String uri, String loc, String raw) throws SAXException {
            if (EffectPipe.this.buffer != null) {
                EffectPipe.this.buffer.endElement(uri, loc, raw);
            }
        }

        public Handler characters(char[] ch, int start, int length) throws SAXException {
            if (EffectPipe.this.buffer != null) {
                EffectPipe.this.buffer.characters(ch, start, length);
            }
            return this;
        }

        public Handler ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            if (EffectPipe.this.buffer != null) {
                EffectPipe.this.buffer.ignorableWhitespace(ch, start, length);
            }
            return this;
        }

        public Handler processingInstruction(String target, String data) throws SAXException {
            if (EffectPipe.this.buffer != null) {
                EffectPipe.this.buffer.processingInstruction(target, data);
            }
            return this;
        }

        public Handler skippedEntity(String name) throws SAXException {
            if (EffectPipe.this.buffer != null) {
                EffectPipe.this.buffer.skippedEntity(name);
            }
            return this;
        }

        public Handler startDTD(String name, String publicId, String systemId) throws SAXException {
            if (EffectPipe.this.buffer != null) {
                EffectPipe.this.buffer.startDTD(name, publicId, systemId);
            }
            return this;
        }

        public Handler endDTD() throws SAXException {
            if (EffectPipe.this.buffer != null) {
                EffectPipe.this.buffer.endDTD();
            }
            return this;
        }

        public Handler startEntity(String name) throws SAXException {
            if (EffectPipe.this.buffer != null) {
                EffectPipe.this.buffer.startEntity(name);
            }
            return this;
        }

        public Handler endEntity(String name) throws SAXException {
            if (EffectPipe.this.buffer != null) {
                EffectPipe.this.buffer.endEntity(name);
            }
            return this;
        }

        public Handler startCDATA() throws SAXException {
            if (EffectPipe.this.buffer != null) {
                EffectPipe.this.buffer.startCDATA();
            }
            return this;
        }

        public Handler endCDATA() throws SAXException {
            if (EffectPipe.this.buffer != null) {
                EffectPipe.this.buffer.endCDATA();
            }
            return this;
        }

        public Handler comment(char[] c, int start, int len) throws SAXException {
            if (EffectPipe.this.buffer != null) {
                EffectPipe.this.buffer.comment(c, start, len);
            }
            return this;
        }
    }

    protected class NullHandler
    implements Handler {
        protected NullHandler() {
        }

        public Handler startDocument() throws SAXException {
            return this;
        }

        public void endDocument() throws SAXException {
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        public void endPrefixMapping(String prefix) throws SAXException {
        }

        public Handler nestedElement(String uri, String loc, String raw, Attributes attrs) throws SAXException {
            return this;
        }

        public Handler startElement(String uri, String loc, String raw, Attributes attrs) throws SAXException {
            return this;
        }

        public void endElement(String uri, String loc, String raw) throws SAXException {
        }

        public Handler characters(char[] ch, int start, int length) throws SAXException {
            return this;
        }

        public Handler ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            return this;
        }

        public Handler processingInstruction(String target, String data) throws SAXException {
            return this;
        }

        public Handler skippedEntity(String name) throws SAXException {
            return this;
        }

        public Handler startDTD(String name, String publicId, String systemId) throws SAXException {
            return this;
        }

        public Handler endDTD() throws SAXException {
            return this;
        }

        public Handler startEntity(String name) throws SAXException {
            return this;
        }

        public Handler endEntity(String name) throws SAXException {
            return this;
        }

        public Handler startCDATA() throws SAXException {
            return this;
        }

        public Handler endCDATA() throws SAXException {
            return this;
        }

        public Handler comment(char[] c, int start, int len) throws SAXException {
            return this;
        }
    }

    protected static interface Handler {
        public Handler startDocument() throws SAXException;

        public void endDocument() throws SAXException;

        public void startPrefixMapping(String var1, String var2) throws SAXException;

        public void endPrefixMapping(String var1) throws SAXException;

        public Handler startElement(String var1, String var2, String var3, Attributes var4) throws SAXException;

        public Handler nestedElement(String var1, String var2, String var3, Attributes var4) throws SAXException;

        public void endElement(String var1, String var2, String var3) throws SAXException;

        public Handler characters(char[] var1, int var2, int var3) throws SAXException;

        public Handler ignorableWhitespace(char[] var1, int var2, int var3) throws SAXException;

        public Handler processingInstruction(String var1, String var2) throws SAXException;

        public Handler skippedEntity(String var1) throws SAXException;

        public Handler startDTD(String var1, String var2, String var3) throws SAXException;

        public Handler endDTD() throws SAXException;

        public Handler startEntity(String var1) throws SAXException;

        public Handler endEntity(String var1) throws SAXException;

        public Handler startCDATA() throws SAXException;

        public Handler endCDATA() throws SAXException;

        public Handler comment(char[] var1, int var2, int var3) throws SAXException;
    }
}

