/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.generation;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.forms.FormsRuntimeException;
import org.apache.cocoon.forms.event.ValueChangedListenerEnabled;
import org.apache.cocoon.forms.formmodel.Form;
import org.apache.cocoon.forms.formmodel.Repeater;
import org.apache.cocoon.forms.formmodel.Widget;
import org.apache.cocoon.forms.formmodel.tree.Tree;
import org.apache.cocoon.forms.formmodel.tree.TreeWalker;
import org.apache.cocoon.forms.validation.ValidationError;
import org.apache.cocoon.i18n.I18nUtils;
import org.apache.cocoon.xml.AbstractXMLPipe;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.collections.ArrayStack;
import org.apache.commons.lang.BooleanUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class JXMacrosHelper {
    private XMLConsumer cocoonConsumer;
    private Request request;
    private Locale locale;
    private ArrayStack widgetStack = new ArrayStack();
    private ArrayStack pipeStack = new ArrayStack();
    private Map classes;
    private boolean ajaxRequest;
    private boolean ajaxTemplate;
    private Set updatedWidgets;
    private Set childUpdatedWidgets;
    private static final String VALIDATION_ERROR = "validation-error";

    public static JXMacrosHelper createHelper(XMLConsumer consumer, Request request, String locale) {
        return new JXMacrosHelper(consumer, request, locale);
    }

    public JXMacrosHelper(XMLConsumer consumer, Request request, String locale) {
        this.cocoonConsumer = consumer;
        this.request = request;
        this.locale = I18nUtils.parseLocale((String)locale);
        this.ajaxRequest = request.getParameter("cocoon-ajax") != null;
    }

    public Form getForm(Form form, String attributeName) {
        Form returnForm = form;
        if (returnForm == null) {
            returnForm = (Form)this.request.getAttribute(attributeName);
        }
        if (returnForm != null) {
            return returnForm;
        }
        throw new FormsRuntimeException("The template cannot find a form object");
    }

    public void startForm(Form form, Map attributes) throws SAXException {
        this.updatedWidgets = form.getUpdatedWidgetIds();
        this.childUpdatedWidgets = form.getChildUpdatedWidgetIds();
        AttributesImpl attrs = new AttributesImpl();
        if (form.getId().length() != 0) {
            attrs.addCDATAAttribute("id", form.getRequestParameterName());
        }
        attrs.addCDATAAttribute("state", form.getCombinedState().getName());
        attrs.addCDATAAttribute("locale", this.locale.toString().replaceAll("_", "-"));
        if (form instanceof ValueChangedListenerEnabled && ((ValueChangedListenerEnabled)((Object)form)).hasValueChangedListeners()) {
            attrs.addCDATAAttribute("listening", "true");
        }
        Iterator iter = attributes.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String attrName = (String)entry.getKey();
            if (attrs.getValue(attrName) != null) {
                attrs.removeAttribute(attrName);
            }
            attrs.addCDATAAttribute(attrName, (String)entry.getValue());
        }
        this.ajaxTemplate = "true".equals(attributes.get("ajax"));
        this.cocoonConsumer.startPrefixMapping("fi", "http://apache.org/cocoon/forms/1.0#instance");
        this.cocoonConsumer.startElement("http://apache.org/cocoon/forms/1.0#instance", "form-template", "fi:form-template", (Attributes)attrs);
        this.widgetStack.push((Object)Boolean.FALSE);
        this.widgetStack.push((Object)form);
    }

    public void endForm() throws SAXException {
        this.widgetStack.pop();
        this.widgetStack.pop();
        this.cocoonConsumer.endElement("http://apache.org/cocoon/forms/1.0#instance", "form-template", "fi:form-template");
        this.cocoonConsumer.endPrefixMapping("fi");
        this.ajaxTemplate = false;
        this.updatedWidgets = null;
    }

    private void startBuReplace(String id) throws SAXException {
        AttributesImpl attr = new AttributesImpl();
        attr.addCDATAAttribute("id", id);
        this.cocoonConsumer.startElement("http://apache.org/cocoon/browser-update/1.0", "replace", "bu:replace", (Attributes)attr);
    }

    private void endBuReplace(String id) throws SAXException {
        this.cocoonConsumer.endElement("http://apache.org/cocoon/browser-update/1.0", "replace", "bu:replace");
    }

    protected boolean pushWidget(String path, boolean unused) throws SAXException {
        boolean display;
        Widget parent = this.peekWidget();
        if (path == null || path.length() == 0) {
            throw new FormsRuntimeException("Missing 'id' attribute on template instruction");
        }
        Widget widget = parent.lookupWidget(path);
        if (widget == null) {
            throw new FormsRuntimeException(parent + " has no child named '" + path + "'", parent.getLocation());
        }
        String id = widget.getFullName();
        boolean inUpdatedTemplate = (Boolean)this.widgetStack.peek(1);
        if (this.ajaxRequest) {
            if (inUpdatedTemplate) {
                display = true;
            } else if (this.updatedWidgets.contains(id)) {
                inUpdatedTemplate = true;
                display = true;
            } else {
                display = this.childUpdatedWidgets.contains(id);
            }
        } else {
            if (this.ajaxTemplate) {
                inUpdatedTemplate = true;
            }
            display = true;
        }
        if (display) {
            if (widget.getState().isDisplayingValues()) {
                if (inUpdatedTemplate) {
                    this.startBuReplace(id);
                }
            } else {
                if (this.ajaxTemplate) {
                    this.startBuReplace(id);
                    AttributesImpl attrs = new AttributesImpl();
                    attrs.addCDATAAttribute("id", id);
                    this.cocoonConsumer.startElement("http://apache.org/cocoon/forms/1.0#instance", "placeholder", "fi:placeholder", (Attributes)attrs);
                    this.cocoonConsumer.endElement("http://apache.org/cocoon/forms/1.0#instance", "placeholder", "fi:placeholder");
                    this.endBuReplace(id);
                }
                display = false;
            }
        }
        if (display) {
            this.widgetStack.push((Object)BooleanUtils.toBooleanObject((boolean)inUpdatedTemplate));
            this.widgetStack.push((Object)widget);
        }
        return display;
    }

    public Widget peekWidget() {
        return (Widget)this.widgetStack.peek();
    }

    public void popWidget() throws SAXException {
        Widget widget = (Widget)this.widgetStack.pop();
        boolean inUpdatedTemplate = (Boolean)this.widgetStack.pop();
        if (inUpdatedTemplate) {
            this.endBuReplace(widget.getFullName());
        }
    }

    public boolean pushWidget(String path) throws SAXException {
        return this.pushWidget(path, false);
    }

    public boolean pushContainer(String path) throws SAXException {
        return this.pushWidget(path, true);
    }

    public boolean pushRepeater(String path, boolean ajaxAware) throws SAXException {
        if (!ajaxAware && this.ajaxTemplate) {
            throw new IllegalStateException("Cannot use <ft:repeater-widget> in an Ajax form");
        }
        boolean result = this.pushWidget(path, true);
        if (result && !(this.peekWidget() instanceof Repeater)) {
            throw new IllegalArgumentException("Widget " + this.peekWidget() + " is not a repeater");
        }
        return result;
    }

    public Widget getWidget(Widget currentWidget, String path) {
        Widget result = currentWidget.lookupWidget(path);
        if (result != null) {
            return result;
        }
        throw new FormsRuntimeException(currentWidget + " has no child named '" + path + "'", currentWidget.getLocation());
    }

    private Repeater getRepeater(Widget currentWidget, String id) {
        Widget child = this.getWidget(currentWidget, id);
        if (child instanceof Repeater) {
            return (Repeater)child;
        }
        throw new FormsRuntimeException(child + " is not a repeater", child.getLocation());
    }

    public void generateWidget(Widget widget, Map arguments) throws SAXException {
        RootBufferingPipe pipe = new RootBufferingPipe(this.cocoonConsumer, arguments);
        this.pipeStack.push((Object)pipe);
        widget.generateSaxFragment((ContentHandler)((Object)pipe), this.locale);
    }

    public void flushRootAndPop() throws SAXException {
        ((RootBufferingPipe)((Object)this.pipeStack.pop())).flushRoot();
        this.popWidget();
    }

    public void flushRoot() throws SAXException {
        ((RootBufferingPipe)((Object)this.pipeStack.pop())).flushRoot();
    }

    public void generateWidgetLabel(Widget widget, String id) throws SAXException {
        this.getWidget(widget, id).generateLabel((ContentHandler)this.cocoonConsumer);
    }

    public void generateRepeaterWidgetLabel(Widget widget, String id, String widgetId) throws SAXException {
        Repeater repeater = widget instanceof Repeater ? (Repeater)widget : this.getRepeater(widget, id);
        repeater.generateWidgetLabel(widgetId, (ContentHandler)this.cocoonConsumer);
    }

    public void generateRepeaterSize(Widget widget, String id) throws SAXException {
        this.getRepeater(widget, id).generateSize((ContentHandler)this.cocoonConsumer);
    }

    public void generateValidationError(ValidationError error) throws SAXException {
        RootBufferingPipe pipe = new RootBufferingPipe(this.cocoonConsumer);
        this.pipeStack.push((Object)pipe);
        pipe.startElement("http://apache.org/cocoon/forms/1.0#instance", VALIDATION_ERROR, "fi:validation-error", XMLUtils.EMPTY_ATTRIBUTES);
        error.generateSaxFragment((ContentHandler)((Object)pipe));
        pipe.endElement("http://apache.org/cocoon/forms/1.0#instance", VALIDATION_ERROR, "fi:validation-error");
    }

    public boolean isValidationError(Object object) {
        return object instanceof ValidationError;
    }

    public void defineClassBody(Form form, String id, Object body) {
        if (this.classes == null) {
            this.classes = new HashMap();
        }
        this.classes.put(id, body);
    }

    public Object getClassBody(String id) {
        Object result;
        Object v0 = result = this.classes == null ? null : this.classes.get(id);
        if (result == null) {
            throw new FormsRuntimeException("No class '" + id + "' has been defined.");
        }
        return result;
    }

    public boolean isSelectedCase(Widget unionWidget, String caseValue) {
        String value = (String)unionWidget.getValue();
        return caseValue.equals(value != null ? value : "");
    }

    public TreeWalker createWalker() {
        return new TreeWalker((Tree)this.peekWidget());
    }

    public boolean isVisible(Widget widget) throws SAXException {
        boolean visible = widget.getCombinedState().isDisplayingValues();
        if (!visible) {
            String id = widget.getRequestParameterName();
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("id", id);
            this.cocoonConsumer.startElement("http://apache.org/cocoon/browser-update/1.0", "replace", "bu:replace", (Attributes)attrs);
            this.cocoonConsumer.startElement("http://apache.org/cocoon/forms/1.0#instance", "placeholder", "fi:placeholder", (Attributes)attrs);
            this.cocoonConsumer.endElement("http://apache.org/cocoon/forms/1.0#instance", "placeholder", "fi:placeholder");
            this.cocoonConsumer.endElement("http://apache.org/cocoon/browser-update/1.0", "replace", "bu:replace");
        }
        return visible;
    }

    public boolean isModified(Widget widget) {
        return this.updatedWidgets.contains(widget.getRequestParameterName());
    }

    public boolean generateStyling(Map attributes) throws SAXException {
        return JXMacrosHelper.generateStyling((ContentHandler)this.cocoonConsumer, attributes);
    }

    public static boolean generateStyling(ContentHandler handler, Map attributes) throws SAXException {
        AttributesImpl attr = null;
        Iterator entries = attributes.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            String key = (String)entry.getKey();
            if ("id".equals(key) || "widget-id".equals(key)) continue;
            if (attr == null) {
                attr = new AttributesImpl();
            }
            attr.addCDATAAttribute(key, (String)entry.getValue());
        }
        if (attr != null) {
            handler.startElement("http://apache.org/cocoon/forms/1.0#instance", "styling", "fi:styling", (Attributes)attr);
            handler.endElement("http://apache.org/cocoon/forms/1.0#instance", "styling", "fi:styling");
            return true;
        }
        return false;
    }

    private static class RootBufferingPipe
    extends AbstractXMLPipe {
        private int depth = 0;
        private String rootUri;
        private String rootLoc;
        private String rootRaw;
        private Map arguments;
        private boolean forbidStyling = false;

        public RootBufferingPipe(XMLConsumer next) {
            this(next, Collections.EMPTY_MAP);
        }

        public RootBufferingPipe(XMLConsumer next, Map arguments) {
            this.setConsumer(next);
            this.arguments = arguments;
        }

        public void startElement(String uri, String loc, String raw, Attributes a) throws SAXException {
            super.startElement(uri, loc, raw, a);
            if (this.depth == 0) {
                this.rootUri = uri;
                this.rootLoc = loc;
                this.rootRaw = raw;
                this.forbidStyling = JXMacrosHelper.generateStyling(this.contentHandler, this.arguments);
            }
            if (this.depth == 1 && this.forbidStyling && uri.equals("http://apache.org/cocoon/forms/1.0#instance") && loc.equals("styling")) {
                throw new SAXException("Cannot use 'fi:*' attributes and <fi:styling> at the same time");
            }
            ++this.depth;
        }

        public void endElement(String uri, String loc, String raw) throws SAXException {
            --this.depth;
            if (this.depth > 0) {
                super.endElement(uri, loc, raw);
            }
        }

        public void flushRoot() throws SAXException {
            if (this.depth != 0) {
                throw new IllegalStateException("Depth is not zero");
            }
            super.endElement(this.rootUri, this.rootLoc, this.rootRaw);
        }
    }
}

