/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel.tree.builder;

import org.apache.cocoon.forms.FormsException;
import org.apache.cocoon.forms.formmodel.tree.JavaTreeModelDefinition;
import org.apache.cocoon.forms.formmodel.tree.TreeModel;
import org.apache.cocoon.forms.formmodel.tree.TreeModelDefinition;
import org.apache.cocoon.forms.formmodel.tree.builder.TreeModelDefinitionBuilder;
import org.apache.cocoon.forms.util.DomHelper;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.w3c.dom.Element;

public class JavaTreeModelDefinitionBuilder
implements TreeModelDefinitionBuilder,
BeanFactoryAware {
    private BeanFactory beanFactory;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public TreeModelDefinition build(Element treeModelElement) throws Exception {
        if (DomHelper.getAttribute(treeModelElement, "class", null) != null) {
            throw new RuntimeException("The 'class' attribute is not supported anymore at " + DomHelper.getLocationObject(treeModelElement) + ". Use a 'ref' attribute to address a Spring bean");
        }
        String beanRefId = DomHelper.getAttribute(treeModelElement, "ref");
        try {
            Class clazz = this.beanFactory.getType(beanRefId);
            if (!TreeModel.class.isAssignableFrom(clazz)) {
                throw new FormsException("Spring Bean '" + beanRefId + "' doesn't implement TreeModel.", DomHelper.getLocationObject(treeModelElement));
            }
        }
        catch (NoSuchBeanDefinitionException nsbde) {
            throw new FormsException("Spring Bean '" + beanRefId + "' doesn't exists.", DomHelper.getLocationObject(treeModelElement));
        }
        JavaTreeModelDefinition definition = new JavaTreeModelDefinition();
        definition.setBeanFactory(this.beanFactory);
        definition.setModelBeanRef(beanRefId);
        return definition;
    }
}

