/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel.tree;

import java.util.StringTokenizer;
import org.apache.cocoon.forms.formmodel.tree.TreeModel;

public class TreePath {
    public static final TreePath ROOT_PATH = new TreePath();
    private TreePath parentPath;
    private String key;
    private String cachedToString;

    private TreePath() {
        this.key = "";
        this.cachedToString = "/";
    }

    public TreePath(String key) {
        if (key == null || key.length() == 0) {
            throw new IllegalArgumentException("key must be non empty.");
        }
        if (key.indexOf(47) != -1) {
            throw new IllegalArgumentException("key cannot contain a '/'");
        }
        this.key = key;
        this.parentPath = ROOT_PATH;
    }

    public TreePath(TreePath parent, String key) {
        this(key);
        if (parent == null) {
            throw new IllegalArgumentException("Parent path must be non null.");
        }
        this.parentPath = parent;
    }

    public Object[] getObjectPath(TreeModel model) {
        int i = this.getPathCount();
        Object[] result = new Object[i--];
        TreePath path = this;
        while (path != null) {
            result[i--] = path.getLastPathObject(model);
            path = path.parentPath;
        }
        return result;
    }

    public Object getLastPathObject(TreeModel model) {
        Object parent = this.parentPath == ROOT_PATH ? model.getRoot() : this.parentPath.getLastPathObject(model);
        return model.getChild(parent, this.key);
    }

    public int getPathCount() {
        int result = 0;
        TreePath path = this;
        while (path != null) {
            ++result;
            path = path.parentPath;
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TreePath)) {
            return false;
        }
        TreePath otherPath = (TreePath)obj;
        if (this.getPathCount() != otherPath.getPathCount()) {
            return false;
        }
        TreePath path = this;
        do {
            if (otherPath == null || !path.key.equals(otherPath.key)) {
                return false;
            }
            path = path.parentPath;
            otherPath = otherPath.parentPath;
        } while (path != null);
        return true;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean isDescendant(TreePath aTreePath) {
        if (aTreePath == this) {
            return true;
        }
        if (aTreePath != null) {
            int pathLength = this.getPathCount();
            int oPathLength = aTreePath.getPathCount();
            if (oPathLength < pathLength) {
                return false;
            }
            while (oPathLength-- > pathLength) {
                aTreePath = aTreePath.getParentPath();
            }
            return this.equals(aTreePath);
        }
        return false;
    }

    public TreePath getParentPath() {
        return this.parentPath;
    }

    public String getLastKey() {
        return this.key;
    }

    public String toString() {
        if (this.cachedToString == null) {
            StringBuffer buf = new StringBuffer();
            this.appendTo(buf);
            this.cachedToString = buf.toString();
        }
        return this.cachedToString;
    }

    private void appendTo(StringBuffer buf) {
        if (this.parentPath != ROOT_PATH) {
            this.parentPath.appendTo(buf);
        }
        buf.append('/');
        buf.append(this.key);
    }

    public static TreePath valueOf(String s) {
        if (s == null || s.length() == 0) {
            throw new IllegalArgumentException("Invalid empty string");
        }
        StringTokenizer stok = new StringTokenizer(s, "/");
        TreePath current = ROOT_PATH;
        while (stok.hasMoreTokens()) {
            String tok = stok.nextToken();
            current = current == null ? new TreePath(tok) : new TreePath(current, tok);
        }
        return current;
    }

    public Object getObject(TreeModel model) {
        return this.parentPath == null ? model.getRoot() : model.getChild(this.parentPath.getObject(model), this.key);
    }
}

