/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel.algorithms;

import org.apache.cocoon.forms.FormsException;
import org.apache.cocoon.forms.formmodel.CalculatedFieldAlgorithm;
import org.apache.cocoon.forms.formmodel.algorithms.AbstractBaseAlgorithm;
import org.apache.cocoon.forms.formmodel.algorithms.AbstractBaseAlgorithmBuilder;
import org.apache.cocoon.forms.util.DomHelper;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.w3c.dom.Element;

public class JavaAlgorithmBuilder
extends AbstractBaseAlgorithmBuilder
implements BeanFactoryAware {
    private BeanFactory beanFactory;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public CalculatedFieldAlgorithm build(Element algorithmElement) throws Exception {
        if (DomHelper.getAttribute(algorithmElement, "class", null) != null) {
            throw new RuntimeException("The 'class' attribute is not supported anymore at " + DomHelper.getLocationObject(algorithmElement) + ". Use a 'ref' attribute to address a Spring bean");
        }
        String name = DomHelper.getAttribute(algorithmElement, "ref");
        try {
            Class clazz = this.beanFactory.getType(name);
            if (AbstractBaseAlgorithm.class.isAssignableFrom(clazz)) {
                AbstractBaseAlgorithm algorithm = (AbstractBaseAlgorithm)this.beanFactory.getBean(name);
                super.setup(algorithmElement, algorithm);
                return algorithm;
            }
            if (CalculatedFieldAlgorithm.class.isAssignableFrom(clazz)) {
                CalculatedFieldAlgorithm algorithm = (CalculatedFieldAlgorithm)this.beanFactory.getBean(name);
                return algorithm;
            }
            throw new FormsException("Spring bean " + name + " is not a " + CalculatedFieldAlgorithm.class.getName(), DomHelper.getLocationObject(algorithmElement));
        }
        catch (NoSuchBeanDefinitionException nsbde) {
            throw new FormsException("Spring bean " + name + " does not exist in Spring context", DomHelper.getLocationObject(algorithmElement));
        }
        catch (BeansException be) {
            throw new FormsException("Spring bean " + name + " cannot be retrieved/instantiated", DomHelper.getLocationObject(algorithmElement));
        }
    }
}

