/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel.algorithms;

import java.util.StringTokenizer;
import org.apache.cocoon.forms.formmodel.CalculatedFieldAlgorithmBuilder;
import org.apache.cocoon.forms.formmodel.algorithms.AbstractBaseAlgorithm;
import org.apache.cocoon.forms.util.DomHelper;
import org.w3c.dom.Element;

public abstract class AbstractBaseAlgorithmBuilder
implements CalculatedFieldAlgorithmBuilder {
    protected void setup(Element algorithmElement, AbstractBaseAlgorithm algorithm) throws Exception {
        this.setupTriggers(algorithmElement, algorithm);
    }

    protected void setupTriggers(Element algorithmElement, AbstractBaseAlgorithm algorithm) throws Exception {
        String fields = DomHelper.getAttribute(algorithmElement, "triggers", null);
        if (fields != null) {
            this.setupTriggers(fields, algorithm);
        }
    }

    protected void setupTriggers(String fields, AbstractBaseAlgorithm algorithm) {
        algorithm.clearTriggers();
        StringTokenizer stok = new StringTokenizer(fields, ", ");
        while (stok.hasMoreTokens()) {
            String fname = stok.nextToken();
            algorithm.addTrigger(fname);
        }
    }
}

