/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.cocoon.forms.FormContext;
import org.apache.cocoon.forms.formmodel.Widget;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class WidgetList {
    private static final String WIDGETS_EL = "widgets";
    private List widgets = new ArrayList();
    private Map widgetsById = new HashMap();

    public List getWidgetList() {
        return Collections.unmodifiableList(this.widgets);
    }

    public Map getWidgetMap() {
        return Collections.unmodifiableMap(this.widgetsById);
    }

    public void addWidget(Widget widget) {
        this.widgets.add(widget);
        this.widgetsById.put(widget.getId(), widget);
    }

    public void readFromRequest(FormContext formContext) {
        Iterator widgetIt = this.iterator();
        while (widgetIt.hasNext()) {
            Widget widget = (Widget)widgetIt.next();
            widget.readFromRequest(formContext);
        }
    }

    public boolean validate() {
        boolean valid = true;
        Iterator widgetIt = this.iterator();
        while (widgetIt.hasNext()) {
            Widget widget = (Widget)widgetIt.next();
            valid &= widget.validate();
        }
        return valid;
    }

    public boolean hasWidget(String id) {
        return this.widgetsById.containsKey(id);
    }

    public Widget getWidget(String id) {
        return (Widget)this.widgetsById.get(id);
    }

    public Iterator iterator() {
        return this.widgets.iterator();
    }

    public boolean widgetsHaveValues() {
        Iterator widgetsIt = this.iterator();
        while (widgetsIt.hasNext()) {
            Widget widget = (Widget)widgetsIt.next();
            if (widget.getValue() != null) continue;
            return false;
        }
        return true;
    }

    public void generateSaxFragment(ContentHandler contentHandler, Locale locale) throws SAXException {
        contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", WIDGETS_EL, "fi:widgets", XMLUtils.EMPTY_ATTRIBUTES);
        Iterator widgetIt = this.widgets.iterator();
        while (widgetIt.hasNext()) {
            Widget widget = (Widget)widgetIt.next();
            widget.generateSaxFragment(contentHandler, locale);
        }
        contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", WIDGETS_EL, "fi:widgets");
    }
}

