/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel;

import org.apache.cocoon.forms.FormContext;
import org.apache.cocoon.forms.FormsRuntimeException;
import org.apache.cocoon.forms.event.ValueChangedEvent;
import org.apache.cocoon.forms.event.ValueChangedListener;
import org.apache.cocoon.forms.event.ValueChangedListenerEnabled;
import org.apache.cocoon.forms.formmodel.AbstractContainerWidget;
import org.apache.cocoon.forms.formmodel.UnionDefinition;
import org.apache.cocoon.forms.formmodel.Widget;
import org.apache.cocoon.forms.formmodel.WidgetDefinition;
import org.apache.commons.lang.ObjectUtils;

public class Union
extends AbstractContainerWidget {
    private static final String UNION_EL = "field";
    private Widget caseWidget;
    protected String caseValue;
    private final UnionDefinition definition;

    public Union(UnionDefinition definition) {
        super(definition);
        this.definition = definition;
    }

    public WidgetDefinition getDefinition() {
        return this.definition;
    }

    public void initialize() {
        String caseWidgetId = this.definition.getCaseWidgetId();
        this.caseWidget = this.getParent().lookupWidget(caseWidgetId);
        if (this.caseWidget == null) {
            throw new FormsRuntimeException("Could not find case widget '" + caseWidgetId + "' for union '" + this.getId() + "'.", this.getLocation());
        }
        ((ValueChangedListenerEnabled)((Object)this.caseWidget)).addValueChangedListener(new ValueChangedListener(){

            public void valueChanged(ValueChangedEvent event) {
                String newValue = (String)event.getNewValue();
                if (!ObjectUtils.equals((Object)Union.this.caseValue, (Object)newValue)) {
                    Union.this.caseValue = newValue;
                    Union.this.getForm().addWidgetUpdate(Union.this);
                }
            }
        });
    }

    public String getXMLElementName() {
        return UNION_EL;
    }

    public Object getValue() {
        return this.caseWidget.getValue();
    }

    public void readFromRequest(FormContext formContext) {
        this.caseWidget.readFromRequest(formContext);
        String newValue = (String)this.getValue();
        if (newValue != null && !newValue.equals("")) {
            Widget widget;
            String fullId = this.caseWidget.getRequestParameterName();
            if (fullId.equals(formContext.getRequest().getParameter("forms_submit_id"))) {
                this.getForm().setSubmitWidget(this.caseWidget);
            }
            if ((widget = this.getForm().getSubmitWidget() == this.caseWidget && !newValue.equals(this.caseValue) ? this.getChild(this.caseValue) : this.getChild(newValue)) != null && this.getCombinedState().isAcceptingInputs()) {
                widget.readFromRequest(formContext);
            }
        }
        if (!ObjectUtils.equals((Object)this.caseValue, (Object)newValue)) {
            this.caseValue = newValue;
            this.getForm().addWidgetUpdate(this);
        }
    }

    public boolean validate() {
        Widget widget;
        if (!this.getCombinedState().isValidatingValues()) {
            this.wasValid = true;
            return true;
        }
        boolean valid = true;
        String value = (String)this.getValue();
        if (value != null && !value.equals("") && (widget = this.getChild(value)) != null) {
            valid &= widget.validate();
        }
        this.wasValid = valid;
        return valid;
    }

    public Widget getChild(String id) {
        if (!this.widgets.hasWidget(id) && this.definition.hasWidget(id)) {
            this.definition.createWidget(this, id);
            Widget child = super.getChild(id);
            child.initialize();
            return child;
        }
        return super.getChild(id);
    }
}

