/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel;

import org.apache.cocoon.environment.Request;
import org.apache.cocoon.forms.FormContext;
import org.apache.cocoon.forms.event.ActionEvent;
import org.apache.cocoon.forms.event.ActionListener;
import org.apache.cocoon.forms.event.ActionListenerEnabled;
import org.apache.cocoon.forms.event.ImageMapEvent;
import org.apache.cocoon.forms.event.WidgetEvent;
import org.apache.cocoon.forms.event.WidgetEventMulticaster;
import org.apache.cocoon.forms.formmodel.AbstractWidget;
import org.apache.cocoon.forms.formmodel.Form;
import org.apache.cocoon.forms.formmodel.ImageMapDefinition;
import org.apache.cocoon.forms.formmodel.WidgetDefinition;
import org.apache.cocoon.xml.AttributesImpl;

public class ImageMap
extends AbstractWidget
implements ActionListenerEnabled {
    public static final String COMMAND_AT = "command";
    public static final String VALUE_EL = "imageuri";
    public static final String ONACTION_EL = "on-action";
    public static final String IMAGEMAP_EL = "imagemap";
    private final ImageMapDefinition definition;
    private ActionListener listener;
    private String imgURI;
    private int x;
    private int y;

    public ImageMap(ImageMapDefinition definition) {
        super(definition);
        this.definition = definition;
        this.imgURI = definition.getImageURI();
        this.x = 0;
        this.y = 0;
    }

    public WidgetDefinition getDefinition() {
        return this.definition;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public String getImageURI() {
        if (this.imgURI != null) {
            return this.imgURI;
        }
        return "";
    }

    public void setImageURI(String newImgURI) {
        this.imgURI = newImgURI;
    }

    public void setValue(Object newImgURI) {
        this.setImageURI(newImgURI.toString());
    }

    public Object getValue() {
        return this.getImageURI();
    }

    public void readFromRequest(FormContext formContext) {
        if (!this.getCombinedState().isAcceptingInputs()) {
            return;
        }
        Form form = this.getForm();
        String fullId = this.getRequestParameterName();
        Request request = formContext.getRequest();
        try {
            this.x = new Integer(formContext.getRequest().getParameter(fullId + ".x"));
            this.y = new Integer(formContext.getRequest().getParameter(fullId + ".y"));
        }
        catch (NumberFormatException e) {
            this.x = 0;
            this.y = 0;
        }
        String value = request.getParameter(fullId);
        if (value != null && value.length() > 0) {
            form.setSubmitWidget(this);
        } else {
            value = request.getParameter(fullId + ".x");
            if (value != null && value.length() > 0) {
                form.setSubmitWidget(this);
            }
        }
        if (form.getSubmitWidget() == this) {
            form.addWidgetEvent(new ImageMapEvent(this, this.definition.getActionCommand()));
            this.handleActivate();
        }
    }

    public AttributesImpl getXMLElementAttributes() {
        AttributesImpl attrs = super.getXMLElementAttributes();
        attrs.addCDATAAttribute(VALUE_EL, this.imgURI);
        return attrs;
    }

    protected void handleActivate() {
        this.getForm().endProcessing(true);
    }

    public boolean validate() {
        return true;
    }

    public String getXMLElementName() {
        return IMAGEMAP_EL;
    }

    public void addActionListener(ActionListener listener) {
        this.listener = WidgetEventMulticaster.add(this.listener, listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listener = WidgetEventMulticaster.remove(this.listener, listener);
    }

    private void fireActionEvent(ActionEvent event) {
        if (this.listener != null) {
            this.listener.actionPerformed(event);
        }
    }

    public void broadcastEvent(WidgetEvent event) {
        if (event instanceof ActionEvent) {
            this.definition.fireActionEvent((ActionEvent)event);
            this.fireActionEvent((ActionEvent)event);
        } else {
            super.broadcastEvent(event);
        }
    }
}

