/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel;

import java.util.ArrayList;
import org.apache.cocoon.forms.formmodel.AbstractWidgetDefinitionBuilder;
import org.apache.cocoon.forms.formmodel.GoogleMapDefinition;
import org.apache.cocoon.forms.formmodel.GoogleMapMarker;
import org.apache.cocoon.forms.formmodel.GoogleMapValue;
import org.apache.cocoon.forms.formmodel.WidgetDefinition;
import org.apache.cocoon.forms.formmodel.WidgetDefinitionBuilderContext;
import org.apache.cocoon.forms.util.DomHelper;
import org.apache.excalibur.xml.sax.XMLizable;
import org.w3c.dom.Element;

public final class GoogleMapDefinitionBuilder
extends AbstractWidgetDefinitionBuilder {
    public WidgetDefinition buildWidgetDefinition(Element widgetElement, WidgetDefinitionBuilderContext context) throws Exception {
        GoogleMapDefinition definition = new GoogleMapDefinition();
        this.setupDefinition(widgetElement, definition, context);
        this.setDisplayData(widgetElement, definition);
        Element initialValueElement = DomHelper.getChildElement(widgetElement, "http://apache.org/cocoon/forms/1.0#definition", "initial-value", false);
        if (initialValueElement != null) {
            Element markersElement;
            GoogleMapValue googleMapValue = new GoogleMapValue();
            googleMapValue.setLng(Float.valueOf(initialValueElement.getAttribute("lng")).floatValue());
            googleMapValue.setLat(Float.valueOf(initialValueElement.getAttribute("lat")).floatValue());
            googleMapValue.setZoom(Integer.valueOf(initialValueElement.getAttribute("zoom")));
            Element userMarkerElement = DomHelper.getChildElement(initialValueElement, "http://apache.org/cocoon/forms/1.0#definition", "usermarker", false);
            if (userMarkerElement != null) {
                GoogleMapMarker usermarker = new GoogleMapMarker();
                usermarker.setLng(Float.valueOf(userMarkerElement.getAttribute("lng")).floatValue());
                usermarker.setLat(Float.valueOf(userMarkerElement.getAttribute("lat")).floatValue());
                googleMapValue.setUsermarker(usermarker);
            }
            if ((markersElement = DomHelper.getChildElement(initialValueElement, "http://apache.org/cocoon/forms/1.0#definition", "markers", false)) != null) {
                ArrayList<GoogleMapMarker> markers = new ArrayList<GoogleMapMarker>();
                Element[] markerElements = DomHelper.getChildElements(markersElement, "http://apache.org/cocoon/forms/1.0#definition", "marker");
                for (int i = 0; i < markerElements.length; ++i) {
                    Element markerElement = markerElements[i];
                    GoogleMapMarker googleMapMarker = new GoogleMapMarker();
                    googleMapMarker.setLng(Float.valueOf(markerElement.getAttribute("lng")).floatValue());
                    googleMapMarker.setLat(Float.valueOf(markerElement.getAttribute("lat")).floatValue());
                    XMLizable data = null;
                    Element dataElement = DomHelper.getChildElement(markerElement, "http://apache.org/cocoon/forms/1.0#definition", "text");
                    if (dataElement != null) {
                        data = DomHelper.compileElementContent(dataElement);
                    }
                    googleMapMarker.setText(data);
                    markers.add(googleMapMarker);
                }
                googleMapValue.setMarkers(markers);
            }
            googleMapValue.setCurrentMarker(-1);
            definition.setInitialValue(googleMapValue);
        }
        definition.makeImmutable();
        return definition;
    }
}

