/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel;

import java.util.ArrayList;
import org.apache.cocoon.forms.FormsException;
import org.apache.cocoon.forms.event.ProcessingPhaseEvent;
import org.apache.cocoon.forms.event.ProcessingPhaseListener;
import org.apache.cocoon.forms.event.WidgetEventMulticaster;
import org.apache.cocoon.forms.formmodel.AbstractContainerDefinition;
import org.apache.cocoon.forms.formmodel.DuplicateIdException;
import org.apache.cocoon.forms.formmodel.Form;
import org.apache.cocoon.forms.formmodel.Widget;
import org.apache.cocoon.forms.formmodel.WidgetDefinition;
import org.apache.cocoon.forms.formmodel.library.Library;
import org.apache.cocoon.forms.formmodel.library.LibraryManager;
import org.apache.commons.lang.StringUtils;

public class FormDefinition
extends AbstractContainerDefinition {
    private ProcessingPhaseListener listener;
    private Library localLibrary;

    public FormDefinition(LibraryManager libraryManager) {
        this.localLibrary = libraryManager.newLibrary();
    }

    public Library getLocalLibrary() {
        return this.localLibrary;
    }

    public void resolve() throws Exception {
        ArrayList<FormDefinition> parents = new ArrayList<FormDefinition>();
        parents.add(this);
        this.resolve(parents, this);
        this.checkCompleteness();
    }

    public Widget createInstance() {
        Form form = new Form(this);
        this.createWidgets(form);
        return form;
    }

    public void addProcessingPhaseListener(ProcessingPhaseListener listener) {
        this.listener = WidgetEventMulticaster.add(this.listener, listener);
    }

    public boolean hasProcessingPhaseListeners() {
        return this.listener != null;
    }

    public void fireEvent(ProcessingPhaseEvent event) {
        if (this.listener != null) {
            this.listener.phaseEnded(event);
        }
    }

    public void addWidgetDefinition(WidgetDefinition definition) throws Exception, DuplicateIdException {
        if ("submit".equals(definition.getId()) && StringUtils.isEmpty((String)this.getId())) {
            throw new FormsException("Top-level widgets should not be named 'submit' to avoid problems with HTML <form> elements.", definition.getLocation());
        }
        super.addWidgetDefinition(definition);
    }

    public ProcessingPhaseListener getProcessingPhaseListener() {
        return this.listener;
    }
}

