/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel;

import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.cocoon.forms.FormContext;
import org.apache.cocoon.forms.event.FormHandler;
import org.apache.cocoon.forms.event.ProcessingPhase;
import org.apache.cocoon.forms.event.ProcessingPhaseEvent;
import org.apache.cocoon.forms.event.ProcessingPhaseListener;
import org.apache.cocoon.forms.event.WidgetEvent;
import org.apache.cocoon.forms.event.WidgetEventMulticaster;
import org.apache.cocoon.forms.formmodel.AbstractContainerWidget;
import org.apache.cocoon.forms.formmodel.Action;
import org.apache.cocoon.forms.formmodel.FormDefinition;
import org.apache.cocoon.forms.formmodel.Widget;
import org.apache.cocoon.forms.formmodel.WidgetDefinition;
import org.apache.cocoon.forms.formmodel.WidgetState;
import org.apache.cocoon.forms.validation.ValidationError;
import org.apache.cocoon.forms.validation.ValidationErrorAware;
import org.apache.commons.collections.list.CursorableLinkedList;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;

public class Form
extends AbstractContainerWidget
implements ValidationErrorAware {
    public static final String SUBMIT_ID_PARAMETER = "forms_submit_id";
    private static final String FORM_EL = "form";
    private final FormDefinition definition;
    private Boolean endProcessing;
    private Locale locale = Locale.getDefault();
    private FormHandler formHandler;
    private Widget submitWidget;
    private boolean isValid;
    private ProcessingPhaseListener listener;
    private boolean bufferEvents;
    private CursorableLinkedList events;
    private Set updatedWidgets;
    private Set childUpdatedWidgets;
    private String id;

    public Form(FormDefinition definition) {
        super(definition);
        this.definition = definition;
        this.listener = definition.getProcessingPhaseListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        try {
            this.bufferEvents = true;
            super.initialize();
            this.fireEvents();
        }
        finally {
            this.bufferEvents = false;
        }
    }

    public WidgetDefinition getDefinition() {
        return this.definition;
    }

    public void addWidgetEvent(WidgetEvent event) {
        if (this.bufferEvents) {
            if (this.events == null) {
                this.events = new CursorableLinkedList();
            }
            this.events.add((Object)event);
        } else {
            event.getSourceWidget().broadcastEvent(event);
        }
    }

    public boolean addWidgetUpdate(Widget widget) {
        if (this.updatedWidgets != null && this.updatedWidgets.add(widget.getRequestParameterName())) {
            for (Widget parent = widget.getParent(); parent != this && parent != null && this.childUpdatedWidgets.add(parent.getRequestParameterName()); parent = parent.getParent()) {
            }
            return true;
        }
        return false;
    }

    public Set getUpdatedWidgetIds() {
        return this.updatedWidgets;
    }

    public Set getChildUpdatedWidgetIds() {
        return this.childUpdatedWidgets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvents() {
        if (this.events != null) {
            try {
                CursorableLinkedList.Cursor cursor = this.events.cursor();
                while (cursor.hasNext()) {
                    WidgetEvent event = (WidgetEvent)cursor.next();
                    event.getSourceWidget().broadcastEvent(event);
                    if (this.formHandler == null) continue;
                    this.formHandler.handleEvent(event);
                }
                cursor.close();
            }
            finally {
                this.events.clear();
            }
        }
    }

    public void informStartLoadingModel() {
    }

    public void informEndLoadingModel() {
        if (this.listener != null) {
            this.listener.phaseEnded(new ProcessingPhaseEvent(this, ProcessingPhase.LOAD_MODEL));
        }
    }

    public void informStartSavingModel() {
    }

    public void informEndSavingModel() {
        if (this.listener != null) {
            this.listener.phaseEnded(new ProcessingPhaseEvent(this, ProcessingPhase.SAVE_MODEL));
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Widget getSubmitWidget() {
        return this.submitWidget;
    }

    public void setSubmitWidget(Widget widget) {
        if (this.submitWidget == widget) {
            return;
        }
        if (this.submitWidget != null) {
            throw new IllegalStateException("Submit widget already set to " + this.submitWidget + ". Cannot set also " + widget);
        }
        if (widget.getCombinedState() != WidgetState.ACTIVE) {
            throw new IllegalStateException("Widget " + widget + " that submitted the form is not active.");
        }
        if (!(widget instanceof Action)) {
            this.endProcessing(true);
        }
        this.submitWidget = widget;
    }

    public boolean hasFormHandler() {
        return this.formHandler != null;
    }

    public void setFormHandler(FormHandler formHandler) {
        this.formHandler = formHandler;
    }

    public void addProcessingPhaseListener(ProcessingPhaseListener listener) {
        this.listener = WidgetEventMulticaster.add(this.listener, listener);
    }

    public void removeProcessingPhaseListener(ProcessingPhaseListener listener) {
        this.listener = WidgetEventMulticaster.remove(this.listener, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean process(FormContext formContext) {
        if (formContext.getRequest().getParameter("cocoon-ajax") != null) {
            this.updatedWidgets = new HashSet();
            this.childUpdatedWidgets = new HashSet();
        }
        this.fireEvents();
        this.submitWidget = null;
        this.locale = formContext.getLocale();
        this.endProcessing = null;
        this.isValid = false;
        if (this.listener != null) {
            this.listener.phaseEnded(new ProcessingPhaseEvent(this, ProcessingPhase.PROCESSING_INITIALIZE));
        }
        try {
            String submitId;
            this.bufferEvents = true;
            this.submitWidget = null;
            this.doReadFromRequest(formContext);
            if (this.getSubmitWidget() == null && !StringUtils.isEmpty((String)(submitId = formContext.getRequest().getParameter(SUBMIT_ID_PARAMETER)))) {
                Widget submit;
                if (!StringUtils.isEmpty((String)this.getId())) {
                    submitId = submitId.substring(submitId.indexOf(46) + 1);
                }
                if ((submit = this.lookupWidget(submitId.replace('.', '/'))) == null) {
                    throw new IllegalArgumentException("Invalid submit id (no such widget): " + submitId);
                }
                this.setSubmitWidget(submit);
            }
            this.fireEvents();
        }
        finally {
            this.bufferEvents = false;
        }
        if (this.listener != null) {
            this.listener.phaseEnded(new ProcessingPhaseEvent(this, ProcessingPhase.READ_FROM_REQUEST));
        }
        if (this.endProcessing != null) {
            return this.endProcessing;
        }
        return this.validate();
    }

    public void endProcessing(boolean redisplayForm) {
        this.endProcessing = BooleanUtils.toBooleanObject((!redisplayForm ? 1 : 0) != 0);
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void readFromRequest(FormContext formContext) {
        throw new UnsupportedOperationException("Please use Form.process()");
    }

    private void doReadFromRequest(FormContext formContext) {
        super.readFromRequest(formContext);
    }

    public ValidationError getValidationError() {
        return this.validationError;
    }

    public void setValidationError(ValidationError error) {
        this.validationError = error;
    }

    public boolean validate() {
        this.isValid = super.validate();
        if (this.endProcessing != null) {
            this.wasValid = this.endProcessing;
            return this.wasValid;
        }
        if (this.listener != null) {
            this.listener.phaseEnded(new ProcessingPhaseEvent(this, ProcessingPhase.VALIDATE));
        }
        if (this.endProcessing != null) {
            this.isValid = false;
            this.wasValid = this.endProcessing;
            return this.wasValid;
        }
        this.wasValid = this.isValid && this.validationError == null;
        return this.wasValid;
    }

    public String getXMLElementName() {
        return FORM_EL;
    }

    public String getId() {
        if (this.id != null) {
            return this.id;
        }
        return super.getId();
    }

    public void setId(String value) {
        this.id = value;
    }
}

