/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel;

import org.apache.cocoon.forms.FormsException;
import org.apache.cocoon.forms.datatype.SelectionList;
import org.apache.cocoon.forms.formmodel.AbstractDatatypeWidgetDefinitionBuilder;
import org.apache.cocoon.forms.formmodel.FieldDefinition;
import org.apache.cocoon.forms.formmodel.Whitespace;
import org.apache.cocoon.forms.formmodel.WidgetDefinition;
import org.apache.cocoon.forms.formmodel.WidgetDefinitionBuilderContext;
import org.apache.cocoon.forms.util.DomHelper;
import org.w3c.dom.Element;

public class FieldDefinitionBuilder
extends AbstractDatatypeWidgetDefinitionBuilder {
    public WidgetDefinition buildWidgetDefinition(Element widgetElement, WidgetDefinitionBuilderContext context) throws Exception {
        FieldDefinition definition = new FieldDefinition();
        this.setupDefinition(widgetElement, definition, context);
        definition.makeImmutable();
        return definition;
    }

    protected void setupDefinition(Element widgetElement, FieldDefinition definition, WidgetDefinitionBuilderContext context) throws Exception {
        Whitespace whitespace;
        super.setupDefinition(widgetElement, definition, context);
        if (widgetElement.hasAttribute("required")) {
            definition.setRequired(DomHelper.getAttributeAsBoolean(widgetElement, "required", false));
        }
        if ((whitespace = Whitespace.getEnum(DomHelper.getAttribute(widgetElement, "whitespace", "trim"))) == null) {
            throw new FormsException("Unknown value for 'whitespace' attribute; valid values are 'trim', 'trim-start', 'trim-end', and 'preserve'.", DomHelper.getLocationObject(widgetElement));
        }
        definition.setWhitespaceTrim(whitespace);
        SelectionList list = this.buildSelectionList(widgetElement, definition, "suggestion-list");
        if (list != null) {
            definition.setSuggestionList(list);
        }
    }
}

