/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel;

import java.util.Locale;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.forms.FormContext;
import org.apache.cocoon.forms.FormsRuntimeException;
import org.apache.cocoon.forms.datatype.Datatype;
import org.apache.cocoon.forms.datatype.SelectionList;
import org.apache.cocoon.forms.datatype.convertor.ConversionResult;
import org.apache.cocoon.forms.event.DeferredValueChangedEvent;
import org.apache.cocoon.forms.event.ValueChangedEvent;
import org.apache.cocoon.forms.event.ValueChangedListener;
import org.apache.cocoon.forms.event.ValueChangedListenerEnabled;
import org.apache.cocoon.forms.event.WidgetEvent;
import org.apache.cocoon.forms.event.WidgetEventMulticaster;
import org.apache.cocoon.forms.formmodel.AbstractWidget;
import org.apache.cocoon.forms.formmodel.DataWidget;
import org.apache.cocoon.forms.formmodel.ExpressionContextImpl;
import org.apache.cocoon.forms.formmodel.FieldDefinition;
import org.apache.cocoon.forms.formmodel.SelectableWidget;
import org.apache.cocoon.forms.formmodel.Whitespace;
import org.apache.cocoon.forms.formmodel.WidgetDefinition;
import org.apache.cocoon.forms.util.I18nMessage;
import org.apache.cocoon.forms.validation.ValidationError;
import org.apache.cocoon.forms.validation.ValidationErrorAware;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class Field
extends AbstractWidget
implements ValidationErrorAware,
DataWidget,
SelectableWidget,
ValueChangedListenerEnabled {
    public static final String SUGGESTED_LABEL_ATTR = "suggested-label";
    protected static final int VALUE_UNPARSED = 0;
    protected static final int VALUE_PARSED = 1;
    protected static final int VALUE_PARSE_ERROR = 2;
    protected static final int VALUE_DISPLAY_PARSE_ERROR = 3;
    protected static final int VALUE_VALIDATING = 4;
    protected static final int VALUE_VALIDATED = 5;
    protected static final int VALUE_DISPLAY_VALIDATION = 6;
    private static final String FIELD_EL = "field";
    private static final String VALUE_EL = "value";
    private static final String VALIDATION_MSG_EL = "validation-message";
    private final FieldDefinition definition;
    protected SelectionList selectionList;
    private ValueChangedListener listener;
    protected String enteredValue;
    protected Object value;
    protected boolean required;
    protected int valueState = 1;
    protected ValidationError validationError;

    public Field(FieldDefinition fieldDefinition) {
        super(fieldDefinition);
        this.definition = fieldDefinition;
        this.listener = fieldDefinition.getValueChangedListener();
        this.valueState = 1;
    }

    public WidgetDefinition getDefinition() {
        return this.definition;
    }

    public final FieldDefinition getFieldDefinition() {
        return this.definition;
    }

    public void initialize() {
        Object value = this.definition.getInitialValue();
        if (value != null) {
            this.setValue(value);
        }
        this.selectionList = this.definition.getSelectionList();
        this.required = this.definition.isRequired();
        super.initialize();
    }

    public boolean isSuggested() {
        return this.getAttribute(SUGGESTED_LABEL_ATTR) != null;
    }

    public void setSuggestionLabel(String label) {
        if (this.definition.getSuggestionList() == null) {
            throw new FormsRuntimeException("Field '" + this.getRequestParameterName() + "' has no suggestion list.", this.getLocation());
        }
        this.setAttribute(SUGGESTED_LABEL_ATTR, label);
    }

    public String getSuggestionLabel() {
        return (String)this.getAttribute(SUGGESTED_LABEL_ATTR);
    }

    public Object getValue() {
        if (this.valueState == 4) {
            return this.value;
        }
        ValidationError oldError = this.validationError;
        if (this.valueState == 0) {
            this.doParse();
        }
        if (this.valueState == 1) {
            this.doValidate();
        }
        if (oldError != null && this.validationError == null) {
            this.getForm().addWidgetUpdate(this);
        }
        return this.validationError == null ? this.value : null;
    }

    public void setValue(Object newValue) {
        boolean changed;
        if (newValue != null && !this.getDatatype().getTypeClass().isAssignableFrom(newValue.getClass())) {
            throw new FormsRuntimeException("Incorrect value type for '" + this.getRequestParameterName() + "'. Expected " + this.getDatatype().getTypeClass() + ", got " + newValue.getClass() + ").", this.getLocation());
        }
        if (this.valueState == 0) {
            changed = true;
        } else if (this.value == null) {
            changed = newValue != null;
        } else {
            boolean bl = changed = !this.value.equals(newValue);
        }
        if (changed || newValue == null) {
            boolean callListeners = changed && (this.hasValueChangedListeners() || this.getForm().hasFormHandler());
            Object oldValue = callListeners ? this.getValue() : null;
            this.value = newValue;
            this.validationError = null;
            this.valueState = 1;
            this.enteredValue = newValue != null ? this.getDatatype().convertToString(newValue, this.getForm().getLocale()) : null;
            if (callListeners) {
                this.getForm().addWidgetEvent(new ValueChangedEvent(this, oldValue, newValue));
            }
            this.getForm().addWidgetUpdate(this);
        }
    }

    public void readFromRequest(FormContext formContext) {
        if (!this.getCombinedState().isAcceptingInputs()) {
            return;
        }
        String paramName = this.getRequestParameterName();
        Request request = formContext.getRequest();
        String newEnteredValue = request.getParameter(paramName);
        if (this.definition.getSuggestionList() != null) {
            String selectedValue = request.getParameter(paramName + "_selected");
            if (StringUtils.isNotEmpty((String)selectedValue)) {
                this.setSuggestionLabel(newEnteredValue);
                newEnteredValue = selectedValue;
            } else {
                this.removeAttribute(SUGGESTED_LABEL_ATTR);
            }
        }
        this.readFromRequest(newEnteredValue);
    }

    protected void readFromRequest(String newEnteredValue) {
        boolean changed;
        newEnteredValue = this.applyWhitespaceTrim(newEnteredValue);
        if (this.enteredValue == null) {
            changed = newEnteredValue != null;
        } else {
            boolean bl = changed = !this.enteredValue.equals(newEnteredValue);
        }
        if (changed) {
            ValidationError oldError = this.validationError;
            boolean hasListeners = this.hasValueChangedListeners() || this.getForm().hasFormHandler();
            Object oldValue = hasListeners ? this.getValue() : null;
            this.enteredValue = newEnteredValue;
            this.validationError = null;
            this.value = null;
            this.valueState = 0;
            if (hasListeners) {
                this.getForm().addWidgetEvent(new DeferredValueChangedEvent(this, oldValue));
            }
            if (oldError != null) {
                this.getForm().addWidgetUpdate(this);
            }
        }
    }

    protected String applyWhitespaceTrim(String value) {
        if (value != null) {
            Whitespace trim = this.definition.getWhitespaceTrim();
            if (trim == null || trim == Whitespace.TRIM) {
                value = value.trim();
            } else if (trim != Whitespace.PRESERVE) {
                if (trim == Whitespace.TRIM_START) {
                    value = StringUtils.stripStart((String)value, null);
                } else if (trim == Whitespace.TRIM_END) {
                    value = StringUtils.stripEnd((String)value, null);
                }
            }
            if (value.length() == 0) {
                value = null;
            }
        }
        return value;
    }

    public boolean validate() {
        if (!this.getCombinedState().isValidatingValues()) {
            this.wasValid = true;
            return true;
        }
        if (this.valueState == 0) {
            this.doParse();
        }
        if (this.valueState >= 5) {
            this.valueState = 1;
        }
        if (this.valueState == 1) {
            this.doValidate();
            this.valueState = 6;
            if (this.validationError != null) {
                this.getForm().addWidgetUpdate(this);
            }
        } else if (this.valueState == 2) {
            this.valueState = 3;
            this.getForm().addWidgetUpdate(this);
        }
        this.wasValid = this.validationError == null;
        return this.wasValid;
    }

    private void doParse() {
        if (this.valueState != 0) {
            throw new IllegalStateException("Field is not in UNPARSED state (" + this.valueState + ")");
        }
        this.value = null;
        this.validationError = null;
        if (this.enteredValue != null) {
            ConversionResult conversionResult = this.getDatatype().convertFromString(this.enteredValue, this.getForm().getLocale());
            if (conversionResult.isSuccessful()) {
                this.value = conversionResult.getResult();
                this.valueState = 1;
            } else {
                this.validationError = conversionResult.getValidationError();
                this.valueState = 2;
            }
        } else {
            this.valueState = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doValidate() {
        if (this.valueState != 1) {
            throw new IllegalStateException("Field is not in PARSED state (" + this.valueState + ")");
        }
        this.valueState = 4;
        this.validationError = null;
        try {
            if (this.value == null && this.required) {
                this.validationError = new ValidationError(new I18nMessage("general.field-required", "forms"));
            } else if (!super.validate()) {
            } else if (this.value != null) {
                this.validationError = this.getDatatype().validate(this.value, new ExpressionContextImpl(this));
            }
        }
        finally {
            this.valueState = 5;
        }
    }

    public ValidationError getValidationError() {
        return this.validationError;
    }

    public void setValidationError(ValidationError error) {
        if (this.valueState >= 5) {
            this.valueState = 6;
        }
        if (!ObjectUtils.equals((Object)this.validationError, (Object)error)) {
            this.validationError = error;
            this.getForm().addWidgetUpdate(this);
        }
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
        this.getForm().addWidgetUpdate(this);
    }

    public String getXMLElementName() {
        return FIELD_EL;
    }

    public AttributesImpl getXMLElementAttributes() {
        AttributesImpl attrs = super.getXMLElementAttributes();
        attrs.addCDATAAttribute("required", String.valueOf(this.isRequired()));
        return attrs;
    }

    public void generateItemSaxFragment(ContentHandler contentHandler, Locale locale) throws SAXException {
        String suggestedLabel;
        if (locale == null) {
            locale = this.getForm().getLocale();
        }
        if (this.enteredValue != null || this.value != null) {
            contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", VALUE_EL, "fi:value", XMLUtils.EMPTY_ATTRIBUTES);
            String stringValue = this.value != null ? this.getDatatype().convertToString(this.value, locale) : this.enteredValue;
            contentHandler.characters(stringValue.toCharArray(), 0, stringValue.length());
            contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", VALUE_EL, "fi:value");
        }
        if ((suggestedLabel = this.getSuggestionLabel()) != null) {
            contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", "suggestion", "fi:suggestion", XMLUtils.EMPTY_ATTRIBUTES);
            contentHandler.characters(suggestedLabel.toCharArray(), 0, suggestedLabel.length());
            contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", "suggestion", "fi:suggestion");
        }
        if (this.validationError != null && (this.valueState == 6 || this.valueState == 3)) {
            contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", VALIDATION_MSG_EL, "fi:validation-message", XMLUtils.EMPTY_ATTRIBUTES);
            this.validationError.generateSaxFragment(contentHandler);
            contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", VALIDATION_MSG_EL, "fi:validation-message");
        }
        if (this.selectionList != null) {
            this.selectionList.generateSaxFragment(contentHandler, locale);
        }
        this.definition.getDatatype().generateSaxFragment(contentHandler, locale);
    }

    public void setSelectionList(SelectionList selectionList) {
        if (selectionList != null && selectionList.getDatatype() != null && selectionList.getDatatype() != this.getDatatype()) {
            throw new RuntimeException("Tried to assign a SelectionList that is not associated with this widget's datatype.");
        }
        this.selectionList = selectionList;
        this.getForm().addWidgetUpdate(this);
    }

    public void setSelectionList(String uri) {
        this.setSelectionList(this.getFieldDefinition().buildSelectionList(uri));
    }

    public void setSelectionList(Object model, String valuePath, String labelPath) {
        this.setSelectionList(this.getFieldDefinition().buildSelectionListFromModel(model, valuePath, labelPath));
    }

    public SelectionList getSuggestionList() {
        return this.getFieldDefinition().getSuggestionList();
    }

    public Datatype getDatatype() {
        return this.getFieldDefinition().getDatatype();
    }

    public void addValueChangedListener(ValueChangedListener listener) {
        this.listener = WidgetEventMulticaster.add(this.listener, listener);
    }

    public void removeValueChangedListener(ValueChangedListener listener) {
        this.listener = WidgetEventMulticaster.remove(this.listener, listener);
    }

    public boolean hasValueChangedListeners() {
        return this.listener != null;
    }

    public void broadcastEvent(WidgetEvent event) {
        if (event instanceof ValueChangedEvent) {
            if (this.listener != null) {
                this.listener.valueChanged((ValueChangedEvent)event);
            }
        } else {
            super.broadcastEvent(event);
        }
    }
}

