/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel;

import java.util.Map;
import org.apache.cocoon.forms.formmodel.CalculatedFieldAlgorithmBuilder;
import org.apache.cocoon.forms.formmodel.CalculatedFieldDefinition;
import org.apache.cocoon.forms.formmodel.FieldDefinitionBuilder;
import org.apache.cocoon.forms.formmodel.WidgetDefinition;
import org.apache.cocoon.forms.formmodel.WidgetDefinitionBuilderContext;
import org.apache.cocoon.forms.util.DomHelper;
import org.w3c.dom.Element;

public class CalculatedFieldDefinitionBuilder
extends FieldDefinitionBuilder {
    private Map calculatedFieldAlgorithmBuilders;
    private String defaultCalculatedFieldAlgorithmBuilder;

    public WidgetDefinition buildWidgetDefinition(Element widgetElement, WidgetDefinitionBuilderContext context) throws Exception {
        CalculatedFieldDefinition definition = new CalculatedFieldDefinition();
        this.setupDefinition(widgetElement, definition, context);
        definition.makeImmutable();
        return definition;
    }

    protected void setupDefinition(Element widgetElement, CalculatedFieldDefinition definition, WidgetDefinitionBuilderContext context) throws Exception {
        CalculatedFieldAlgorithmBuilder builder;
        super.setupDefinition(widgetElement, definition, context);
        Element algorithmElement = DomHelper.getChildElement(widgetElement, "http://apache.org/cocoon/forms/1.0#definition", "value");
        String algorithmType = algorithmElement.getAttribute("type");
        if (algorithmType.length() == 0) {
            algorithmType = this.defaultCalculatedFieldAlgorithmBuilder;
        }
        if ((builder = (CalculatedFieldAlgorithmBuilder)this.calculatedFieldAlgorithmBuilders.get(algorithmType)) == null) {
            throw new Exception("Unknown algorightm " + algorithmType);
        }
        definition.setAlgorithm(builder.build(algorithmElement));
    }

    public void setCalculatedFieldAlgorithmBuilders(Map calculatedFieldAlgorithmBuilders) {
        this.calculatedFieldAlgorithmBuilders = calculatedFieldAlgorithmBuilders;
    }

    public void setDefaultCalculatedFieldAlgorithmBuilder(String defaultCalculatedFieldAlgorithmBuilder) {
        this.defaultCalculatedFieldAlgorithmBuilder = defaultCalculatedFieldAlgorithmBuilder;
    }
}

