/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel;

import org.apache.cocoon.forms.FormsException;
import org.apache.cocoon.forms.formmodel.AggregateFieldDefinition;
import org.apache.cocoon.forms.formmodel.FieldDefinition;
import org.apache.cocoon.forms.formmodel.FieldDefinitionBuilder;
import org.apache.cocoon.forms.formmodel.WidgetDefinition;
import org.apache.cocoon.forms.formmodel.WidgetDefinitionBuilderContext;
import org.apache.cocoon.forms.util.DomHelper;
import org.apache.excalibur.xml.sax.XMLizable;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.outerj.expression.Expression;
import org.w3c.dom.Element;

public class AggregateFieldDefinitionBuilder
extends FieldDefinitionBuilder {
    public WidgetDefinition buildWidgetDefinition(Element widgetElement, WidgetDefinitionBuilderContext context) throws Exception {
        AggregateFieldDefinition definition = new AggregateFieldDefinition();
        this.setupDefinition(widgetElement, definition, context);
        definition.makeImmutable();
        return definition;
    }

    protected void setupDefinition(Element widgetElement, AggregateFieldDefinition definition, WidgetDefinitionBuilderContext context) throws Exception {
        Element combineElement;
        super.setupDefinition(widgetElement, definition, context);
        Element widgetsElement = DomHelper.getChildElement(widgetElement, "http://apache.org/cocoon/forms/1.0#definition", "widgets", true);
        Element[] fieldElements = DomHelper.getChildElements(widgetsElement, "http://apache.org/cocoon/forms/1.0#definition", "field");
        for (int i = 0; i < fieldElements.length; ++i) {
            FieldDefinition fd = (FieldDefinition)this.buildAnotherWidgetDefinition(fieldElements[i], context);
            definition.addWidgetDefinition(fd);
        }
        Element splitElement = DomHelper.getChildElement(widgetElement, "http://apache.org/cocoon/forms/1.0#definition", "split", true);
        if (splitElement != null) {
            Pattern pattern;
            String patternString = DomHelper.getAttribute(splitElement, "pattern");
            Perl5Compiler compiler = new Perl5Compiler();
            try {
                pattern = compiler.compile(patternString, 32768);
            }
            catch (MalformedPatternException e) {
                throw new FormsException("Invalid regular expression '" + patternString + "'.", e, DomHelper.getLocationObject(splitElement));
            }
            definition.setSplitPattern(pattern, patternString);
        }
        Element[] mapElements = DomHelper.getChildElements(splitElement, "http://apache.org/cocoon/forms/1.0#definition", "map");
        for (int i = 0; i < mapElements.length; ++i) {
            int group = DomHelper.getAttributeAsInteger(mapElements[i], "group");
            String field = DomHelper.getAttribute(mapElements[i], "field");
            if (!definition.hasWidget(field)) {
                throw new FormsException("Unknown widget id '" + field + "' referenced.", DomHelper.getLocationObject(mapElements[i]));
            }
            try {
                definition.addSplitMapping(group, field);
                continue;
            }
            catch (RuntimeException e) {
                throw new FormsException("Two groups are mapped to the same widget id '" + field + "'.", DomHelper.getLocationObject(mapElements[i]));
            }
        }
        Element failMessageElement = DomHelper.getChildElement(splitElement, "http://apache.org/cocoon/forms/1.0#definition", "failmessage");
        if (failMessageElement != null) {
            XMLizable failMessage = DomHelper.compileElementContent(failMessageElement);
            definition.setSplitFailMessage(failMessage);
        }
        if ((combineElement = DomHelper.getChildElement(widgetElement, "http://apache.org/cocoon/forms/1.0#definition", "combine", true)) != null) {
            Expression combineExpr;
            String combineExprString = DomHelper.getAttribute(combineElement, "expression");
            try {
                combineExpr = this.expressionManager.parse(combineExprString);
            }
            catch (Exception e) {
                throw new FormsException("Invalid combine expression '" + combineExprString + "'.", e, DomHelper.getLocationObject(combineElement));
            }
            Class clazz = definition.getDatatype().getTypeClass();
            if (combineExpr.getResultType() != null && !clazz.isAssignableFrom(combineExpr.getResultType())) {
                throw new FormsException("The result of the combine expression should be '" + clazz.getName() + "', not '" + combineExpr.getResultType().getName() + "'.", DomHelper.getLocationObject(combineElement));
            }
            definition.setCombineExpression(combineExpr);
        }
    }
}

