/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cocoon.forms.FormContext;
import org.apache.cocoon.forms.formmodel.AggregateFieldDefinition;
import org.apache.cocoon.forms.formmodel.CannotYetResolveWarning;
import org.apache.cocoon.forms.formmodel.ContainerWidget;
import org.apache.cocoon.forms.formmodel.ExpressionContextImpl;
import org.apache.cocoon.forms.formmodel.Field;
import org.apache.cocoon.forms.formmodel.Widget;
import org.apache.cocoon.forms.util.I18nMessage;
import org.apache.cocoon.forms.validation.ValidationError;
import org.apache.excalibur.xml.sax.XMLizable;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Perl5Matcher;
import org.outerj.expression.ExpressionContext;
import org.outerj.expression.ExpressionException;

public class AggregateField
extends Field
implements ContainerWidget {
    private static final String AGGREGATEFIELD_EL = "aggregatefield";
    private List fields = new ArrayList();
    private Map fieldsById = new HashMap();

    public AggregateField(AggregateFieldDefinition definition) {
        super(definition);
    }

    public final AggregateFieldDefinition getAggregateFieldDefinition() {
        return (AggregateFieldDefinition)this.getDefinition();
    }

    public void initialize() {
        this.selectionList = this.getAggregateFieldDefinition().getSelectionList();
        Iterator it = this.getChildren();
        while (it.hasNext()) {
            ((Widget)it.next()).initialize();
        }
    }

    public void addChild(Widget widget) {
        if (!(widget instanceof Field)) {
            throw new IllegalArgumentException("AggregateField can only contain fields.");
        }
        this.addField((Field)widget);
    }

    protected void addField(Field field) {
        field.setParent(this);
        this.fields.add(field);
        this.fieldsById.put(field.getId(), field);
    }

    public boolean hasChild(String id) {
        return this.fieldsById.containsKey(id);
    }

    public Iterator getChildren() {
        return this.fields.iterator();
    }

    public void readFromRequest(FormContext formContext) {
        if (!this.getCombinedState().isAcceptingInputs()) {
            return;
        }
        String newEnteredValue = formContext.getRequest().getParameter(this.getRequestParameterName());
        if (newEnteredValue != null) {
            super.readFromRequest(formContext);
            if (this.valueState == 0) {
                this.setFieldsValues(this.enteredValue);
            }
        } else {
            Iterator i = this.fields.iterator();
            while (i.hasNext()) {
                Field field = (Field)i.next();
                field.readFromRequest(formContext);
                if (field.valueState != 0) continue;
                this.valueState = 0;
            }
            if (this.valueState == 0) {
                this.combineFields();
            }
        }
    }

    public void setValue(Object newValue) {
        super.setValue(newValue);
        if (this.valueState == 1) {
            this.setFieldsValues(this.enteredValue);
        }
    }

    private boolean fieldsHaveValues() {
        Iterator i = this.fields.iterator();
        while (i.hasNext()) {
            Field field = (Field)i.next();
            if (field.getValue() == null) continue;
            return true;
        }
        return false;
    }

    private void setFieldsValues(String value) {
        if (value == null) {
            this.resetFieldsValues();
        } else {
            Perl5Matcher matcher = new Perl5Matcher();
            if (matcher.matches(value, this.getAggregateFieldDefinition().getSplitPattern())) {
                MatchResult matchResult = matcher.getMatch();
                Iterator iterator = this.getAggregateFieldDefinition().getSplitMappingsIterator();
                while (iterator.hasNext()) {
                    AggregateFieldDefinition.SplitMapping splitMapping = (AggregateFieldDefinition.SplitMapping)iterator.next();
                    String result = matchResult.group(splitMapping.getGroup());
                    Field field = (Field)this.fieldsById.get(splitMapping.getFieldId());
                    field.readFromRequest(result);
                }
            } else {
                this.resetFieldsValues();
            }
        }
    }

    public void combineFields() {
        try {
            Object value = this.getAggregateFieldDefinition().getCombineExpression().evaluate((ExpressionContext)new ExpressionContextImpl(this, true));
            super.setValue(value);
        }
        catch (CannotYetResolveWarning e) {
            super.setValue(null);
        }
        catch (ExpressionException e) {
            super.setValue(null);
        }
        catch (ClassCastException e) {
            super.setValue(null);
        }
    }

    private void resetFieldsValues() {
        Iterator i = this.fields.iterator();
        while (i.hasNext()) {
            Field field = (Field)i.next();
            field.setValue(null);
        }
    }

    public boolean validate() {
        if (!this.getCombinedState().isValidatingValues()) {
            this.wasValid = true;
            return true;
        }
        if (this.enteredValue != null && !this.fieldsHaveValues()) {
            XMLizable failMessage = this.getAggregateFieldDefinition().getSplitFailMessage();
            this.validationError = failMessage != null ? new ValidationError(failMessage) : new ValidationError(new I18nMessage("aggregatedfield.split-failed", new String[]{this.getAggregateFieldDefinition().getSplitRegexp()}, "forms"));
            this.valueState = 6;
            this.wasValid = false;
            return false;
        }
        boolean valid = true;
        Iterator i = this.fields.iterator();
        while (i.hasNext()) {
            Field field = (Field)i.next();
            if (field.validate()) continue;
            this.validationError = field.getValidationError();
            valid = false;
        }
        if (!valid) {
            this.valueState = 6;
            this.wasValid = false;
            return false;
        }
        return super.validate();
    }

    public String getXMLElementName() {
        return AGGREGATEFIELD_EL;
    }

    public Widget getChild(String id) {
        return (Widget)this.fieldsById.get(id);
    }
}

